/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated code. Do not edit.

package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import java.util.Optional;

/**
 * Code generated by the model that is meant to be executed, and the result returned to the model.
 * Generated when using the [CodeExecution] tool, in which the code will be automatically executed,
 * and a corresponding [CodeExecutionResult] will also be generated.
 */
@AutoValue
@JsonDeserialize(builder = ExecutableCode.Builder.class)
public abstract class ExecutableCode extends JsonSerializable {
  /** Required. The code to be executed. */
  @JsonProperty("code")
  public abstract Optional<String> code();

  /** Required. Programming language of the `code`. */
  @JsonProperty("language")
  public abstract Optional<Language> language();

  /** Instantiates a builder for ExecutableCode. */
  @ExcludeFromGeneratedCoverageReport
  public static Builder builder() {
    return new AutoValue_ExecutableCode.Builder();
  }

  /** Creates a builder with the same values as this instance. */
  public abstract Builder toBuilder();

  /** Builder for ExecutableCode. */
  @AutoValue.Builder
  public abstract static class Builder {
    /** For internal usage. Please use `ExecutableCode.builder()` for instantiation. */
    @JsonCreator
    private static Builder create() {
      return new AutoValue_ExecutableCode.Builder();
    }

    /**
     * Setter for code.
     *
     * <p>code: Required. The code to be executed.
     */
    @JsonProperty("code")
    public abstract Builder code(String code);

    /**
     * Setter for language.
     *
     * <p>language: Required. Programming language of the `code`.
     */
    @JsonProperty("language")
    public abstract Builder language(Language language);

    /**
     * Setter for language given a known enum.
     *
     * <p>language: Required. Programming language of the `code`.
     */
    @CanIgnoreReturnValue
    public Builder language(Language.Known knownType) {
      return language(new Language(knownType));
    }

    /**
     * Setter for language given a string.
     *
     * <p>language: Required. Programming language of the `code`.
     */
    @CanIgnoreReturnValue
    public Builder language(String language) {
      return language(new Language(language));
    }

    public abstract ExecutableCode build();
  }

  /** Deserializes a JSON string to a ExecutableCode object. */
  @ExcludeFromGeneratedCoverageReport
  public static ExecutableCode fromJson(String jsonString) {
    return JsonSerializable.fromJsonString(jsonString, ExecutableCode.class);
  }
}
