/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_RecontextImageConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.PersonGeneration;
import com.google.genai.types.SafetyFilterLevel;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class RecontextImageConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="numberOfImages")
    public abstract Optional<Integer> numberOfImages();

    @JsonProperty(value="baseSteps")
    public abstract Optional<Integer> baseSteps();

    @JsonProperty(value="outputGcsUri")
    public abstract Optional<String> outputGcsUri();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="safetyFilterLevel")
    public abstract Optional<SafetyFilterLevel> safetyFilterLevel();

    @JsonProperty(value="personGeneration")
    public abstract Optional<PersonGeneration> personGeneration();

    @JsonProperty(value="addWatermark")
    public abstract Optional<Boolean> addWatermark();

    @JsonProperty(value="outputMimeType")
    public abstract Optional<String> outputMimeType();

    @JsonProperty(value="outputCompressionQuality")
    public abstract Optional<Integer> outputCompressionQuality();

    @JsonProperty(value="enhancePrompt")
    public abstract Optional<Boolean> enhancePrompt();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_RecontextImageConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static RecontextImageConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, RecontextImageConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_RecontextImageConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @JsonProperty(value="numberOfImages")
        public abstract Builder numberOfImages(Integer var1);

        @JsonProperty(value="baseSteps")
        public abstract Builder baseSteps(Integer var1);

        @JsonProperty(value="outputGcsUri")
        public abstract Builder outputGcsUri(String var1);

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @JsonProperty(value="safetyFilterLevel")
        public abstract Builder safetyFilterLevel(SafetyFilterLevel var1);

        @CanIgnoreReturnValue
        public Builder safetyFilterLevel(SafetyFilterLevel.Known knownType) {
            return this.safetyFilterLevel(new SafetyFilterLevel(knownType));
        }

        @CanIgnoreReturnValue
        public Builder safetyFilterLevel(String safetyFilterLevel) {
            return this.safetyFilterLevel(new SafetyFilterLevel(safetyFilterLevel));
        }

        @JsonProperty(value="personGeneration")
        public abstract Builder personGeneration(PersonGeneration var1);

        @CanIgnoreReturnValue
        public Builder personGeneration(PersonGeneration.Known knownType) {
            return this.personGeneration(new PersonGeneration(knownType));
        }

        @CanIgnoreReturnValue
        public Builder personGeneration(String personGeneration) {
            return this.personGeneration(new PersonGeneration(personGeneration));
        }

        @JsonProperty(value="addWatermark")
        public abstract Builder addWatermark(boolean var1);

        @JsonProperty(value="outputMimeType")
        public abstract Builder outputMimeType(String var1);

        @JsonProperty(value="outputCompressionQuality")
        public abstract Builder outputCompressionQuality(Integer var1);

        @JsonProperty(value="enhancePrompt")
        public abstract Builder enhancePrompt(boolean var1);

        public abstract RecontextImageConfig build();
    }
}

