/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_RecontextImageSource;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import com.google.genai.types.ProductImage;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class RecontextImageSource
extends JsonSerializable {
    @JsonProperty(value="prompt")
    public abstract Optional<String> prompt();

    @JsonProperty(value="personImage")
    public abstract Optional<Image> personImage();

    @JsonProperty(value="productImages")
    public abstract Optional<List<ProductImage>> productImages();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_RecontextImageSource.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static RecontextImageSource fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, RecontextImageSource.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_RecontextImageSource.Builder();
        }

        @JsonProperty(value="prompt")
        public abstract Builder prompt(String var1);

        @JsonProperty(value="personImage")
        public abstract Builder personImage(Image var1);

        public Builder personImage(Image.Builder personImageBuilder) {
            return this.personImage(personImageBuilder.build());
        }

        @JsonProperty(value="productImages")
        public abstract Builder productImages(List<ProductImage> var1);

        public Builder productImages(ProductImage ... productImages) {
            return this.productImages(Arrays.asList(productImages));
        }

        public Builder productImages(ProductImage.Builder ... productImagesBuilders) {
            return this.productImages((List)Arrays.asList(productImagesBuilders).stream().map(ProductImage.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        public abstract RecontextImageSource build();
    }
}

