/*
 * Decompiled with CFR 0.152.
 */
package com.google.gms.googleservices;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GoogleServicesTask
extends DefaultTask {
    public static final String JSON_FILE_NAME = "google-services.json";
    public static final Pattern VARIANT_PATTERN = Pattern.compile("(?:([^\\p{javaUpperCase}]+)((?:\\p{javaUpperCase}[^\\p{javaUpperCase}]*)*)\\/)?([^\\/]*)");
    public static final Pattern FLAVOR_PATTERN = Pattern.compile("(\\p{javaUpperCase}[^\\p{javaUpperCase}]*)");
    private static final String STATUS_DISABLED = "1";
    private static final String STATUS_ENABLED = "2";
    private static final String OAUTH_CLIENT_TYPE_WEB = "3";
    private File intermediateDir;
    private String variantDir;
    private String packageNameXOR1;
    private TextResource packageNameXOR2;

    @OutputDirectory
    public File getIntermediateDir() {
        return this.intermediateDir;
    }

    @Input
    public String getVariantDir() {
        return this.variantDir;
    }

    @Input
    @Optional
    public String getPackageNameXOR1() {
        return this.packageNameXOR1;
    }

    @Input
    @Optional
    public TextResource getPackageNameXOR2() {
        return this.packageNameXOR2;
    }

    public void setIntermediateDir(File intermediateDir) {
        this.intermediateDir = intermediateDir;
    }

    public void setVariantDir(String variantDir) {
        this.variantDir = variantDir;
    }

    public void setPackageNameXOR1(String packageNameXOR1) {
        this.packageNameXOR1 = packageNameXOR1;
    }

    public void setPackageNameXOR2(TextResource packageNameXOR2) {
        this.packageNameXOR2 = packageNameXOR2;
    }

    @TaskAction
    public void action() throws IOException {
        File quickstartFile = null;
        List<String> fileLocations = GoogleServicesTask.getJsonLocations(this.variantDir);
        String searchedLocation = System.lineSeparator();
        for (String location : fileLocations) {
            File jsonFile = this.getProject().file((Object)(location + '/' + JSON_FILE_NAME));
            searchedLocation = searchedLocation + jsonFile.getPath() + System.lineSeparator();
            if (!jsonFile.isFile()) continue;
            quickstartFile = jsonFile;
            break;
        }
        if (quickstartFile == null) {
            quickstartFile = this.getProject().file((Object)JSON_FILE_NAME);
            searchedLocation = searchedLocation + quickstartFile.getPath();
        }
        if (!quickstartFile.isFile()) {
            throw new GradleException(String.format("File %s is missing. The Google Services Plugin cannot function without it. %n Searched Location: %s", quickstartFile.getName(), searchedLocation));
        }
        if (this.packageNameXOR1 == null && this.packageNameXOR2 == null) {
            throw new GradleException(String.format("One of packageNameXOR1 or packageNameXOR2 are required: packageNameXOR1: %s, packageNameXOR2: %s", this.packageNameXOR1, this.packageNameXOR2));
        }
        this.getProject().getLogger().warn("Parsing json file: " + quickstartFile.getPath());
        GoogleServicesTask.deleteFolder(this.intermediateDir);
        if (!this.intermediateDir.mkdirs()) {
            throw new GradleException("Failed to create folder: " + this.intermediateDir);
        }
        JsonElement root = new JsonParser().parse((Reader)Files.newReader((File)quickstartFile, (Charset)Charsets.UTF_8));
        if (!root.isJsonObject()) {
            throw new GradleException("Malformed root json");
        }
        JsonObject rootObject = root.getAsJsonObject();
        TreeMap<String, String> resValues = new TreeMap<String, String>();
        TreeMap<String, Map<String, String>> resAttributes = new TreeMap<String, Map<String, String>>();
        this.handleProjectNumberAndProjectId(rootObject, resValues);
        this.handleFirebaseUrl(rootObject, resValues);
        JsonObject clientObject = this.getClientForPackageName(rootObject);
        if (clientObject == null) {
            throw new GradleException("No matching client found for package name '" + this.getPackageName() + "'");
        }
        this.handleAnalytics(clientObject, resValues);
        this.handleMapsService(clientObject, resValues);
        this.handleGoogleApiKey(clientObject, resValues);
        this.handleGoogleAppId(clientObject, resValues);
        this.handleWebClientId(clientObject, resValues);
        File values = new File(this.intermediateDir, "values");
        if (!values.exists() && !values.mkdirs()) {
            throw new GradleException("Failed to create folder: " + values);
        }
        Files.asCharSink((File)new File(values, "values.xml"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)GoogleServicesTask.getValuesContent(resValues, resAttributes));
    }

    private void handleFirebaseUrl(JsonObject rootObject, Map<String, String> resValues) throws IOException {
        JsonObject projectInfo = rootObject.getAsJsonObject("project_info");
        if (projectInfo == null) {
            throw new GradleException("Missing project_info object");
        }
        JsonPrimitive firebaseUrl = projectInfo.getAsJsonPrimitive("firebase_url");
        if (firebaseUrl != null) {
            resValues.put("firebase_database_url", firebaseUrl.getAsString());
        }
    }

    private void handleProjectNumberAndProjectId(JsonObject rootObject, Map<String, String> resValues) throws IOException {
        JsonObject projectInfo = rootObject.getAsJsonObject("project_info");
        if (projectInfo == null) {
            throw new GradleException("Missing project_info object");
        }
        JsonPrimitive projectNumber = projectInfo.getAsJsonPrimitive("project_number");
        if (projectNumber == null) {
            throw new GradleException("Missing project_info/project_number object");
        }
        resValues.put("gcm_defaultSenderId", projectNumber.getAsString());
        JsonPrimitive projectId = projectInfo.getAsJsonPrimitive("project_id");
        if (projectId == null) {
            throw new GradleException("Missing project_info/project_id object");
        }
        resValues.put("project_id", projectId.getAsString());
        JsonPrimitive bucketName = projectInfo.getAsJsonPrimitive("storage_bucket");
        if (bucketName != null) {
            resValues.put("google_storage_bucket", bucketName.getAsString());
        }
    }

    private void handleWebClientId(JsonObject clientObject, Map<String, String> resValues) {
        JsonArray array = clientObject.getAsJsonArray("oauth_client");
        if (array != null) {
            int count = array.size();
            for (int i = 0; i < count; ++i) {
                JsonPrimitive clientId;
                String clientTypeStr;
                JsonObject oauthClientObject;
                JsonPrimitive clientType;
                JsonElement oauthClientElement = array.get(i);
                if (oauthClientElement == null || !oauthClientElement.isJsonObject() || (clientType = (oauthClientObject = oauthClientElement.getAsJsonObject()).getAsJsonPrimitive("client_type")) == null || !OAUTH_CLIENT_TYPE_WEB.equals(clientTypeStr = clientType.getAsString()) || (clientId = oauthClientObject.getAsJsonPrimitive("client_id")) == null) continue;
                resValues.put("default_web_client_id", clientId.getAsString());
                return;
            }
        }
    }

    private void handleAnalytics(JsonObject clientObject, Map<String, String> resValues) throws IOException {
        JsonObject analyticsService = this.getServiceByName(clientObject, "analytics_service");
        if (analyticsService == null) {
            return;
        }
        JsonObject analyticsProp = analyticsService.getAsJsonObject("analytics_property");
        if (analyticsProp == null) {
            return;
        }
        JsonPrimitive trackingId = analyticsProp.getAsJsonPrimitive("tracking_id");
        if (trackingId == null) {
            return;
        }
        resValues.put("ga_trackingId", trackingId.getAsString());
        File xml = new File(this.intermediateDir, "xml");
        if (!xml.exists() && !xml.mkdirs()) {
            throw new GradleException("Failed to create folder: " + xml);
        }
        Files.asCharSink((File)new File(xml, "global_tracker.xml"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)GoogleServicesTask.getGlobalTrackerContent(trackingId.getAsString()));
    }

    private void handleMapsService(JsonObject clientObject, Map<String, String> resValues) throws IOException {
        JsonObject mapsService = this.getServiceByName(clientObject, "maps_service");
        if (mapsService == null) {
            return;
        }
        String apiKey = this.getAndroidApiKey(clientObject);
        if (apiKey != null) {
            resValues.put("google_maps_key", apiKey);
            return;
        }
        throw new GradleException("Missing api_key/current_key object");
    }

    private void handleGoogleApiKey(JsonObject clientObject, Map<String, String> resValues) {
        String apiKey = this.getAndroidApiKey(clientObject);
        if (apiKey != null) {
            resValues.put("google_api_key", apiKey);
            resValues.put("google_crash_reporting_api_key", apiKey);
            return;
        }
        throw new GradleException("Missing api_key/current_key object");
    }

    private String getAndroidApiKey(JsonObject clientObject) {
        JsonArray array = clientObject.getAsJsonArray("api_key");
        if (array != null) {
            int count = array.size();
            for (int i = 0; i < count; ++i) {
                JsonObject apiKeyObject;
                JsonPrimitive currentKey;
                JsonElement apiKeyElement = array.get(i);
                if (apiKeyElement == null || !apiKeyElement.isJsonObject() || (currentKey = (apiKeyObject = apiKeyElement.getAsJsonObject()).getAsJsonPrimitive("current_key")) == null) continue;
                return currentKey.getAsString();
            }
        }
        return null;
    }

    private static void findStringByName(JsonObject jsonObject, String stringName, Map<String, String> resValues) {
        JsonPrimitive id = jsonObject.getAsJsonPrimitive(stringName);
        if (id != null) {
            resValues.put(stringName, id.getAsString());
        }
    }

    private JsonObject getClientForPackageName(JsonObject jsonObject) {
        JsonArray array = jsonObject.getAsJsonArray("client");
        if (array != null) {
            int count = array.size();
            for (int i = 0; i < count; ++i) {
                JsonPrimitive clientPackageName;
                JsonObject androidClientInfo;
                JsonObject clientObject;
                JsonObject clientInfo;
                JsonElement clientElement = array.get(i);
                if (clientElement == null || !clientElement.isJsonObject() || (clientInfo = (clientObject = clientElement.getAsJsonObject()).getAsJsonObject("client_info")) == null || (androidClientInfo = clientInfo.getAsJsonObject("android_client_info")) == null || (clientPackageName = androidClientInfo.getAsJsonPrimitive("package_name")) == null || !this.getPackageName().equals(clientPackageName.getAsString())) continue;
                return clientObject;
            }
        }
        return null;
    }

    private void handleGoogleAppId(JsonObject clientObject, Map<String, String> resValues) throws IOException {
        String googleAppIdStr;
        JsonObject clientInfo = clientObject.getAsJsonObject("client_info");
        if (clientInfo == null) {
            throw new GradleException("Client does not have client info");
        }
        JsonPrimitive googleAppId = clientInfo.getAsJsonPrimitive("mobilesdk_app_id");
        String string = googleAppIdStr = googleAppId == null ? null : googleAppId.getAsString();
        if (Strings.isNullOrEmpty((String)googleAppIdStr)) {
            throw new GradleException("Missing Google App Id. Please follow instructions on https://firebase.google.com/ to get a valid config file that contains a Google App Id");
        }
        resValues.put("google_app_id", googleAppIdStr);
    }

    private JsonObject getServiceByName(JsonObject clientObject, String serviceName) {
        JsonObject services = clientObject.getAsJsonObject("services");
        if (services == null) {
            return null;
        }
        JsonObject service = services.getAsJsonObject(serviceName);
        if (service == null) {
            return null;
        }
        JsonPrimitive status = service.getAsJsonPrimitive("status");
        if (status == null) {
            return null;
        }
        String statusStr = status.getAsString();
        if (STATUS_DISABLED.equals(statusStr)) {
            return null;
        }
        if (!STATUS_ENABLED.equals(statusStr)) {
            this.getLogger().warn(String.format("Status with value '%1$s' for service '%2$s' is unknown", statusStr, serviceName));
            return null;
        }
        return service;
    }

    private static String getGlobalTrackerContent(String ga_trackingId) {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <string name=\"ga_trackingId\" translatable=\"false\">" + ga_trackingId + "</string>\n</resources>\n";
    }

    private static String getValuesContent(Map<String, String> values, Map<String, Map<String, String>> attributes) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n");
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String name = entry.getKey();
            sb.append("    <string name=\"").append(name).append("\" translatable=\"false\"");
            if (attributes.containsKey(name)) {
                for (Map.Entry<String, String> attr : attributes.get(name).entrySet()) {
                    sb.append(" ").append(attr.getKey()).append("=\"").append(attr.getValue()).append("\"");
                }
            }
            sb.append(">").append(entry.getValue()).append("</string>\n");
        }
        sb.append("</resources>\n");
        return sb.toString();
    }

    private static void deleteFolder(File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    GoogleServicesTask.deleteFolder(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new GradleException("Failed to delete: " + file);
            }
        }
        if (!folder.delete()) {
            throw new GradleException("Failed to delete: " + folder);
        }
    }

    private String getPackageName() {
        if (this.packageNameXOR1 == null) {
            return this.packageNameXOR2.asString();
        }
        return this.packageNameXOR1;
    }

    private static List<String> splitVariantNames(String variant) {
        if (variant == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> flavors = new ArrayList<String>();
        Matcher flavorMatcher = FLAVOR_PATTERN.matcher(variant);
        while (flavorMatcher.find()) {
            String match = flavorMatcher.group(1);
            if (match == null) continue;
            flavors.add(match.toLowerCase());
        }
        return flavors;
    }

    private static long countSlashes(String input) {
        return input.codePoints().filter(x -> x == 47).count();
    }

    static List<String> getJsonLocations(String variantDirname) {
        Matcher variantMatcher = VARIANT_PATTERN.matcher(variantDirname);
        List<String> fileLocations = new ArrayList<String>();
        if (!variantMatcher.matches()) {
            return fileLocations;
        }
        ArrayList<String> flavorNames = new ArrayList<String>();
        if (variantMatcher.group(1) != null) {
            flavorNames.add(variantMatcher.group(1).toLowerCase());
        }
        flavorNames.addAll(GoogleServicesTask.splitVariantNames(variantMatcher.group(2)));
        String buildType = variantMatcher.group(3);
        String flavorName = variantMatcher.group(1) + variantMatcher.group(2);
        fileLocations.add("src/" + flavorName + "/" + buildType);
        fileLocations.add("src/" + buildType + "/" + flavorName);
        fileLocations.add("src/" + flavorName);
        fileLocations.add("src/" + buildType);
        fileLocations.add("src/" + flavorName + GoogleServicesTask.capitalize(buildType));
        fileLocations.add("src/" + buildType);
        String fileLocation = "src";
        for (String flavor : flavorNames) {
            fileLocation = fileLocation + "/" + flavor;
            fileLocations.add(fileLocation);
            fileLocations.add(fileLocation + "/" + buildType);
            fileLocations.add(fileLocation + GoogleServicesTask.capitalize(buildType));
        }
        fileLocations = fileLocations.stream().distinct().sorted(Comparator.comparing(GoogleServicesTask::countSlashes)).collect(Collectors.toList());
        return fileLocations;
    }

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }
}

