/*
 * Decompiled with CFR 0.152.
 */
package com.google.gms.googleservices;

import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.DynamicFeatureAndroidComponentsExtension;
import com.android.build.api.variant.DynamicFeatureVariant;
import com.android.build.api.variant.GeneratesApk;
import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.google.android.gms.dependencies.DependencyAnalyzer;
import com.google.android.gms.dependencies.DependencyInspector;
import com.google.gms.googleservices.GoogleServicesPlugin;
import com.google.gms.googleservices.GoogleServicesTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.configurationcache.extensions.CharSequenceExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J+\u0010\u0007\u001a\u00020\u0005\"\f\b\u0000\u0010\b*\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\u00020\u000e*\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/google/gms/googleservices/GoogleServicesPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "handleVariant", "T", "Lcom/android/build/api/variant/Variant;", "Lcom/android/build/api/variant/GeneratesApk;", "variant", "(Lcom/android/build/api/variant/Variant;Lorg/gradle/api/Project;)V", "capitalize", "", "Companion", "GoogleServicesPluginConfig", "MissingGoogleServicesStrategy", "google-services-plugin"})
public final class GoogleServicesPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MODULE_GROUP = "com.google.android.gms";
    @NotNull
    public static final String MODULE_GROUP_FIREBASE = "com.google.firebase";
    @NotNull
    public static final String MODULE_CORE = "firebase-core";
    @NotNull
    public static final String MODULE_VERSION = "11.4.2";
    @NotNull
    public static final String MINIMUM_VERSION = "9.0.0";
    @NotNull
    public static final String SOURCE_TYPE = "google-services";
    @NotNull
    public static final String JSON_FILE_NAME = "google-services.json";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GoogleServicesPluginConfig config = (GoogleServicesPluginConfig)project.getExtensions().create("googleServices", GoogleServicesPluginConfig.class, new Object[0]);
        project.afterEvaluate(arg_0 -> GoogleServicesPlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(config, project){
            final /* synthetic */ GoogleServicesPluginConfig $config;
            final /* synthetic */ Project $project;
            {
                this.$config = $config;
                this.$project = $project;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Project it) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                if (this.$config.getDisableVersionCheck()) {
                    return;
                }
                DependencyAnalyzer globalDependencies = new DependencyAnalyzer();
                DependencyInspector strictVersionDepInspector = new DependencyInspector(globalDependencies, this.$project.getName(), "This error message came from the google-services Gradle plugin, report issues at https://github.com/google/play-services-plugins and disable by adding \"googleServices { disableVersionCheck = true }\" to your build.gradle file.");
                ConfigurationContainer configurationContainer = this.$project.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Iterable iterable = (Iterable)configurationContainer;
                boolean $i$f$filter = false;
                Iterator<T> iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Configuration it2 = (Configuration)element$iv$iv;
                    boolean bl = false;
                    String string = it2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"ompile", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Configuration projectConfig = (Configuration)element$iv;
                    boolean bl = false;
                    projectConfig.getIncoming().afterResolve(arg_0 -> apply.1.invoke$lambda$2$lambda$1((Function1)new Function1<ResolvableDependencies, Unit>((Object)strictVersionDepInspector){

                        public final void invoke(ResolvableDependencies p0) {
                            ((DependencyInspector)this.receiver).afterResolve(p0);
                        }
                    }, arg_0));
                }
            }

            private static final void invoke$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        Ref.BooleanRef pluginApplied = new Ref.BooleanRef();
        project.getPluginManager().withPlugin("com.android.application", arg_0 -> GoogleServicesPlugin.apply$lambda$1((Function1)new Function1<AppliedPlugin, Unit>(pluginApplied, project, this){
            final /* synthetic */ Ref.BooleanRef $pluginApplied;
            final /* synthetic */ Project $project;
            final /* synthetic */ GoogleServicesPlugin this$0;
            {
                this.$pluginApplied = $pluginApplied;
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AppliedPlugin it) {
                this.$pluginApplied.element = true;
                this.$project.getExtensions().configure(ApplicationAndroidComponentsExtension.class, arg_0 -> apply.2.invoke$lambda$0((Function1)new Function1<ApplicationAndroidComponentsExtension, Unit>(this.this$0, this.$project){
                    final /* synthetic */ GoogleServicesPlugin this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(ApplicationAndroidComponentsExtension it) {
                        it.registerSourceType("google-services");
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        AndroidComponentsExtension.DefaultImpls.onVariants$default((AndroidComponentsExtension)((AndroidComponentsExtension)it), null, (Function1)((Function1)new Function1<ApplicationVariant, Unit>(this.this$0, this.$project){
                            final /* synthetic */ GoogleServicesPlugin this$0;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(@NotNull ApplicationVariant variant) {
                                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                                GoogleServicesPlugin.access$handleVariant(this.this$0, (Variant)variant, this.$project);
                            }
                        }), (int)1, null);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        project.getPluginManager().withPlugin("com.android.dynamic-feature", arg_0 -> GoogleServicesPlugin.apply$lambda$2((Function1)new Function1<AppliedPlugin, Unit>(pluginApplied, project, this){
            final /* synthetic */ Ref.BooleanRef $pluginApplied;
            final /* synthetic */ Project $project;
            final /* synthetic */ GoogleServicesPlugin this$0;
            {
                this.$pluginApplied = $pluginApplied;
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AppliedPlugin it) {
                this.$pluginApplied.element = true;
                this.$project.getExtensions().configure(DynamicFeatureAndroidComponentsExtension.class, arg_0 -> apply.3.invoke$lambda$0((Function1)new Function1<DynamicFeatureAndroidComponentsExtension, Unit>(this.this$0, this.$project){
                    final /* synthetic */ GoogleServicesPlugin this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(DynamicFeatureAndroidComponentsExtension it) {
                        it.registerSourceType("google-services");
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        AndroidComponentsExtension.DefaultImpls.onVariants$default((AndroidComponentsExtension)((AndroidComponentsExtension)it), null, (Function1)((Function1)new Function1<DynamicFeatureVariant, Unit>(this.this$0, this.$project){
                            final /* synthetic */ GoogleServicesPlugin this$0;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(@NotNull DynamicFeatureVariant variant) {
                                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                                GoogleServicesPlugin.access$handleVariant(this.this$0, (Variant)variant, this.$project);
                            }
                        }), (int)1, null);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        project.afterEvaluate(arg_0 -> GoogleServicesPlugin.apply$lambda$3((Function1)new Function1<Project, Unit>(pluginApplied, project){
            final /* synthetic */ Ref.BooleanRef $pluginApplied;
            final /* synthetic */ Project $project;
            {
                this.$pluginApplied = $pluginApplied;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Project it) {
                if (this.$pluginApplied.element) {
                    return;
                }
                this.$project.getLogger().error("The google-services Gradle plugin needs to be applied on a project with com.android.application or com.android.dynamic-feature.");
            }
        }, arg_0));
    }

    private final <T extends Variant & GeneratesApk> void handleVariant(T variant, Project project) {
        block2: {
            Function1 function1 = (Function1)new Function1<GoogleServicesTask, Unit>(project, variant){
                final /* synthetic */ Project $project;
                final /* synthetic */ T $variant;
                {
                    this.$project = $project;
                    this.$variant = $variant;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(GoogleServicesTask it) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    it.getMissingGoogleServicesStrategy().set((Object)((Object)((GoogleServicesPluginConfig)this.$project.getExtensions().getByType(GoogleServicesPluginConfig.class)).getMissingGoogleServicesStrategy()));
                    Property<Collection<File>> property = it.getGoogleServicesJsonFiles();
                    String string = this.$variant.getBuildType();
                    if (string == null) {
                        string = "";
                    }
                    Iterable iterable = this.$variant.getProductFlavors();
                    String string2 = string;
                    Companion companion = GoogleServicesPlugin.Companion;
                    Property<Collection<File>> property2 = property;
                    boolean $i$f$map = false;
                    void var4_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Pair pair = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((String)it2.getSecond());
                    }
                    collection = (List)destination$iv$iv;
                    File file = this.$project.getProjectDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
                    property2.set(companion.getJsonFiles(string2, (List<String>)collection, file));
                    it.getApplicationId().set(((GeneratesApk)this.$variant).getApplicationId());
                    RegularFileProperty regularFileProperty = it.getGmpAppId();
                    File file2 = this.$project.getBuildDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildDir");
                    regularFileProperty.set(FilesKt.resolve((File)file2, (String)"gmpAppId.txt"));
                }
            };
            TaskProvider jsonToXmlTask2 = project.getTasks().register("process" + this.capitalize(variant.getName()) + "GoogleServices", GoogleServicesTask.class, arg_0 -> GoogleServicesPlugin.handleVariant$lambda$4(function1, arg_0));
            try {
                variant.getSources().getByName(SOURCE_TYPE).addStaticSourceDirectory(project.getLayout().getProjectDirectory().dir("src/" + variant.getName() + "/google-services").toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            SourceDirectories.Layered layered = variant.getSources().getRes();
            if (layered == null) break block2;
            Intrinsics.checkNotNullExpressionValue((Object)jsonToXmlTask2, (String)"jsonToXmlTask");
            layered.addGeneratedSourceDirectory(jsonToXmlTask2, (Function1)handleVariant.1.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String capitalize(String $this$capitalize) {
        String string;
        String string2 = $this$capitalize;
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)it)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                string3 = CharsKt.titlecase((char)it, (Locale)locale);
            } else {
                string3 = String.valueOf((char)it);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        return string;
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleVariant$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$handleVariant(GoogleServicesPlugin $this, Variant variant, Project project) {
        $this.handleVariant(variant, project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0010\u001a\u00020\rJ\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/gms/googleservices/GoogleServicesPlugin$Companion;", "", "()V", "JSON_FILE_NAME", "", "MINIMUM_VERSION", "MODULE_CORE", "MODULE_GROUP", "MODULE_GROUP_FIREBASE", "MODULE_VERSION", "SOURCE_TYPE", "getJsonFiles", "", "Ljava/io/File;", "buildType", "flavorNames", "root", "getJsonLocations", "google-services-plugin"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> getJsonFiles(@NotNull String buildType, @NotNull List<String> flavorNames, @NotNull File root) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
            Intrinsics.checkNotNullParameter(flavorNames, (String)"flavorNames");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Iterable $this$map$iv = this.getJsonLocations(buildType, flavorNames);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FilesKt.resolve((File)root, (String)it));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getJsonLocations(@NotNull String buildType, @NotNull List<String> flavorNames) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedByDescending$iv;
            Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
            Intrinsics.checkNotNullParameter(flavorNames, (String)"flavorNames");
            List fileLocations = new ArrayList();
            String flavorName = flavorNames.stream().reduce("", Companion::getJsonLocations$lambda$1);
            fileLocations.add("");
            fileLocations.add("src/" + flavorName + "/" + buildType);
            fileLocations.add("src/" + buildType + "/" + flavorName);
            fileLocations.add("src/" + flavorName);
            fileLocations.add("src/" + buildType);
            fileLocations.add("src/" + flavorName + CharSequenceExtensionsKt.capitalized((CharSequence)buildType));
            fileLocations.add("src/" + buildType);
            Object fileLocation = "src";
            for (String flavor : flavorNames) {
                fileLocation = (String)fileLocation + "/" + flavor;
                fileLocations.add(fileLocation);
                fileLocations.add((String)fileLocation + "/" + buildType);
                fileLocations.add((String)fileLocation + CharSequenceExtensionsKt.capitalized((CharSequence)buildType));
            }
            Iterable iterable = CollectionsKt.distinct((Iterable)fileLocations);
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl;
                    char it;
                    char element$iv;
                    int n;
                    String path = (String)b;
                    boolean bl2 = false;
                    CharSequence $this$count$iv = path;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    for (n = 0; n < $this$count$iv.length(); ++n) {
                        it = element$iv = $this$count$iv.charAt(n);
                        bl = false;
                        if (!(it == '/')) continue;
                        ++count$iv;
                    }
                    path = (String)a;
                    Comparable comparable = Integer.valueOf(count$iv);
                    bl2 = false;
                    $this$count$iv = path;
                    $i$f$count = false;
                    count$iv = 0;
                    for (n = 0; n < $this$count$iv.length(); ++n) {
                        it = element$iv = $this$count$iv.charAt(n);
                        bl = false;
                        if (!(it == '/')) continue;
                        ++count$iv;
                    }
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(count$iv));
                }
            });
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void location;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((CharSequence)location).length() == 0 ? (String)location + GoogleServicesPlugin.JSON_FILE_NAME : (String)location + "/google-services.json");
            }
            return (List)destination$iv$iv;
        }

        private static final String getJsonLocations$lambda$1(String a, String b) {
            String string;
            Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
            if (((CharSequence)a).length() == 0) {
                string = b;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
                string = CharSequenceExtensionsKt.capitalized((CharSequence)b);
            }
            return a + string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/gms/googleservices/GoogleServicesPlugin$MissingGoogleServicesStrategy;", "", "(Ljava/lang/String;I)V", "IGNORE", "WARN", "ERROR", "google-services-plugin"})
    public static final class MissingGoogleServicesStrategy
    extends Enum<MissingGoogleServicesStrategy> {
        public static final /* enum */ MissingGoogleServicesStrategy IGNORE = new MissingGoogleServicesStrategy();
        public static final /* enum */ MissingGoogleServicesStrategy WARN = new MissingGoogleServicesStrategy();
        public static final /* enum */ MissingGoogleServicesStrategy ERROR = new MissingGoogleServicesStrategy();
        private static final /* synthetic */ MissingGoogleServicesStrategy[] $VALUES;

        public static MissingGoogleServicesStrategy[] values() {
            return (MissingGoogleServicesStrategy[])$VALUES.clone();
        }

        public static MissingGoogleServicesStrategy valueOf(String value) {
            return Enum.valueOf(MissingGoogleServicesStrategy.class, value);
        }

        static {
            $VALUES = missingGoogleServicesStrategyArray = new MissingGoogleServicesStrategy[]{MissingGoogleServicesStrategy.IGNORE, MissingGoogleServicesStrategy.WARN, MissingGoogleServicesStrategy.ERROR};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/google/gms/googleservices/GoogleServicesPlugin$GoogleServicesPluginConfig;", "", "()V", "disableVersionCheck", "", "getDisableVersionCheck", "()Z", "setDisableVersionCheck", "(Z)V", "missingGoogleServicesStrategy", "Lcom/google/gms/googleservices/GoogleServicesPlugin$MissingGoogleServicesStrategy;", "getMissingGoogleServicesStrategy", "()Lcom/google/gms/googleservices/GoogleServicesPlugin$MissingGoogleServicesStrategy;", "setMissingGoogleServicesStrategy", "(Lcom/google/gms/googleservices/GoogleServicesPlugin$MissingGoogleServicesStrategy;)V", "google-services-plugin"})
    public static class GoogleServicesPluginConfig {
        private boolean disableVersionCheck;
        @NotNull
        private MissingGoogleServicesStrategy missingGoogleServicesStrategy = MissingGoogleServicesStrategy.ERROR;

        public final boolean getDisableVersionCheck() {
            return this.disableVersionCheck;
        }

        public final void setDisableVersionCheck(boolean bl) {
            this.disableVersionCheck = bl;
        }

        @NotNull
        public final MissingGoogleServicesStrategy getMissingGoogleServicesStrategy() {
            return this.missingGoogleServicesStrategy;
        }

        public final void setMissingGoogleServicesStrategy(@NotNull MissingGoogleServicesStrategy missingGoogleServicesStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)missingGoogleServicesStrategy), (String)"<set-?>");
            this.missingGoogleServicesStrategy = missingGoogleServicesStrategy;
        }
    }
}

