/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.FormatterDiagnostic;
import java.util.Locale;
import org.openjdk.javax.tools.Diagnostic;
import org.openjdk.javax.tools.JavaFileObject;

public class FormattingError
extends Error {
    private final ImmutableList<FormatterDiagnostic> diagnostics;

    public FormattingError(FormatterDiagnostic diagnostic) {
        this((Iterable<FormatterDiagnostic>)ImmutableList.of((Object)diagnostic));
    }

    public FormattingError(Iterable<FormatterDiagnostic> diagnostics) {
        super(Joiner.on((String)"\n").join(diagnostics) + "\n");
        this.diagnostics = ImmutableList.copyOf(diagnostics);
    }

    public ImmutableList<FormatterDiagnostic> diagnostics() {
        return this.diagnostics;
    }

    public static FormattingError fromJavacDiagnostics(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return new FormattingError(Iterables.transform(diagnostics, FormattingError::toFormatterDiagnostic));
    }

    private static FormatterDiagnostic toFormatterDiagnostic(Diagnostic<?> input) {
        return FormatterDiagnostic.create((int)input.getLineNumber(), (int)input.getColumnNumber(), input.getMessage(Locale.ENGLISH));
    }
}

