/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.java.CommandLineOptions;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import java.util.concurrent.Callable;

class FormatFileCallable
implements Callable<String> {
    private final String input;
    private final CommandLineOptions parameters;
    private final JavaFormatterOptions options;

    public FormatFileCallable(CommandLineOptions parameters, String input, JavaFormatterOptions options) {
        this.input = input;
        this.parameters = parameters;
        this.options = options;
    }

    @Override
    public String call() throws FormatterException {
        if (this.parameters.fixImportsOnly()) {
            return this.fixImports(this.input);
        }
        String formatted = new Formatter(this.options).formatSource(this.input, this.characterRanges(this.input).asRanges());
        formatted = this.fixImports(formatted);
        return formatted;
    }

    private String fixImports(String input) throws FormatterException {
        if (this.parameters.removeUnusedImports()) {
            input = RemoveUnusedImports.removeUnusedImports(input);
        }
        if (this.parameters.sortImports()) {
            input = ImportOrderer.reorderImports(input);
        }
        return input;
    }

    private RangeSet<Integer> characterRanges(String input) {
        TreeRangeSet characterRanges = TreeRangeSet.create();
        if (this.parameters.lines().isEmpty() && this.parameters.offsets().isEmpty()) {
            characterRanges.add(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(input.length())));
            return characterRanges;
        }
        characterRanges.addAll(Formatter.lineRangesToCharRanges(input, this.parameters.lines()));
        for (int i = 0; i < this.parameters.offsets().size(); ++i) {
            Integer length = (Integer)this.parameters.lengths().get(i);
            if (length == 0) {
                length = 1;
            }
            characterRanges.add(Range.closedOpen((Comparable)((Comparable)this.parameters.offsets().get(i)), (Comparable)Integer.valueOf((Integer)this.parameters.offsets().get(i) + length)));
        }
        return characterRanges;
    }
}

