/*
 * Copyright 2008 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.core.ext.soyc;

import java.util.SortedSet;

/**
 * A tag interface for Members to indicate that there may be additional,
 * possibly non-unique, names in the compiled output that refer to the member.
 */
public interface HasAliases {
  /**
   * Returns any aliases used in the compiled output that refer to this
   * MethodMember. Note that especially in the case of
   * polymorphically-dispatched methods, there may be many MethodMembers with
   * overlapping aliases.
   */
  SortedSet<String> getJsAliases();
}
