/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.DelegatingChangeListenerCollection;
import com.google.gwt.user.client.ui.DelegatingClickListenerCollection;
import com.google.gwt.user.client.ui.DelegatingFocusListenerCollection;
import com.google.gwt.user.client.ui.DelegatingKeyboardListenerCollection;
import com.google.gwt.user.client.ui.FiresSuggestionEvents;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerAdapter;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SourcesChangeEvents;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesFocusEvents;
import com.google.gwt.user.client.ui.SourcesKeyboardEvents;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.SuggestionEvent;
import com.google.gwt.user.client.ui.SuggestionHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuggestBox
extends Composite
implements HasText,
HasFocus,
HasAnimation,
SourcesClickEvents,
SourcesFocusEvents,
SourcesChangeEvents,
SourcesKeyboardEvents,
FiresSuggestionEvents {
    private static final String STYLENAME_DEFAULT = "gwt-SuggestBox";
    private int limit = 20;
    private SuggestOracle oracle;
    private String currentText;
    private final SuggestionMenu suggestionMenu;
    private final SuggestionPopup suggestionPopup;
    private final TextBoxBase box;
    private ArrayList<SuggestionHandler> suggestionHandlers = null;
    private DelegatingClickListenerCollection clickListeners;
    private DelegatingChangeListenerCollection changeListeners;
    private DelegatingFocusListenerCollection focusListeners;
    private DelegatingKeyboardListenerCollection keyboardListeners;
    private final SuggestOracle.Callback callBack = new SuggestOracle.Callback(){

        public void onSuggestionsReady(SuggestOracle.Request request, SuggestOracle.Response response) {
            SuggestBox.this.showSuggestions(response.getSuggestions());
        }
    };

    public SuggestBox() {
        this(new MultiWordSuggestOracle());
    }

    public SuggestBox(SuggestOracle oracle) {
        this(oracle, new TextBox());
    }

    public SuggestBox(SuggestOracle oracle, TextBoxBase box) {
        this.box = box;
        this.initWidget(box);
        this.suggestionMenu = new SuggestionMenu(true);
        this.suggestionPopup = new SuggestionPopup();
        this.suggestionPopup.setAnimationType(PopupPanel.AnimationType.ONE_WAY_CORNER);
        this.addKeyboardSupport();
        this.setOracle(oracle);
        this.setStyleName(STYLENAME_DEFAULT);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new DelegatingChangeListenerCollection(this, this.box);
        }
        this.changeListeners.add(listener);
    }

    @Override
    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new DelegatingClickListenerCollection(this, this.box);
        }
        this.clickListeners.add(listener);
    }

    @Override
    public void addEventHandler(SuggestionHandler handler) {
        if (this.suggestionHandlers == null) {
            this.suggestionHandlers = new ArrayList();
        }
        this.suggestionHandlers.add(handler);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new DelegatingFocusListenerCollection(this, this.box);
        }
        this.focusListeners.add(listener);
    }

    @Override
    public void addKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners == null) {
            this.keyboardListeners = new DelegatingKeyboardListenerCollection(this, this.box);
        }
        this.keyboardListeners.add(listener);
    }

    public int getLimit() {
        return this.limit;
    }

    public SuggestOracle getSuggestOracle() {
        return this.oracle;
    }

    @Override
    public int getTabIndex() {
        return this.box.getTabIndex();
    }

    @Override
    public String getText() {
        return this.box.getText();
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.suggestionPopup.isAnimationEnabled();
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    @Override
    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    @Override
    public void removeEventHandler(SuggestionHandler handler) {
        if (this.suggestionHandlers == null) {
            return;
        }
        this.suggestionHandlers.remove(handler);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.remove(listener);
        }
    }

    @Override
    public void removeKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners != null) {
            this.keyboardListeners.remove(listener);
        }
    }

    @Override
    public void setAccessKey(char key) {
        this.box.setAccessKey(key);
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.suggestionPopup.setAnimationEnabled(enable);
    }

    @Override
    public void setFocus(boolean focused) {
        this.box.setFocus(focused);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setPopupStyleName(String style) {
        this.suggestionPopup.setStyleName(style);
    }

    @Override
    public void setTabIndex(int index) {
        this.box.setTabIndex(index);
    }

    @Override
    public void setText(String text) {
        this.box.setText(text);
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.suggestionPopup.ensureDebugId(baseID + "-popup");
        this.suggestionMenu.setMenuItemDebugIds(baseID);
    }

    private void showSuggestions(Collection<? extends SuggestOracle.Suggestion> suggestions) {
        if (suggestions.size() > 0) {
            boolean isAnimationEnabled = this.suggestionPopup.isAnimationEnabled();
            if (this.suggestionPopup.isAttached()) {
                this.suggestionPopup.setAnimationEnabled(false);
                this.suggestionPopup.hide();
            }
            this.suggestionMenu.clearItems();
            for (SuggestOracle.Suggestion suggestion : suggestions) {
                final SuggestionMenuItem menuItem = new SuggestionMenuItem(suggestion, this.oracle.isDisplayStringHTML());
                menuItem.setCommand(new Command(){

                    public void execute() {
                        SuggestBox.this.setNewSelection(menuItem);
                    }
                });
                this.suggestionMenu.addItem(menuItem);
            }
            this.suggestionMenu.selectItem(0);
            this.suggestionPopup.showAlignedPopup();
            this.suggestionPopup.setAnimationEnabled(isAnimationEnabled);
        } else {
            this.suggestionPopup.hide();
        }
    }

    private void addKeyboardSupport() {
        this.box.addKeyboardListener(new KeyboardListenerAdapter(){

            public void onKeyDown(Widget sender, char keyCode, int modifiers) {
                if (SuggestBox.this.suggestionPopup.isAttached()) {
                    switch (keyCode) {
                        case '(': {
                            SuggestBox.this.suggestionMenu.selectItem(SuggestBox.this.suggestionMenu.getSelectedItemIndex() + 1);
                            break;
                        }
                        case '&': {
                            SuggestBox.this.suggestionMenu.selectItem(SuggestBox.this.suggestionMenu.getSelectedItemIndex() - 1);
                            break;
                        }
                        case '\t': 
                        case '\r': {
                            SuggestBox.this.suggestionMenu.doSelectedItemAction();
                        }
                    }
                }
            }

            public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                this.refreshSuggestions();
            }

            private void refreshSuggestions() {
                String text = SuggestBox.this.box.getText();
                if (text.equals(SuggestBox.this.currentText)) {
                    return;
                }
                SuggestBox.this.currentText = text;
                if (text.length() == 0) {
                    SuggestBox.this.suggestionPopup.hide();
                    SuggestBox.this.suggestionMenu.clearItems();
                } else {
                    SuggestBox.this.showSuggestions(text);
                }
            }
        });
    }

    private void fireSuggestionEvent(SuggestOracle.Suggestion selectedSuggestion) {
        if (this.suggestionHandlers != null) {
            SuggestionEvent event = new SuggestionEvent(this, selectedSuggestion);
            for (SuggestionHandler handler : this.suggestionHandlers) {
                handler.onSuggestionSelected(event);
            }
        }
    }

    private void setNewSelection(SuggestionMenuItem menuItem) {
        SuggestOracle.Suggestion curSuggestion = menuItem.getSuggestion();
        this.currentText = curSuggestion.getReplacementString();
        this.box.setText(this.currentText);
        this.suggestionPopup.hide();
        this.fireSuggestionEvent(curSuggestion);
    }

    private void setOracle(SuggestOracle oracle) {
        this.oracle = oracle;
    }

    private void showSuggestions(String query) {
        this.oracle.requestSuggestions(new SuggestOracle.Request(query, this.limit), this.callBack);
    }

    private class SuggestionPopup
    extends DecoratedPopupPanel {
        private static final String STYLENAME_DEFAULT = "gwt-SuggestBoxPopup";

        public SuggestionPopup() {
            super(true, false, "suggestPopup");
            this.setWidget(SuggestBox.this.suggestionMenu);
            this.setStyleName(STYLENAME_DEFAULT);
        }

        public void showAlignedPopup() {
            this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                public void setPosition(int offsetWidth, int offsetHeight) {
                    int left;
                    int textBoxOffsetWidth = SuggestBox.this.box.getOffsetWidth();
                    int offsetWidthDiff = offsetWidth - textBoxOffsetWidth;
                    if (LocaleInfo.getCurrentLocale().isRTL()) {
                        int textBoxAbsoluteLeft = SuggestBox.this.box.getAbsoluteLeft();
                        left = textBoxAbsoluteLeft - offsetWidthDiff;
                        if (offsetWidthDiff > 0) {
                            int windowRight = Window.getClientWidth() + Window.getScrollLeft();
                            int windowLeft = Window.getScrollLeft();
                            int textBoxLeftValForRightEdge = textBoxAbsoluteLeft + textBoxOffsetWidth;
                            int distanceToWindowRight = windowRight - textBoxLeftValForRightEdge;
                            int distanceFromWindowLeft = textBoxLeftValForRightEdge - windowLeft;
                            if (distanceFromWindowLeft < offsetWidth && distanceToWindowRight >= offsetWidthDiff) {
                                left = textBoxAbsoluteLeft;
                            }
                        }
                    } else {
                        left = SuggestBox.this.box.getAbsoluteLeft();
                        if (offsetWidthDiff > 0) {
                            int windowRight = Window.getClientWidth() + Window.getScrollLeft();
                            int windowLeft = Window.getScrollLeft();
                            int distanceToWindowRight = windowRight - left;
                            int distanceFromWindowLeft = left - windowLeft;
                            if (distanceToWindowRight < offsetWidth && distanceFromWindowLeft >= offsetWidthDiff) {
                                left -= offsetWidthDiff;
                            }
                        }
                    }
                    int top = SuggestBox.this.box.getAbsoluteTop();
                    int windowTop = Window.getScrollTop();
                    int windowBottom = Window.getScrollTop() + Window.getClientHeight();
                    int distanceFromWindowTop = top - windowTop;
                    int distanceToWindowBottom = windowBottom - (top + SuggestBox.this.box.getOffsetHeight());
                    top = distanceToWindowBottom < offsetHeight && distanceFromWindowTop >= offsetHeight ? (top -= offsetHeight) : (top += SuggestBox.this.box.getOffsetHeight());
                    SuggestionPopup.this.setPopupPosition(left, top);
                }
            });
        }
    }

    private static class SuggestionMenuItem
    extends MenuItem {
        private static final String STYLENAME_DEFAULT = "item";
        private SuggestOracle.Suggestion suggestion;

        public SuggestionMenuItem(SuggestOracle.Suggestion suggestion, boolean asHTML) {
            super(suggestion.getDisplayString(), asHTML);
            DOM.setStyleAttribute(this.getElement(), "whiteSpace", "nowrap");
            this.setStyleName(STYLENAME_DEFAULT);
            this.setSuggestion(suggestion);
        }

        public SuggestOracle.Suggestion getSuggestion() {
            return this.suggestion;
        }

        public void setSuggestion(SuggestOracle.Suggestion suggestion) {
            this.suggestion = suggestion;
        }
    }

    private static class SuggestionMenu
    extends MenuBar {
        public SuggestionMenu(boolean vertical) {
            super(vertical);
            this.setStyleName("");
        }

        public void doSelectedItemAction() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                this.doItemAction(selectedItem, true);
            }
        }

        public int getNumItems() {
            return this.getItems().size();
        }

        public int getSelectedItemIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                return this.getItems().indexOf(selectedItem);
            }
            return -1;
        }

        public void selectItem(int index) {
            List<MenuItem> items = this.getItems();
            if (index > -1 && index < items.size()) {
                this.itemOver(items.get(index));
            }
        }
    }
}

