/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Vector;

public class MenuBar
extends Widget
implements PopupListener {
    private Element body;
    private Vector items = new Vector();
    private MenuBar parentMenu;
    private PopupPanel popup;
    private MenuItem selectedItem;
    private MenuBar shownChildMenu;
    private boolean vertical;
    private boolean autoOpen;

    public MenuBar() {
        this(false);
    }

    public MenuBar(boolean vertical) {
        Element table = DOM.createTable();
        this.body = DOM.createTBody();
        DOM.appendChild(table, this.body);
        if (!vertical) {
            Element tr = DOM.createTR();
            DOM.appendChild(this.body, tr);
        }
        this.vertical = vertical;
        Element outer = DOM.createDiv();
        DOM.appendChild(outer, table);
        this.setElement(outer);
        this.setStyleName("gwt-MenuBar");
    }

    public void addItem(MenuItem item) {
        Element tr;
        if (this.vertical) {
            tr = DOM.createTR();
            DOM.appendChild(this.body, tr);
        } else {
            tr = DOM.getChild(this.body, 0);
        }
        DOM.appendChild(tr, item.getElement());
        item.setParentMenu(this);
        item.setSelectionStyle(false);
        this.items.add(item);
    }

    public MenuItem addItem(String text, boolean asHTML, Command cmd) {
        MenuItem item = new MenuItem(text, asHTML, cmd);
        this.addItem(item);
        return item;
    }

    public MenuItem addItem(String text, boolean asHTML, MenuBar popup) {
        MenuItem item = new MenuItem(text, asHTML, popup);
        this.addItem(item);
        return item;
    }

    public MenuItem addItem(String text, Command cmd) {
        MenuItem item = new MenuItem(text, cmd);
        this.addItem(item);
        return item;
    }

    public MenuItem addItem(String text, MenuBar popup) {
        MenuItem item = new MenuItem(text, popup);
        this.addItem(item);
        return item;
    }

    public void clearItems() {
        Element container = this.getItemContainerElement();
        while (DOM.getChildCount(container) > 0) {
            DOM.removeChild(container, DOM.getChild(container, 0));
        }
        this.items.clear();
    }

    public boolean getAutoOpen() {
        return this.autoOpen;
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        MenuItem item = this.findItem(DOM.eventGetTarget(event));
        switch (DOM.eventGetType(event)) {
            case 1: {
                if (item == null) break;
                this.doItemAction(item, true);
                break;
            }
            case 16: {
                if (item == null) break;
                this.itemOver(item);
                break;
            }
            case 32: {
                if (item == null) break;
                this.itemOver(null);
            }
        }
    }

    public void onPopupClosed(PopupPanel sender, boolean autoClosed) {
        if (autoClosed) {
            this.closeAllParents();
        }
        this.onHide();
        this.shownChildMenu = null;
        this.popup = null;
    }

    public void removeItem(MenuItem item) {
        int idx = this.items.indexOf(item);
        if (idx == -1) {
            return;
        }
        Element container = this.getItemContainerElement();
        DOM.removeChild(container, DOM.getChild(container, idx));
        this.items.remove(idx);
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpen = autoOpen;
    }

    protected void onDetach() {
        if (this.popup != null) {
            this.popup.hide();
        }
        super.onDetach();
    }

    void closeAllParents() {
        MenuBar curMenu = this;
        while (curMenu != null) {
            curMenu.close();
            if (curMenu.parentMenu == null && curMenu.selectedItem != null) {
                curMenu.selectedItem.setSelectionStyle(false);
                curMenu.selectedItem = null;
            }
            curMenu = curMenu.parentMenu;
        }
    }

    void doItemAction(final MenuItem item, boolean fireCommand) {
        if (this.shownChildMenu != null && item.getSubMenu() == this.shownChildMenu) {
            return;
        }
        if (this.shownChildMenu != null) {
            this.shownChildMenu.onHide();
            this.popup.hide();
        }
        if (item.getSubMenu() == null) {
            if (fireCommand) {
                this.closeAllParents();
                Command cmd = item.getCommand();
                if (cmd != null) {
                    DeferredCommand.add(cmd);
                }
            }
            return;
        }
        this.selectItem(item);
        this.popup = new PopupPanel(true){
            {
                super(x0);
                this.setWidget(item.getSubMenu());
                item.getSubMenu().onShow();
            }

            public boolean onEventPreview(Event event) {
                switch (DOM.eventGetType(event)) {
                    case 1: {
                        Element target = DOM.eventGetTarget(event);
                        Element parentMenuElement = item.getParentMenu().getElement();
                        if (!DOM.isOrHasChild(parentMenuElement, target)) break;
                        return false;
                    }
                }
                return super.onEventPreview(event);
            }
        };
        this.popup.addPopupListener(this);
        if (this.vertical) {
            this.popup.setPopupPosition(item.getAbsoluteLeft() + item.getOffsetWidth(), item.getAbsoluteTop());
        } else {
            this.popup.setPopupPosition(item.getAbsoluteLeft(), item.getAbsoluteTop() + item.getOffsetHeight());
        }
        this.shownChildMenu = item.getSubMenu();
        item.getSubMenu().parentMenu = this;
        this.popup.show();
    }

    void itemOver(MenuItem item) {
        if (item == null && this.selectedItem != null && this.shownChildMenu == this.selectedItem.getSubMenu()) {
            return;
        }
        this.selectItem(item);
        if (item != null && (this.shownChildMenu != null || this.parentMenu != null || this.autoOpen)) {
            this.doItemAction(item, false);
        }
    }

    private void close() {
        if (this.parentMenu != null) {
            this.parentMenu.popup.hide();
        }
    }

    private MenuItem findItem(Element hItem) {
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem item = (MenuItem)this.items.get(i);
            if (!DOM.isOrHasChild(item.getElement(), hItem)) continue;
            return item;
        }
        return null;
    }

    private Element getItemContainerElement() {
        if (this.vertical) {
            return this.body;
        }
        return DOM.getChild(this.body, 0);
    }

    private void onHide() {
        if (this.shownChildMenu != null) {
            this.shownChildMenu.onHide();
            this.popup.hide();
        }
    }

    private void onShow() {
        if (this.items.size() > 0) {
            this.selectItem((MenuItem)this.items.get(0));
        }
    }

    private void selectItem(MenuItem item) {
        if (item == this.selectedItem) {
            return;
        }
        if (this.selectedItem != null) {
            this.selectedItem.setSelectionStyle(false);
        }
        if (item != null) {
            item.setSelectionStyle(true);
        }
        this.selectedItem = item;
    }
}

