/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SourcesTabEvents;
import com.google.gwt.user.client.ui.TabListener;
import com.google.gwt.user.client.ui.TabListenerCollection;
import com.google.gwt.user.client.ui.Widget;

public class TabBar
extends Composite
implements SourcesTabEvents,
ClickListener {
    private HorizontalPanel panel = new HorizontalPanel();
    private Widget selectedTab;
    private TabListenerCollection tabListeners;

    public TabBar() {
        this.initWidget(this.panel);
        this.sinkEvents(1);
        this.setStyleName("gwt-TabBar");
        this.panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        HTML first = new HTML("&nbsp;", true);
        HTML rest = new HTML("&nbsp;", true);
        first.setStyleName("gwt-TabBarFirst");
        rest.setStyleName("gwt-TabBarRest");
        first.setHeight("100%");
        rest.setHeight("100%");
        this.panel.add(first);
        this.panel.add(rest);
        first.setHeight("100%");
        this.panel.setCellHeight(first, "100%");
        this.panel.setCellWidth(rest, "100%");
    }

    public void addTab(String text) {
        this.insertTab(text, this.getTabCount());
    }

    public void addTab(String text, boolean asHTML) {
        this.insertTab(text, asHTML, this.getTabCount());
    }

    public void addTabListener(TabListener listener) {
        if (this.tabListeners == null) {
            this.tabListeners = new TabListenerCollection();
        }
        this.tabListeners.add(listener);
    }

    public int getSelectedTab() {
        if (this.selectedTab == null) {
            return -1;
        }
        return this.panel.getWidgetIndex(this.selectedTab) - 1;
    }

    public int getTabCount() {
        return this.panel.getWidgetCount() - 2;
    }

    public String getTabHTML(int index) {
        if (index >= this.getTabCount()) {
            return null;
        }
        Widget widget = this.panel.getWidget(index + 1);
        if (widget instanceof HTML) {
            return ((HTML)widget).getHTML();
        }
        return ((Label)widget).getText();
    }

    public void insertTab(String text, boolean asHTML, int beforeIndex) {
        if (beforeIndex < 0 || beforeIndex > this.getTabCount()) {
            throw new IndexOutOfBoundsException();
        }
        Label item = asHTML ? new HTML(text) : new Label(text);
        item.setWordWrap(false);
        item.addClickListener(this);
        item.setStyleName("gwt-TabBarItem");
        this.panel.insert(item, beforeIndex + 1);
    }

    public void insertTab(String text, int beforeIndex) {
        this.insertTab(text, false, beforeIndex);
    }

    public void onClick(Widget sender) {
        for (int i = 1; i < this.panel.getWidgetCount() - 1; ++i) {
            if (this.panel.getWidget(i) != sender) continue;
            this.selectTab(i - 1);
            return;
        }
    }

    public void removeTab(int index) {
        this.checkTabIndex(index);
        Widget toRemove = this.panel.getWidget(index + 1);
        if (toRemove == this.selectedTab) {
            this.selectedTab = null;
        }
        this.panel.remove(toRemove);
    }

    public void removeTabListener(TabListener listener) {
        if (this.tabListeners != null) {
            this.tabListeners.remove(listener);
        }
    }

    public boolean selectTab(int index) {
        this.checkTabIndex(index);
        if (this.tabListeners != null && !this.tabListeners.fireBeforeTabSelected(this, index)) {
            return false;
        }
        this.setSelectionStyle(this.selectedTab, false);
        if (index == -1) {
            this.selectedTab = null;
            return true;
        }
        this.selectedTab = this.panel.getWidget(index + 1);
        this.setSelectionStyle(this.selectedTab, true);
        if (this.tabListeners != null) {
            this.tabListeners.fireTabSelected(this, index);
        }
        return true;
    }

    private void checkTabIndex(int index) {
        if (index < -1 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void setSelectionStyle(Widget item, boolean selected) {
        if (item != null) {
            if (selected) {
                item.addStyleName("gwt-TabBarItem-selected");
            } else {
                item.removeStyleName("gwt-TabBarItem-selected");
            }
        }
    }
}

