/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.parsers.HtmlInterpreter;
import com.google.gwt.uibinder.parsers.HtmlMessageInterpreter;
import com.google.gwt.uibinder.parsers.InterpreterPipe;
import com.google.gwt.uibinder.parsers.WidgetInterpreter;
import com.google.gwt.uibinder.parsers.WidgetPlaceholderInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.messages.MessageWriter;
import com.google.gwt.uibinder.rebind.messages.PlaceholderInterpreter;

public class HTMLPanelParser
implements ElementParser {
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        String customTag = UiBinderWriter.escapeTextForJavaStringLiteral((String)elem.consumeAttribute("tag"));
        WidgetInterpreter widgetInterpreter = new WidgetInterpreter(fieldName, writer);
        HtmlInterpreter htmlInterpreter = this.makeHtmlInterpreter(fieldName, writer);
        writer.beginAttachedSection(fieldName + ".getElement()");
        String html = elem.consumeInnerHtml(InterpreterPipe.newPipe(widgetInterpreter, htmlInterpreter));
        writer.endAttachedSection();
        if ("".equals(customTag)) {
            writer.setFieldInitializerAsConstructor(fieldName, type, new String[]{"\"" + html + "\""});
        } else {
            writer.setFieldInitializerAsConstructor(fieldName, type, new String[]{"\"" + customTag + "\"", "\"" + html + "\""});
        }
    }

    private HtmlInterpreter makeHtmlInterpreter(final String fieldName, final UiBinderWriter uiWriter) {
        final String ancestorExpression = fieldName + ".getElement()";
        HtmlMessageInterpreter.PlaceholderInterpreterProvider placeholderInterpreterProvider = new HtmlMessageInterpreter.PlaceholderInterpreterProvider(){

            public PlaceholderInterpreter get(MessageWriter message) {
                return new WidgetPlaceholderInterpreter(fieldName, uiWriter, message, ancestorExpression);
            }
        };
        HtmlInterpreter htmlInterpreter = new HtmlInterpreter(uiWriter, ancestorExpression, new HtmlMessageInterpreter(uiWriter, placeholderInterpreterProvider));
        return htmlInterpreter;
    }
}

