/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.EnumAttributeParser;
import com.google.gwt.uibinder.attributeparsers.StrictAttributeParser;
import java.util.HashMap;
import java.util.Map;

public class AttributeParsers {
    private static final String DOUBLE = "double";
    private static final String BOOLEAN = "boolean";
    private final Map<String, String> parsers = new HashMap<String, String>();

    private static AttributeParser getAttributeParserByClassName(String parserClassName) {
        try {
            Class<AttributeParser> parserClass = Class.forName(parserClassName).asSubclass(AttributeParser.class);
            return parserClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to instantiate parser", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(parserClassName + " must extend AttributeParser");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate parser", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate parser", e);
        }
    }

    public AttributeParsers() {
        this.addAttributeParser(BOOLEAN, "com.google.gwt.uibinder.attributeparsers.BooleanAttributeParser");
        this.addAttributeParser("java.lang.String", "com.google.gwt.uibinder.attributeparsers.StringAttributeParser");
        this.addAttributeParser("int", "com.google.gwt.uibinder.attributeparsers.IntAttributeParser");
        this.addAttributeParser(DOUBLE, "com.google.gwt.uibinder.attributeparsers.DoubleAttributeParser");
        this.addAttributeParser("int,int", "com.google.gwt.uibinder.attributeparsers.IntPairParser");
        this.addAttributeParser("com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant", "com.google.gwt.uibinder.attributeparsers.HorizontalAlignmentConstantParser");
        this.addAttributeParser("com.google.gwt.user.client.ui.HasVerticalAlignment.VerticalAlignmentConstant", "com.google.gwt.uibinder.attributeparsers.VerticalAlignmentConstantParser");
    }

    public AttributeParser get(JType ... types) {
        JEnumType enumType;
        AttributeParser rtn = this.getForKey(this.getParametersKey(types));
        if (rtn != null || types.length > 1) {
            return rtn;
        }
        if (types.length == 1 && (enumType = types[0].isEnum()) != null) {
            return new EnumAttributeParser(enumType);
        }
        return new StrictAttributeParser();
    }

    private void addAttributeParser(String signature, String className) {
        this.parsers.put(signature, className);
    }

    private AttributeParser getForKey(String key) {
        String parserClassName = this.parsers.get(key);
        if (parserClassName != null) {
            return AttributeParsers.getAttributeParserByClassName(parserClassName);
        }
        return null;
    }

    private String getParametersKey(JType[] types) {
        StringBuffer b = new StringBuffer();
        for (JType t : types) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(t.getParameterizedQualifiedSourceName());
        }
        return b.toString();
    }
}

