/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.FieldReferenceConverter;
import com.google.gwt.uibinder.rebind.MortalLogger;

class StrictAttributeParser
implements AttributeParser {
    StrictAttributeParser() {
    }

    public String parse(String value, MortalLogger logger) throws UnableToCompleteException {
        try {
            return new FieldReferenceConverter(new FieldReferenceDelegate()).convert(value);
        }
        catch (FieldReferenceConverter.IllegalFieldReferenceException e) {
            logger.die("Cannot parse value: \"%s\"", new Object[]{value});
            return null;
        }
    }

    static class FieldReferenceDelegate
    implements FieldReferenceConverter.Delegate {
        boolean sawReference = false;

        FieldReferenceDelegate() {
        }

        public String handleFragment(String fragment) throws FieldReferenceConverter.IllegalFieldReferenceException {
            if (fragment.length() > 0) {
                throw new FieldReferenceConverter.IllegalFieldReferenceException();
            }
            return fragment;
        }

        public String handleReference(String reference) throws FieldReferenceConverter.IllegalFieldReferenceException {
            this.assertOnly();
            this.sawReference = true;
            return reference;
        }

        private void assertOnly() {
            if (this.sawReference) {
                throw new FieldReferenceConverter.IllegalFieldReferenceException();
            }
        }
    }
}

