/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.constants.DateTimeConstants;
import com.google.gwt.i18n.client.constants.NumberConstants;
import com.google.gwt.i18n.client.impl.CldrImpl;
import com.google.gwt.i18n.client.impl.LocaleInfoImpl;

public class LocaleInfo {
    private static LocaleInfo instance = new LocaleInfo((LocaleInfoImpl)GWT.create(LocaleInfoImpl.class), (CldrImpl)GWT.create(CldrImpl.class));
    private final LocaleInfoImpl infoImpl;
    private final CldrImpl cldrImpl;
    private DateTimeConstants dateTimeConstants;
    private NumberConstants numberConstants;

    public static final String[] getAvailableLocaleNames() {
        return LocaleInfo.instance.infoImpl.getAvailableLocaleNames();
    }

    public static final LocaleInfo getCurrentLocale() {
        return instance;
    }

    public static String getLocaleNativeDisplayName(String localeName) {
        return LocaleInfo.instance.infoImpl.getLocaleNativeDisplayName(localeName);
    }

    public static boolean hasAnyRTL() {
        return LocaleInfo.instance.infoImpl.hasAnyRTL();
    }

    protected LocaleInfo() {
        this.infoImpl = null;
        this.cldrImpl = null;
    }

    private LocaleInfo(LocaleInfoImpl impl, CldrImpl cldr) {
        this.infoImpl = impl;
        this.cldrImpl = cldr;
    }

    public final DateTimeConstants getDateTimeConstants() {
        this.ensureDateTimeConstants();
        return this.dateTimeConstants;
    }

    public final String getLocaleName() {
        return this.infoImpl.getLocaleName();
    }

    public final NumberConstants getNumberConstants() {
        this.ensureNumberConstants();
        return this.numberConstants;
    }

    public final boolean isRTL() {
        return this.cldrImpl.isRTL();
    }

    private void ensureDateTimeConstants() {
        if (this.dateTimeConstants == null) {
            this.dateTimeConstants = this.infoImpl.getDateTimeConstants();
        }
    }

    private void ensureNumberConstants() {
        if (this.numberConstants == null) {
            this.numberConstants = this.infoImpl.getNumberConstants();
        }
    }
}

