/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import com.google.gwt.logging.client.TextLogFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class FirebugLogHandler
extends Handler {
    public FirebugLogHandler() {
        this.setFormatter(new TextLogFormatter());
        this.setLevel(Level.ALL);
    }

    public void close() {
    }

    public void flush() {
    }

    public void publish(LogRecord record) {
        if (!this.isSupported() || !this.isLoggable(record)) {
            return;
        }
        String msg = this.getFormatter().format(record);
        int val = record.getLevel().intValue();
        if (val <= Level.FINE.intValue()) {
            this.debug(msg);
        } else if (val < Level.WARNING.intValue()) {
            this.info(msg);
        } else if (val < Level.SEVERE.intValue()) {
            this.warn(msg);
        } else {
            this.error(msg);
        }
    }

    private native void debug(String var1);

    private native void error(String var1);

    private native void info(String var1);

    private native boolean isSupported();

    private native void warn(String var1);
}

