/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import com.google.gwt.logging.client.HtmlLogFormatter;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Label;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HasWidgetsLogHandler
extends Handler {
    private HasWidgets widgetContainer;

    public HasWidgetsLogHandler(HasWidgets container) {
        this.widgetContainer = container;
        this.setFormatter(new HtmlLogFormatter());
        this.setLevel(Level.ALL);
    }

    public void clear() {
        this.widgetContainer.clear();
    }

    public void close() {
    }

    public void flush() {
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Formatter formatter = this.getFormatter();
        String msg = formatter.format(record);
        if (formatter instanceof HtmlLogFormatter) {
            this.widgetContainer.add(new HTML(msg));
        } else {
            this.widgetContainer.add(new Label(msg));
        }
    }
}

