/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HtmlLogFormatter
extends Formatter {
    public String format(LogRecord event) {
        StringBuilder html = new StringBuilder(this.getHtmlPrefix(event));
        html.append(this.getEscapedMessage(event));
        html.append(this.getHtmlSuffix(event));
        return html.toString();
    }

    protected String getHtmlPrefix(LogRecord event) {
        Date date = new Date(event.getMillis());
        StringBuilder prefix = new StringBuilder();
        prefix.append("<span style='color:");
        prefix.append(this.getColor(event.getLevel().intValue()));
        prefix.append("'>");
        prefix.append("<code>");
        prefix.append(date.toString());
        prefix.append(" ");
        prefix.append(event.getLoggerName());
        prefix.append(" ");
        prefix.append(event.getLevel().getName());
        prefix.append(": ");
        return prefix.toString();
    }

    protected String getHtmlSuffix(LogRecord event) {
        return "</code></span>";
    }

    private String getColor(int logLevel) {
        if (logLevel == Level.OFF.intValue()) {
            return "#000";
        }
        if (logLevel >= Level.SEVERE.intValue()) {
            return "#F00";
        }
        if (logLevel >= Level.WARNING.intValue()) {
            return "#E56717";
        }
        if (logLevel >= Level.INFO.intValue()) {
            return "#20b000";
        }
        if (logLevel >= Level.CONFIG.intValue()) {
            return "#2B60DE";
        }
        if (logLevel >= Level.FINE.intValue()) {
            return "#F0F";
        }
        if (logLevel >= Level.FINER.intValue()) {
            return "#F0F";
        }
        if (logLevel >= Level.FINEST.intValue()) {
            return "#F0F";
        }
        return "#000";
    }

    private String getEscapedMessage(LogRecord event) {
        String text = event.getMessage();
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        return text;
    }
}

