/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.TabLayoutPanel;

public class TabLayoutPanelParser
implements ElementParser {
    private static final String CUSTOM = "customHeader";
    private static final String HEADER = "header";
    private static final String TAB = "tab";

    public void parse(XMLElement panelElem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        String size = panelElem.consumeRequiredDoubleAttribute("barHeight");
        if ("".equals(size)) {
            writer.die(panelElem, "barHeight attribute is required", new Object[0]);
        }
        JEnumType unitEnumType = writer.getOracle().findType(Style.Unit.class.getCanonicalName()).isEnum();
        String unit = panelElem.consumeAttributeWithDefault("barUnit", String.format("%s.%s", unitEnumType.getQualifiedSourceName(), "PX"), (JType)unitEnumType);
        writer.setFieldInitializerAsConstructor(fieldName, writer.getOracle().findType(TabLayoutPanel.class.getName()), new String[]{size, unit});
        for (XMLElement tabElem : panelElem.consumeChildElements()) {
            if (!this.isElementType(panelElem, tabElem, TAB)) {
                writer.die(tabElem, "Only <%s:%s> children are allowed.", new Object[]{panelElem.getPrefix(), TAB});
            }
            Children children = this.findChildren(tabElem, writer);
            if (children.body == null) {
                writer.die(tabElem, "Must have a child widget", new Object[0]);
            }
            if (!writer.isWidgetElement(children.body)) {
                writer.die(children.body, "Must be a widget", new Object[0]);
            }
            String childFieldName = writer.parseElementToField(children.body);
            if (children.header != null) {
                HtmlInterpreter htmlInt = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                String html = children.header.consumeInnerHtml((XMLElement.Interpreter)htmlInt);
                writer.addStatement("%s.add(%s, \"%s\", true);", new Object[]{fieldName, childFieldName, html});
                continue;
            }
            if (children.customHeader != null) {
                XMLElement headerElement = children.customHeader.consumeSingleChildElement();
                if (!writer.isWidgetElement(headerElement)) {
                    writer.die(headerElement, "Is not a widget", new Object[0]);
                }
                String headerField = writer.parseElementToField(headerElement);
                writer.addStatement("%s.add(%s, %s);", new Object[]{fieldName, childFieldName, headerField});
                continue;
            }
            writer.die(tabElem, "Requires either a <%1$s:%2$s> or <%1$s:%3$s>", new Object[]{tabElem.getPrefix(), HEADER, CUSTOM});
        }
    }

    private Children findChildren(final XMLElement elem, final UiBinderWriter writer) throws UnableToCompleteException {
        final Children children = new Children();
        elem.consumeChildElements((XMLElement.Interpreter)new XMLElement.Interpreter<Boolean>(){

            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                if (this.hasTag(child, TabLayoutPanelParser.HEADER)) {
                    this.assertFirstHeader();
                    children.header = child;
                    return true;
                }
                if (this.hasTag(child, TabLayoutPanelParser.CUSTOM)) {
                    this.assertFirstHeader();
                    children.customHeader = child;
                    return true;
                }
                if (null != children.body) {
                    writer.die(children.body, "May have only one body element", new Object[0]);
                }
                children.body = child;
                return true;
            }

            void assertFirstHeader() throws UnableToCompleteException {
                if (null != children.header && null != children.customHeader) {
                    writer.die(elem, "May have only one %1$s:header or %1$s:customHeader", new Object[]{elem.getPrefix()});
                }
            }

            private boolean hasTag(XMLElement child, String attribute) {
                return this.rightNamespace(child) && child.getLocalName().equals(attribute);
            }

            private boolean rightNamespace(XMLElement child) {
                return child.getNamespaceUri().equals(elem.getNamespaceUri());
            }
        });
        return children;
    }

    private boolean isElementType(XMLElement parent, XMLElement child, String type) {
        return parent.getNamespaceUri().equals(child.getNamespaceUri()) && type.equals(child.getLocalName());
    }

    private static class Children {
        XMLElement body;
        XMLElement header;
        XMLElement customHeader;

        private Children() {
        }
    }
}

