/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.view.client.PagingListView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPager<T>
extends Composite
implements PagingListView.Pager<T> {
    private boolean isRangeLimited = true;
    private final PagingListView<T> view;

    public AbstractPager(PagingListView<T> view) {
        this.view = view;
        view.setPager(this);
    }

    public void firstPage() {
        this.setPage(0);
    }

    public int getPage() {
        int pageSize = this.view.getPageSize();
        return (this.view.getPageStart() + pageSize - 1) / pageSize;
    }

    public int getPageCount() {
        int pageSize = this.view.getPageSize();
        return (this.view.getDataSize() + pageSize - 1) / pageSize;
    }

    public PagingListView<T> getPagingListView() {
        return this.view;
    }

    public boolean hasNextPage() {
        return this.view.getPageStart() + this.view.getPageSize() < this.view.getDataSize();
    }

    public boolean hasPage(int index) {
        return this.view.getPageSize() * index < this.view.getDataSize();
    }

    public boolean hasPreviousPage() {
        return this.view.getPageStart() > 0 && this.view.getDataSize() > 0;
    }

    public boolean isRangeLimited() {
        return this.isRangeLimited;
    }

    public void lastPage() {
        this.setPage(this.getPageCount() - 1);
    }

    public void lastPageStart() {
        this.setPageStart(this.view.getDataSize() - this.view.getPageSize());
    }

    public void nextPage() {
        this.setPageStart(this.view.getPageStart() + this.view.getPageSize());
    }

    @Override
    public void onRangeOrSizeChanged(PagingListView<T> listView) {
        if (this.isRangeLimited) {
            this.setPageStart(this.view.getPageStart());
        }
    }

    public void previousPage() {
        this.setPageStart(this.view.getPageStart() - this.view.getPageSize());
    }

    public void setPage(int index) {
        if (!this.isRangeLimited || this.hasPage(index)) {
            this.view.setPageStart(this.view.getPageSize() * index);
        }
    }

    public void setPageStart(int index) {
        if (this.isRangeLimited) {
            index = Math.min(index, this.view.getDataSize() - this.view.getPageSize());
        }
        if ((index = Math.max(0, index)) != this.view.getPageStart()) {
            this.view.setPageStart(index);
        }
    }

    public void setRangeLimited(boolean isRangeLimited) {
        this.isRangeLimited = isRangeLimited;
    }
}

