/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.PageSizePager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListView;
import com.google.gwt.view.client.PagingListView;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.TreeViewModel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellBrowser
extends Composite
implements ProvidesResize,
RequiresResize,
HasAnimation {
    private static final String LEAF_IMAGE = "<div style='position:absolute;display:none;'></div>";
    private static Resources DEFAULT_RESOURCES;
    private static CellListResources cellListResource;
    private final ScrollAnimation animation = new ScrollAnimation();
    private int defaultWidth = 200;
    private final String closedImageHtml;
    private final String uniqueId = Document.get().createUniqueId();
    private boolean isAnimationEnabled;
    private int minWidth;
    private final int imageWidth;
    private final String openImageHtml;
    private final Style style;
    private Element scrollLock;
    private final List<TreeNode<?>> treeNodes = new ArrayList();
    private final TreeViewModel viewModel;

    private static CellListResources getCellListResources() {
        if (cellListResource == null) {
            cellListResource = (CellListResources)GWT.create(CellListResources.class);
        }
        return cellListResource;
    }

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public <T> CellBrowser(TreeViewModel viewModel, T rootValue) {
        this(viewModel, rootValue, CellBrowser.getDefaultResources());
    }

    public <T> CellBrowser(TreeViewModel viewModel, T rootValue, Resources resources) {
        this.viewModel = viewModel;
        this.style = resources.cellBrowserStyle();
        this.style.ensureInjected();
        this.initWidget(new SplitLayoutPanel());
        this.getElement().getStyle().setOverflow(Style.Overflow.AUTO);
        this.setStyleName("gwt-SideBySideTreeView");
        ImageResource treeOpen = resources.cellBrowserOpen();
        ImageResource treeClosed = resources.cellBrowserClosed();
        this.openImageHtml = this.getImageHtml(treeOpen);
        this.closedImageHtml = this.getImageHtml(treeClosed);
        this.imageWidth = Math.max(treeOpen.getWidth(), treeClosed.getWidth());
        this.minWidth = this.imageWidth + 20;
        this.scrollLock = Document.get().createDivElement();
        this.scrollLock.getStyle().setPosition(Style.Position.ABSOLUTE);
        this.scrollLock.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.scrollLock.getStyle().setZIndex(-32767);
        this.scrollLock.getStyle().setBackgroundColor("red");
        this.scrollLock.getStyle().setTop(0.0, Style.Unit.PX);
        this.scrollLock.getStyle().setLeft(0.0, Style.Unit.PX);
        this.scrollLock.getStyle().setHeight(1.0, Style.Unit.PX);
        this.scrollLock.getStyle().setWidth(1.0, Style.Unit.PX);
        this.getElement().appendChild(this.scrollLock);
        this.appendTreeNode(viewModel.getNodeInfo(rootValue));
        this.sinkEvents(16384);
    }

    public int getDefaultColumnWidth() {
        return this.defaultWidth;
    }

    public int getMinimumColumnWidth() {
        return this.minWidth;
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    @Override
    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 16384: {
                this.adjustScrollLock();
            }
        }
        super.onBrowserEvent(event);
    }

    @Override
    public void onResize() {
        this.getSplitLayoutPanel().onResize();
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void setDefaultColumnWidth(int width) {
        this.defaultWidth = width;
    }

    public void setMinimumColumnWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    protected <C> PagingListView.Pager<C> createPager(PagingListView<C> listView) {
        return new PageSizePager<C>(listView, listView.getPageSize());
    }

    protected <C> PagingListView<C> createPagingListView(TreeViewModel.NodeInfo<C> nodeInfo, Cell<C> cell) {
        CellList<C> pagingListView = new CellList<C>(cell, CellBrowser.getCellListResources());
        pagingListView.setValueUpdater(nodeInfo.getValueUpdater());
        return pagingListView;
    }

    private void adjustScrollLock() {
        int scrollLeft = this.getElement().getScrollLeft();
        if (scrollLeft > 0) {
            int clientWidth = this.getElement().getClientWidth();
            this.scrollLock.getStyle().setWidth(scrollLeft + clientWidth, Style.Unit.PX);
        } else {
            this.scrollLock.getStyle().setWidth(1.0, Style.Unit.PX);
        }
    }

    private <C> void appendTreeNode(final TreeViewModel.NodeInfo<C> nodeInfo) {
        final int level = this.treeNodes.size();
        CellDecorator<C> cell = new CellDecorator<C>(nodeInfo, level);
        final PagingListView<C> listView = this.createPagingListView(nodeInfo, cell);
        assert (listView instanceof Widget) : "createPagingListView() must return a widget";
        ScrollPanel scrollable = new ScrollPanel();
        PagingListView.Pager<C> pager = this.createPager(listView);
        if (pager != null) {
            assert (pager instanceof Widget) : "createPager() must return a widget";
            FlowPanel flowPanel = new FlowPanel();
            flowPanel.add((Widget)((Object)listView));
            flowPanel.add((Widget)((Object)pager));
            scrollable.setWidget(flowPanel);
        } else {
            scrollable.setWidget((Widget)((Object)listView));
        }
        scrollable.setStyleName(this.style.column());
        if (level == 0) {
            scrollable.addStyleName(this.style.firstColumn());
        }
        ListView listViewDelegate = new ListView<C>(){

            @Override
            public Range getRange() {
                return listView.getRange();
            }

            @Override
            public void setData(int start, int length, List<C> values) {
                TreeNode node = (TreeNode)CellBrowser.this.treeNodes.get(level);
                Object openKey = node.getCell().openKey;
                if (openKey != null) {
                    boolean stillExists = false;
                    ProvidesKey keyProvider = nodeInfo.getProvidesKey();
                    for (Object value : values) {
                        if (!openKey.equals(keyProvider.getKey(value))) continue;
                        stillExists = true;
                        break;
                    }
                    if (!stillExists) {
                        CellBrowser.this.trimToLevel(level);
                    }
                }
                listView.setData(start, length, values);
            }

            @Override
            public void setDataSize(int size, boolean isExact) {
                listView.setDataSize(size, isExact);
            }

            @Override
            public void setDelegate(ListView.Delegate<C> delegate) {
                listView.setDelegate(delegate);
            }

            @Override
            public void setSelectionModel(SelectionModel<? super C> selectionModel) {
                listView.setSelectionModel(selectionModel);
            }
        };
        TreeNode<C> treeNode = new TreeNode<C>(nodeInfo, listViewDelegate, cell, scrollable);
        this.treeNodes.add(treeNode);
        listView.setSelectionModel(nodeInfo.getSelectionModel());
        nodeInfo.setView(listViewDelegate);
        SplitLayoutPanel splitPanel = this.getSplitLayoutPanel();
        splitPanel.insertWest(scrollable, this.defaultWidth, null);
        splitPanel.setWidgetMinSize(scrollable, this.minWidth);
        splitPanel.forceLayout();
        this.animation.scrollToEnd();
    }

    private String getImageHtml(ImageResource res) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div style=\"position:absolute;right:0px;top:0px;height:100%;");
        sb.append("width:").append(res.getWidth()).append("px;");
        sb.append("background:url('").append(res.getURL()).append("') ");
        sb.append("no-repeat scroll center center transparent;");
        sb.append("\"></div>");
        return sb.toString();
    }

    private SplitLayoutPanel getSplitLayoutPanel() {
        return (SplitLayoutPanel)this.getWidget();
    }

    private void trimToLevel(int level) {
        this.adjustScrollLock();
        for (int curLevel = this.treeNodes.size() - 1; curLevel > level; --curLevel) {
            TreeNode<?> removed = this.treeNodes.remove(curLevel);
            removed.cleanup();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeNode<C> {
        private CellDecorator<C> cell;
        private ListView<C> listView;
        private TreeViewModel.NodeInfo<C> nodeInfo;
        private Widget widget;

        public TreeNode(TreeViewModel.NodeInfo<C> nodeInfo, ListView<C> listView, CellDecorator<C> cell, Widget widget) {
            this.cell = cell;
            this.listView = listView;
            this.nodeInfo = nodeInfo;
            this.widget = widget;
        }

        public CellDecorator<C> getCell() {
            return this.cell;
        }

        void cleanup() {
            this.listView.setSelectionModel(null);
            this.nodeInfo.unsetView();
            CellBrowser.this.getSplitLayoutPanel().remove(this.widget);
        }
    }

    private class ScrollAnimation
    extends Animation {
        private int startScrollLeft;
        private int targetScrollLeft;

        private ScrollAnimation() {
        }

        protected void onComplete() {
            CellBrowser.this.getElement().setScrollLeft(this.targetScrollLeft);
        }

        protected void onUpdate(double progress) {
            int diff = this.targetScrollLeft - this.startScrollLeft;
            CellBrowser.this.getElement().setScrollLeft(this.startScrollLeft + (int)((double)diff * progress));
        }

        void scrollToEnd() {
            com.google.gwt.user.client.Element elem = CellBrowser.this.getElement();
            this.targetScrollLeft = elem.getScrollWidth() - elem.getClientWidth();
            if (CellBrowser.this.isAnimationEnabled()) {
                this.startScrollLeft = elem.getScrollLeft();
                this.run(250);
            } else {
                this.onComplete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellDecorator<C>
    extends AbstractCell<C> {
        private final Cell<C> cell;
        private final int level;
        private Object openKey;
        private final ProvidesKey<C> providesKey;
        private final SelectionModel<? super C> selectionModel;

        public CellDecorator(TreeViewModel.NodeInfo<C> nodeInfo, int level) {
            this.cell = nodeInfo.getCell();
            this.level = level;
            this.providesKey = nodeInfo.getProvidesKey();
            this.selectionModel = nodeInfo.getSelectionModel();
        }

        @Override
        public boolean consumesEvents() {
            return this.cell.consumesEvents();
        }

        @Override
        public boolean dependsOnSelection() {
            return this.cell.dependsOnSelection();
        }

        @Override
        public Object onBrowserEvent(Element parent, C value, Object viewData, NativeEvent event, ValueUpdater<C> valueUpdater) {
            viewData = this.cell.onBrowserEvent(this.getCellParent(parent), value, viewData, event, valueUpdater);
            if (Event.getTypeInt(event.getType()) == 4) {
                TreeViewModel.NodeInfo<?> nodeInfo;
                CellBrowser.this.trimToLevel(this.level);
                Element curOpenItem = Document.get().getElementById(this.getOpenId());
                if (curOpenItem != null) {
                    this.setElementOpenState(curOpenItem.getParentElement(), false);
                }
                this.openKey = null;
                if (!CellBrowser.this.viewModel.isLeaf(value) && (nodeInfo = CellBrowser.this.viewModel.getNodeInfo(value)) != null) {
                    this.openKey = this.providesKey.getKey(value);
                    this.setElementOpenState(parent, true);
                    CellBrowser.this.appendTreeNode(nodeInfo);
                }
            }
            return viewData;
        }

        @Override
        public void render(C value, Object viewData, StringBuilder sb) {
            boolean isOpen = this.openKey == null ? false : this.openKey.equals(this.providesKey.getKey(value));
            boolean isSelected = this.selectionModel == null ? false : this.selectionModel.isSelected(value);
            sb.append("<div style='position:relative;padding-right:");
            sb.append(CellBrowser.this.imageWidth);
            sb.append("px;'");
            sb.append(" class='").append(CellBrowser.this.style.item());
            if (isOpen) {
                sb.append(" ").append(CellBrowser.this.style.openItem());
            }
            if (isSelected) {
                sb.append(" ").append(CellBrowser.this.style.selectedItem());
            }
            sb.append("'");
            if (isOpen) {
                sb.append(" id='").append(this.getOpenId()).append("'");
            }
            sb.append(">");
            if (isOpen) {
                sb.append(CellBrowser.this.openImageHtml);
            } else if (CellBrowser.this.viewModel.isLeaf(value)) {
                sb.append(CellBrowser.LEAF_IMAGE);
            } else {
                sb.append(CellBrowser.this.closedImageHtml);
            }
            sb.append("<div>");
            this.cell.render(value, viewData, sb);
            sb.append("</div></div>");
        }

        @Override
        public void setValue(Element parent, C value, Object viewData) {
            this.cell.setValue(this.getCellParent(parent), value, viewData);
        }

        private Element getCellParent(Element parent) {
            return (Element)parent.getFirstChildElement().getChild(1).cast();
        }

        private Element getImageElement(Element parent) {
            return parent.getFirstChildElement().getFirstChildElement();
        }

        private String getOpenId() {
            return CellBrowser.this.uniqueId + "-" + this.level;
        }

        private void setElementOpenState(Element parent, boolean open) {
            Element wrapper = parent.getFirstChildElement();
            if (open) {
                wrapper.addClassName(CellBrowser.this.style.openItem());
                wrapper.setId(this.getOpenId());
            } else {
                wrapper.removeClassName(CellBrowser.this.style.openItem());
                wrapper.setId("");
            }
            String html = open ? CellBrowser.this.openImageHtml : CellBrowser.this.closedImageHtml;
            DivElement tmp = Document.get().createDivElement();
            tmp.setInnerHTML(html);
            Element imageElem = tmp.getFirstChildElement();
            Element oldImg = this.getImageElement(parent);
            wrapper.replaceChild(imageElem, oldImg);
        }
    }

    static interface CellListResources
    extends CellList.Resources {
        @ClientBundle.Source(value={"CellBrowserOverride.css"})
        public CellList.Style cellListStyle();
    }

    public static interface Style
    extends CssResource {
        public String column();

        public String firstColumn();

        public String item();

        public String openItem();

        public String selectedItem();
    }

    public static interface Resources
    extends ClientBundle {
        public ImageResource cellBrowserClosed();

        public ImageResource cellBrowserOpen();

        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal)
        public ImageResource cellBrowserOpenBackground();

        @ClientBundle.Source(value={"cellTreeSelectedBackground.png"})
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal)
        public ImageResource cellBrowserSelectedBackground();

        @ClientBundle.Source(value={"CellBrowser.css"})
        public Style cellBrowserStyle();
    }
}

