/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.view.client.AbstractListViewAdapter;
import com.google.gwt.view.client.ListView;
import com.google.gwt.view.client.PagingListView;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CellListImpl<T> {
    private Element childContainer;
    private final List<T> data = new ArrayList<T>();
    private int dataSize;
    private boolean dataSizeInitialized;
    private ListView.Delegate<T> delegate;
    private String lastContents = null;
    private final PagingListView<T> listView;
    private PagingListView.Pager<T> pager;
    private int pageSize;
    private int pageStart = 0;
    private boolean pageStartChanged;
    private boolean redrawScheduled;
    private final Scheduler.ScheduledCommand refreshCommand = new Scheduler.ScheduledCommand(){

        public void execute() {
            boolean wasRefreshScheduled = CellListImpl.this.refreshScheduled;
            boolean wasRedrawScheduled = CellListImpl.this.redrawScheduled;
            CellListImpl.this.refreshScheduled = false;
            CellListImpl.this.redrawScheduled = false;
            if (wasRefreshScheduled && CellListImpl.this.delegate != null) {
                CellListImpl.this.delegate.onRangeChanged(CellListImpl.this.listView);
            } else if (wasRedrawScheduled) {
                CellListImpl.this.setData(CellListImpl.this.data, CellListImpl.this.pageStart);
            }
        }
    };
    private boolean refreshScheduled;
    private HandlerRegistration selectionHandler;
    private final Set<Integer> selectedRows = new HashSet<Integer>();
    private SelectionModel<? super T> selectionModel;
    private final Element tmpElem;

    public CellListImpl(PagingListView<T> listView, int pageSize, Element childContainer) {
        this.childContainer = childContainer;
        this.listView = listView;
        this.pageSize = pageSize;
        this.tmpElem = Document.get().createDivElement();
    }

    public List<T> getData() {
        return this.data;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getDisplayedItemCount() {
        return Math.min(this.pageSize, this.dataSize - this.pageStart);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public Range getRange() {
        return new AbstractListViewAdapter.DefaultRange(this.pageStart, this.pageSize);
    }

    public SelectionModel<? super T> getSelectionModel() {
        return this.selectionModel;
    }

    public void redraw() {
        this.lastContents = null;
        this.scheduleRefresh(true);
    }

    public void refresh() {
        this.scheduleRefresh(false);
    }

    public void setData(List<T> values, int valuesStart) {
        int boundedEnd;
        int valuesLength = values.size();
        int valuesEnd = valuesStart + valuesLength;
        int pageEnd = this.pageStart + this.pageSize;
        int boundedStart = Math.max(valuesStart, this.pageStart);
        if (boundedStart >= (boundedEnd = Math.min(valuesEnd, pageEnd))) {
            return;
        }
        if (valuesEnd > this.dataSize) {
            this.dataSize = valuesEnd;
            this.onSizeChanged();
        }
        for (int lastCacheIndex = this.pageStart + this.data.size(); lastCacheIndex < boundedStart; ++lastCacheIndex) {
            this.data.add(null);
        }
        for (int i = boundedStart; i < boundedEnd; ++i) {
            T value = values.get(i - valuesStart);
            int dataIndex = i - this.pageStart;
            if (dataIndex < this.data.size()) {
                this.data.set(dataIndex, value);
            } else {
                this.data.add(value);
            }
            if (this.selectionModel == null) continue;
            if (value != null && this.selectionModel.isSelected(value)) {
                this.selectedRows.add(i);
                continue;
            }
            this.selectedRows.remove(i);
        }
        boundedStart = this.pageStartChanged ? this.pageStart : boundedStart;
        List<T> boundedValues = this.data.subList(boundedStart - this.pageStart, boundedEnd - this.pageStart);
        int boundedSize = boundedValues.size();
        StringBuilder sb = new StringBuilder();
        this.emitHtml(sb, boundedValues, boundedStart, this.selectionModel);
        int childCount = this.childContainer.getChildCount();
        if (boundedStart == this.pageStart && (boundedSize >= childCount || boundedSize >= this.getDisplayedItemCount())) {
            String newContents = sb.toString();
            if (!newContents.equals(this.lastContents)) {
                this.lastContents = newContents;
                this.childContainer = this.renderChildContents(newContents);
            }
        } else {
            this.lastContents = null;
            Element container = this.convertToElements(sb.toString());
            Element toReplace = null;
            int realStart = boundedStart - this.pageStart;
            if (realStart < childCount) {
                toReplace = (Element)this.childContainer.getChild(realStart).cast();
            }
            for (int i = boundedStart; i < boundedEnd; ++i) {
                if (toReplace == null) {
                    this.childContainer.appendChild(container.getChild(0));
                    continue;
                }
                Element nextSibling = toReplace.getNextSiblingElement();
                this.childContainer.replaceChild(container.getChild(0), toReplace);
                toReplace = nextSibling;
            }
        }
        this.pageStartChanged = false;
    }

    public void setDataSize(int size) {
        if (this.dataSizeInitialized && size == this.dataSize) {
            return;
        }
        this.dataSizeInitialized = true;
        this.dataSize = size;
        this.lastContents = null;
        this.updateDataAndView();
        this.onSizeChanged();
    }

    public void setDelegate(ListView.Delegate<T> delegate) {
        this.delegate = delegate;
    }

    public void setPager(PagingListView.Pager<T> pager) {
        this.pager = pager;
    }

    public void setPageSize(int pageSize) {
        if (pageSize == this.pageSize) {
            return;
        }
        this.pageSize = pageSize;
        this.updateDataAndView();
        this.onSizeChanged();
        this.refresh();
    }

    public void setPageStart(int pageStart) {
        if (pageStart == this.pageStart) {
            return;
        }
        if (pageStart > this.pageStart) {
            if (this.data.size() > pageStart - this.pageStart) {
                for (int i = this.pageStart; i < pageStart; ++i) {
                    this.data.remove(0);
                }
            } else {
                this.data.clear();
            }
        } else if (this.data.size() > 0 && this.pageStart - pageStart < this.pageSize) {
            for (int i = pageStart; i < this.pageStart; ++i) {
                this.data.add(0, null);
            }
        } else {
            this.data.clear();
        }
        this.pageStart = pageStart;
        this.pageStartChanged = true;
        this.updateDataAndView();
        this.onSizeChanged();
        this.setData(this.data, pageStart);
        this.refresh();
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel, boolean updateSelection) {
        if (this.selectionHandler != null) {
            this.selectionHandler.removeHandler();
            this.selectionHandler = null;
        }
        this.selectionModel = selectionModel;
        if (selectionModel != null) {
            this.selectionHandler = selectionModel.addSelectionChangeHandler(new SelectionModel.SelectionChangeHandler(){

                public void onSelectionChange(SelectionModel.SelectionChangeEvent event) {
                    CellListImpl.this.updateSelection();
                }
            });
        }
        if (updateSelection) {
            this.updateSelection();
        }
    }

    protected Element convertToElements(String html) {
        this.tmpElem.setInnerHTML(html);
        return this.tmpElem;
    }

    protected abstract boolean dependsOnSelection();

    protected abstract void emitHtml(StringBuilder var1, List<T> var2, int var3, SelectionModel<? super T> var4);

    protected void onSizeChanged() {
        if (this.pager != null) {
            this.pager.onRangeOrSizeChanged(this.listView);
        }
    }

    protected void removeLastItem() {
        this.childContainer.getLastChild().removeFromParent();
    }

    protected Element renderChildContents(String html) {
        this.childContainer.setInnerHTML(html);
        return this.childContainer;
    }

    protected abstract void setSelected(Element var1, boolean var2);

    protected void updateSelection() {
        boolean dependsOnSelection = this.dependsOnSelection();
        boolean refreshRequired = false;
        Element cellElem = this.childContainer.getFirstChildElement();
        int row = this.pageStart;
        for (T value : this.data) {
            boolean selected;
            boolean bl = selected = this.selectionModel == null ? false : this.selectionModel.isSelected(value);
            if (selected != this.selectedRows.contains(row)) {
                refreshRequired = true;
                if (selected) {
                    this.selectedRows.add(row);
                } else {
                    this.selectedRows.remove(row);
                }
                if (!dependsOnSelection && cellElem != null) {
                    this.setSelected(cellElem, selected);
                }
            }
            if (cellElem == null) break;
            cellElem = cellElem.getNextSiblingElement();
            ++row;
        }
        if (refreshRequired && dependsOnSelection) {
            this.setData(this.data, this.pageStart);
        }
    }

    private void scheduleRefresh(boolean redrawOnly) {
        if (!this.refreshScheduled && !this.redrawScheduled) {
            Scheduler.get().scheduleDeferred(this.refreshCommand);
        }
        if (redrawOnly) {
            this.redrawScheduled = true;
        } else {
            this.refreshScheduled = true;
        }
    }

    private void updateDataAndView() {
        int expectedLastIndex = Math.max(0, Math.min(this.pageSize, this.dataSize - this.pageStart));
        for (int lastIndex = this.data.size() - 1; lastIndex >= expectedLastIndex; --lastIndex) {
            this.data.remove(lastIndex);
            this.selectedRows.remove(lastIndex + this.pageStart);
        }
        int expectedChildCount = this.data.size();
        for (int childCount = this.childContainer.getChildCount(); childCount > expectedChildCount; --childCount) {
            this.removeLastItem();
        }
    }
}

