/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditTextCell
extends AbstractCell<String> {
    @Override
    public boolean consumesEvents() {
        return true;
    }

    public String onBrowserEvent(Element parent, String value, Object viewData, NativeEvent event, ValueUpdater<String> valueUpdater) {
        if (viewData != null) {
            return this.editEvent(parent, value, (String)viewData, event, valueUpdater);
        }
        return this.nonEditEvent(parent, value, event);
    }

    @Override
    public void render(String value, Object viewData, StringBuilder sb) {
        if (viewData != null) {
            sb.append("<input type='text' value='" + viewData + "'></input>");
        } else {
            sb.append(value);
        }
    }

    protected String edit(Element parent, String value) {
        this.setValue(parent, value, value);
        InputElement input = (InputElement)parent.getFirstChild();
        input.focus();
        input.select();
        return value;
    }

    private String cancel(Element parent, String value) {
        this.setValue(parent, value, null);
        return null;
    }

    private String commit(Element parent, ValueUpdater<String> valueUpdater) {
        InputElement input = (InputElement)parent.getFirstChild();
        String value = input.getValue();
        valueUpdater.update(value);
        return this.cancel(parent, value);
    }

    private String editEvent(Element parent, String value, String viewData, NativeEvent event, ValueUpdater<String> valueUpdater) {
        if ("keydown".equals(event.getType())) {
            if (event.getKeyCode() == 13) {
                return this.commit(parent, valueUpdater);
            }
            if (event.getKeyCode() == 27) {
                return this.cancel(parent, value);
            }
        }
        return viewData;
    }

    private String nonEditEvent(Element parent, String value, NativeEvent event) {
        if ("click".equals(event.getType())) {
            return this.edit(parent, value);
        }
        return null;
    }
}

