/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.event.shared;

import com.google.gwt.event.shared.DefaultHandlerRegistration;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.UmbrellaException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerManager {
    private int firingDepth = 0;
    private boolean isReverseOrder;
    private HandlerRegistry registry = new HandlerRegistry();
    private final Object source;
    private List<AddOrRemoveCommand> deferredDeltas;

    public HandlerManager(Object source) {
        this(source, false);
    }

    public HandlerManager(Object source, boolean fireInReverseOrder) {
        this.source = source;
        this.isReverseOrder = fireInReverseOrder;
    }

    public <H extends EventHandler> HandlerRegistration addHandler(GwtEvent.Type<H> type, H handler) {
        assert (type != null) : "Cannot add a handler with a null type";
        assert (handler != null) : "Cannot add a null handler";
        if (this.firingDepth > 0) {
            this.enqueueAdd(type, handler);
        } else {
            this.doAdd(type, handler);
        }
        return new DefaultHandlerRegistration(this, type, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(GwtEvent<?> event) {
        if (!event.isLive()) {
            event.revive();
        }
        Object oldSource = event.getSource();
        event.setSource(this.source);
        try {
            ++this.firingDepth;
            this.registry.fireEvent(event, this.isReverseOrder);
        }
        finally {
            --this.firingDepth;
            if (this.firingDepth == 0) {
                this.handleQueuedAddsAndRemoves();
            }
            if (oldSource == null) {
                event.kill();
            } else {
                event.setSource(oldSource);
            }
        }
    }

    public <H extends EventHandler> H getHandler(GwtEvent.Type<H> type, int index) {
        assert (index < this.getHandlerCount(type)) : "handlers for " + type.getClass() + " have size: " + this.getHandlerCount(type) + " so do not have a handler at index: " + index;
        return (H)this.registry.getHandler(type, index);
    }

    public int getHandlerCount(GwtEvent.Type<?> type) {
        return this.registry.getHandlerCount(type);
    }

    public boolean isEventHandled(GwtEvent.Type<?> e) {
        return this.registry.isEventHandled(e);
    }

    public <H extends EventHandler> void removeHandler(GwtEvent.Type<H> type, H handler) {
        if (this.firingDepth > 0) {
            this.enqueueRemove(type, handler);
        } else {
            this.doRemove(type, handler);
        }
    }

    Map<GwtEvent.Type<?>, ArrayList<?>> createHandlerInfo() {
        return this.registry.map;
    }

    private void defer(AddOrRemoveCommand command) {
        if (this.deferredDeltas == null) {
            this.deferredDeltas = new ArrayList<AddOrRemoveCommand>();
        }
        this.deferredDeltas.add(command);
    }

    private <H extends EventHandler> void doAdd(GwtEvent.Type<H> type, H handler) {
        this.registry.addHandler(type, handler);
    }

    private <H extends EventHandler> void doRemove(GwtEvent.Type<H> type, H handler) {
        this.registry.removeHandler(type, handler);
    }

    private <H extends EventHandler> void enqueueAdd(final GwtEvent.Type<H> type, final H handler) {
        this.defer(new AddOrRemoveCommand(){

            public void execute() {
                HandlerManager.this.doAdd(type, handler);
            }
        });
    }

    private <H extends EventHandler> void enqueueRemove(final GwtEvent.Type<H> type, final H handler) {
        this.defer(new AddOrRemoveCommand(){

            public void execute() {
                HandlerManager.this.doRemove(type, handler);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueuedAddsAndRemoves() {
        if (this.deferredDeltas != null) {
            try {
                for (AddOrRemoveCommand c : this.deferredDeltas) {
                    c.execute();
                }
            }
            finally {
                this.deferredDeltas = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerRegistry {
        private final HashMap<GwtEvent.Type<?>, ArrayList<?>> map = new HashMap();

        private HandlerRegistry() {
        }

        private <H extends EventHandler> void addHandler(GwtEvent.Type<H> type, H handler) {
            ArrayList<Object> l = this.get(type);
            if (l == null) {
                l = new ArrayList();
                this.map.put(type, l);
            }
            l.add(handler);
        }

        private <H extends EventHandler> void fireEvent(GwtEvent<H> event, boolean isReverseOrder) {
            GwtEvent.Type<H> type = event.getAssociatedType();
            int count = this.getHandlerCount(type);
            HashSet<Throwable> causes = null;
            if (isReverseOrder) {
                for (int i = count - 1; i >= 0; --i) {
                    H handler = this.getHandler(type, i);
                    try {
                        event.dispatch(handler);
                        continue;
                    }
                    catch (Throwable e) {
                        if (causes == null) {
                            causes = new HashSet();
                        }
                        causes.add(e);
                    }
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    H handler = this.getHandler(type, i);
                    try {
                        event.dispatch(handler);
                        continue;
                    }
                    catch (Throwable e) {
                        if (causes == null) {
                            causes = new HashSet<Throwable>();
                        }
                        causes.add(e);
                    }
                }
            }
            if (causes != null) {
                throw new UmbrellaException(causes);
            }
        }

        private <H> ArrayList<H> get(GwtEvent.Type<H> type) {
            return this.map.get(type);
        }

        private <H extends EventHandler> H getHandler(GwtEvent.Type<H> eventKey, int index) {
            ArrayList<H> l = this.get(eventKey);
            return (H)((EventHandler)l.get(index));
        }

        private int getHandlerCount(GwtEvent.Type<?> eventKey) {
            ArrayList<?> l = this.map.get(eventKey);
            return l == null ? 0 : l.size();
        }

        private boolean isEventHandled(GwtEvent.Type<?> eventKey) {
            return this.map.containsKey(eventKey);
        }

        private <H> void removeHandler(GwtEvent.Type<H> eventKey, H handler) {
            boolean result;
            ArrayList<H> l = this.get(eventKey);
            boolean bl = result = l == null ? false : l.remove(handler);
            if (result && l.size() == 0) {
                this.map.remove(eventKey);
            }
            assert (result) : "Tried to remove unknown handler: " + handler + " from " + eventKey;
        }
    }

    private static interface AddOrRemoveCommand {
        public void execute();
    }
}

