/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.CellListImpl;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListView;
import com.google.gwt.view.client.PagingListView;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellList<T>
extends Widget
implements PagingListView<T> {
    private static final int DEFAULT_PAGE_SIZE = 25;
    private static Resources DEFAULT_RESOURCES;
    private final Cell<T> cell;
    private final Element childContainer;
    private String emptyListMessage = "";
    private final Element emptyMessageElem;
    private final CellListImpl<T> impl;
    private final Style style;
    private ValueUpdater<T> valueUpdater;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public CellList(Cell<T> cell) {
        this(cell, CellList.getDefaultResources());
    }

    public CellList(final Cell<T> cell, Resources resources) {
        this.cell = cell;
        this.style = resources.cellListStyle();
        this.style.ensureInjected();
        this.childContainer = Document.get().createDivElement();
        this.emptyMessageElem = Document.get().createDivElement();
        this.showOrHide(this.emptyMessageElem, false);
        DivElement outerDiv = Document.get().createDivElement();
        outerDiv.appendChild(this.childContainer);
        outerDiv.appendChild(this.emptyMessageElem);
        this.setElement(outerDiv);
        this.sinkEvents(1149);
        this.impl = new CellListImpl<T>(this, 25, this.childContainer){

            @Override
            protected boolean dependsOnSelection() {
                return cell.dependsOnSelection();
            }

            @Override
            protected void emitHtml(StringBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
                int length = values.size();
                int end = start + length;
                for (int i = start; i < end; ++i) {
                    Object value = values.get(i - start);
                    boolean isSelected = selectionModel == null ? false : selectionModel.isSelected(value);
                    sb.append("<div onclick='' __idx='").append(i).append("'");
                    sb.append(" class='");
                    sb.append(i % 2 == 0 ? CellList.this.style.evenItem() : CellList.this.style.oddItem());
                    if (isSelected) {
                        sb.append(" ").append(CellList.this.style.selectedItem());
                    }
                    sb.append("'>");
                    cell.render(value, null, sb);
                    sb.append("</div>");
                }
            }

            @Override
            protected void onSizeChanged() {
                super.onSizeChanged();
                CellList.this.showOrHide(CellList.this.emptyMessageElem, CellList.this.impl.getDataSize() == 0);
            }

            @Override
            protected void setSelected(Element elem, boolean selected) {
                CellList.setStyleName(elem, CellList.this.style.selectedItem(), selected);
            }
        };
    }

    @Override
    public int getDataSize() {
        return this.impl.getDataSize();
    }

    public T getDisplayedItem(int indexOnPage) {
        this.checkRowBounds(indexOnPage);
        return this.impl.getData().get(indexOnPage);
    }

    public List<T> getDisplayedItems() {
        return new ArrayList<T>(this.impl.getData());
    }

    public String getEmptyListMessage() {
        return this.emptyListMessage;
    }

    @Override
    public int getPageSize() {
        return this.impl.getPageSize();
    }

    @Override
    public int getPageStart() {
        return this.impl.getPageStart();
    }

    @Override
    public Range getRange() {
        return this.impl.getRange();
    }

    public Element getRowElement(int indexOnPage) {
        this.checkRowBounds(indexOnPage);
        if (this.childContainer.getChildCount() > indexOnPage) {
            return (Element)this.childContainer.getChild(indexOnPage).cast();
        }
        return null;
    }

    @Override
    public boolean isDataSizeExact() {
        return this.impl.dataSizeIsExact();
    }

    @Override
    public void onBrowserEvent(Event event) {
        Element target;
        super.onBrowserEvent(event);
        String idxString = "";
        for (target = (Element)event.getEventTarget().cast(); target != null && (idxString = target.getAttribute("__idx")).length() == 0; target = target.getParentElement()) {
        }
        if (idxString.length() > 0) {
            SelectionModel<T> selectionModel;
            int idx = Integer.parseInt(idxString);
            T value = this.impl.getData().get(idx - this.impl.getPageStart());
            this.cell.onBrowserEvent(target, value, null, event, this.valueUpdater);
            if (event.getTypeInt() == 1 && !this.cell.consumesEvents() && (selectionModel = this.impl.getSelectionModel()) != null) {
                selectionModel.setSelected(value, true);
            }
        }
    }

    public void redraw() {
        this.impl.redraw();
    }

    public void refresh() {
        this.impl.refresh();
    }

    @Override
    public void setData(int start, int length, List<T> values) {
        this.impl.setData(values, start);
    }

    @Override
    public void setDataSize(int size, boolean isExact) {
        this.impl.setDataSize(size, isExact);
    }

    @Override
    public void setDelegate(ListView.Delegate<T> delegate) {
        this.impl.setDelegate(delegate);
    }

    public void setEmptyListMessage(String html) {
        this.emptyListMessage = html;
        this.emptyMessageElem.setInnerHTML(html);
    }

    @Override
    public void setPager(PagingListView.Pager<T> pager) {
        this.impl.setPager(pager);
    }

    @Override
    public void setPageSize(int pageSize) {
        this.impl.setPageSize(pageSize);
    }

    @Override
    public void setPageStart(int pageStart) {
        this.impl.setPageStart(pageStart);
    }

    @Override
    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.impl.setSelectionModel(selectionModel, true);
    }

    public void setValueUpdater(ValueUpdater<T> valueUpdater) {
        this.valueUpdater = valueUpdater;
    }

    protected void checkRowBounds(int row) {
        int rowSize = this.impl.getDisplayedItemCount();
        if (row >= rowSize || row < 0) {
            throw new IndexOutOfBoundsException("Row index: " + row + ", Row size: " + rowSize);
        }
    }

    private void showOrHide(Element element, boolean show) {
        if (show) {
            element.getStyle().clearDisplay();
        } else {
            element.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    public static interface Style
    extends CssResource {
        public String evenItem();

        public String oddItem();

        public String selectedItem();
    }

    public static interface Resources
    extends ClientBundle {
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal)
        public ImageResource cellListSelectedBackground();

        @ClientBundle.Source(value={"CellList.css"})
        public Style cellListStyle();
    }
}

