/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.CellListImpl;
import com.google.gwt.user.cellview.client.CellTree;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.view.client.ListView;
import com.google.gwt.view.client.PagingListView;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.TreeViewModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CellTreeNodeView<T>
extends UIObject {
    private static final String LEAF_IMAGE = "<div style='position:absolute;display:none;'></div>";
    private boolean animate;
    private Element animationFrame;
    private Element childContainer;
    private List<CellTreeNodeView<?>> children;
    private Element contentContainer;
    private final int depth;
    private Element emptyMessageElem;
    private NodeListView<?> listView;
    private TreeViewModel.NodeInfo<?> nodeInfo;
    private boolean nodeInfoLoaded;
    private boolean open;
    private final CellTreeNodeView<?> parentNode;
    private final TreeViewModel.NodeInfo<T> parentNodeInfo;
    private AnchorElement showMoreElem;
    private final CellTree tree;
    private T value;

    private static Element getCellParent(Element nodeElem) {
        return (Element)CellTreeNodeView.getSelectionElement(nodeElem).getFirstChildElement().getChild(1).cast();
    }

    private static Element getImageElement(Element nodeElem) {
        return CellTreeNodeView.getSelectionElement(nodeElem).getFirstChildElement().getFirstChildElement();
    }

    private static Element getSelectionElement(Element nodeElem) {
        return nodeElem.getFirstChildElement();
    }

    private static void showOrHide(Element element, boolean show) {
        if (show) {
            element.getStyle().clearDisplay();
        } else {
            element.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    CellTreeNodeView(CellTree tree, CellTreeNodeView<?> parent, TreeViewModel.NodeInfo<T> parentNodeInfo, Element elem, T value) {
        this.tree = tree;
        this.parentNode = parent;
        this.parentNodeInfo = parentNodeInfo;
        this.depth = this.parentNode == null ? 0 : this.parentNode.depth + 1;
        this.value = value;
        this.setElement(elem);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public CellTreeNodeView<?> getChildNode(int childIndex) {
        return this.children.get(childIndex);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void select() {
        SelectionModel<T> selectionModel = this.parentNodeInfo.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.setSelected(this.value, true);
        }
    }

    public void setOpen(boolean open) {
        if (this.open == open) {
            return;
        }
        this.animate = true;
        this.open = open;
        if (open) {
            if (!this.nodeInfoLoaded) {
                this.nodeInfoLoaded = true;
                this.nodeInfo = this.tree.getTreeViewModel().getNodeInfo(this.value);
            }
            if (this.nodeInfo != null) {
                this.ensureChildContainer();
                CellTreeNodeView.showOrHide(this.showMoreElem, false);
                CellTreeNodeView.showOrHide(this.emptyMessageElem, false);
                if (!this.isRootNode()) {
                    CellTreeNodeView.setStyleName(this.getCellParent(), this.tree.getStyle().openItem(), true);
                }
                this.ensureAnimationFrame().getStyle().setProperty("display", "");
                this.updateImage(true);
                this.onOpen(this.nodeInfo);
            }
        } else {
            if (!this.isRootNode()) {
                CellTreeNodeView.setStyleName(this.getCellParent(), this.tree.getStyle().openItem(), false);
            }
            this.cleanup();
            this.tree.maybeAnimateTreeNode(this);
            this.updateImage(false);
        }
    }

    protected void cleanup() {
        if (this.listView != null) {
            this.listView.cleanup();
            this.nodeInfo.unsetView();
            this.listView = null;
        }
        if (this.children != null) {
            for (CellTreeNodeView<?> child : this.children) {
                child.cleanup();
            }
            this.children = null;
        }
    }

    protected boolean consumeAnimate() {
        boolean hasAnimate = this.animate;
        this.animate = false;
        return hasAnimate;
    }

    protected <C> CellTreeNodeView<C> createTreeNodeView(TreeViewModel.NodeInfo<C> nodeInfo, Element childElem, C childValue, Object viewData) {
        return new CellTreeNodeView<C>(this.tree, this, nodeInfo, childElem, childValue);
    }

    protected boolean fireEventToCell(NativeEvent event) {
        if (this.parentNodeInfo != null) {
            Element cellParent = this.getCellParent();
            Cell<T> parentCell = this.parentNodeInfo.getCell();
            parentCell.onBrowserEvent(cellParent, this.value, null, event, this.parentNodeInfo.getValueUpdater());
            return parentCell.consumesEvents();
        }
        return false;
    }

    protected Element getCellParent() {
        return CellTreeNodeView.getCellParent(this.getElement());
    }

    protected Element getImageElement() {
        return CellTreeNodeView.getImageElement(this.getElement());
    }

    protected Object getValueKey() {
        return this.parentNodeInfo.getProvidesKey().getKey(this.value);
    }

    protected <C> void onOpen(TreeViewModel.NodeInfo<C> nodeInfo) {
        NodeListView<C> view = new NodeListView<C>(nodeInfo, this, this.tree.getDefaultNodeSize());
        this.listView = view;
        view.setSelectionModel(nodeInfo.getSelectionModel());
        nodeInfo.setView(view);
    }

    Element ensureAnimationFrame() {
        if (this.animationFrame == null) {
            this.animationFrame = Document.get().createDivElement();
            this.animationFrame.getStyle().setPosition(Style.Position.RELATIVE);
            this.animationFrame.getStyle().setOverflow(Style.Overflow.HIDDEN);
            this.animationFrame.setId("animFrame");
            this.getElement().appendChild(this.animationFrame);
        }
        return this.animationFrame;
    }

    Element ensureChildContainer() {
        if (this.childContainer == null) {
            this.childContainer = Document.get().createDivElement();
            this.ensureContentContainer().insertFirst(this.childContainer);
        }
        return this.childContainer;
    }

    Element ensureContentContainer() {
        if (this.contentContainer == null) {
            this.contentContainer = Document.get().createDivElement();
            this.ensureAnimationFrame().appendChild(this.contentContainer);
            this.emptyMessageElem = Document.get().createDivElement();
            this.emptyMessageElem.setInnerHTML("no data");
            CellTreeNodeView.setStyleName(this.emptyMessageElem, this.tree.getStyle().emptyMessage(), true);
            CellTreeNodeView.showOrHide(this.emptyMessageElem, false);
            this.contentContainer.appendChild(this.emptyMessageElem);
            this.showMoreElem = Document.get().createAnchorElement();
            this.showMoreElem.setHref("javascript:;");
            this.showMoreElem.setInnerText("Show more");
            CellTreeNodeView.setStyleName(this.showMoreElem, this.tree.getStyle().showMoreButton(), true);
            CellTreeNodeView.showOrHide(this.showMoreElem, false);
            this.contentContainer.appendChild(this.showMoreElem);
        }
        return this.contentContainer;
    }

    Element getShowMoreElement() {
        return this.showMoreElem;
    }

    boolean isRootNode() {
        return this.parentNode == null;
    }

    void showFewer() {
        int defaultPageSize = this.listView.getDefaultPageSize();
        int maxSize = Math.max(defaultPageSize, ((NodeListView)this.listView).impl.getPageSize() - defaultPageSize);
        ((NodeListView)this.listView).impl.setPageSize(maxSize);
    }

    void showMore() {
        ((NodeListView)this.listView).impl.setPageSize(((NodeListView)this.listView).impl.getPageSize() + this.listView.getDefaultPageSize());
    }

    private void updateImage(boolean isLoading) {
        if (this.isRootNode()) {
            return;
        }
        boolean isTopLevel = this.parentNode.isRootNode();
        String html = this.tree.getClosedImageHtml(isTopLevel);
        if (this.open) {
            String string = html = isLoading ? this.tree.getLoadingImageHtml() : this.tree.getOpenImageHtml(isTopLevel);
        }
        if (this.nodeInfoLoaded && this.nodeInfo == null) {
            html = LEAF_IMAGE;
        }
        DivElement tmp = Document.get().createDivElement();
        tmp.setInnerHTML(html);
        Element imageElem = tmp.getFirstChildElement();
        Element oldImg = this.getImageElement();
        oldImg.getParentElement().replaceChild(imageElem, oldImg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeListView<C>
    implements PagingListView<C> {
        private final int defaultPageSize;
        private final CellListImpl<C> impl;
        private CellTreeNodeView<?> nodeView;
        private Map<Object, CellTreeNodeView<?>> savedViews;

        public NodeListView(final TreeViewModel.NodeInfo<C> nodeInfo, final CellTreeNodeView<?> nodeView, int pageSize) {
            this.defaultPageSize = pageSize;
            this.nodeView = nodeView;
            final Cell<C> cell = nodeInfo.getCell();
            this.impl = new CellListImpl<C>(this, pageSize, nodeView.ensureChildContainer()){

                @Override
                public void setData(List<C> values, int start) {
                    nodeView.updateImage(false);
                    if (nodeView.children == null) {
                        nodeView.children = new ArrayList();
                    }
                    int len = values.size();
                    int end = start + len;
                    int childCount = nodeView.getChildCount();
                    HashMap openNodes = new HashMap();
                    for (int i = start; i < end && i < childCount; ++i) {
                        CellTreeNodeView<?> child = nodeView.getChildNode(i);
                        if (!child.isOpen()) continue;
                        openNodes.put(child.getValueKey(), child);
                    }
                    if (nodeView.tree.isAnimationEnabled()) {
                        nodeView.ensureAnimationFrame().getStyle().setDisplay(Style.Display.NONE);
                    }
                    ProvidesKey providesKey = nodeInfo.getProvidesKey();
                    NodeListView.this.savedViews = new HashMap();
                    for (Object childValue : values) {
                        Object key = providesKey.getKey(childValue);
                        CellTreeNodeView savedView = (CellTreeNodeView)openNodes.remove(key);
                        if (savedView == null) continue;
                        savedView.ensureAnimationFrame().removeFromParent();
                        NodeListView.this.savedViews.put(key, savedView);
                    }
                    super.setData(values, start);
                    Element childElem = nodeView.ensureChildContainer().getFirstChildElement();
                    for (int i = start; i < end; ++i) {
                        Object childValue = values.get(i - start);
                        CellTreeNodeView child = nodeView.createTreeNodeView(nodeInfo, childElem, childValue, null);
                        CellTreeNodeView savedChild = (CellTreeNodeView)NodeListView.this.savedViews.remove(providesKey.getKey(childValue));
                        if (savedChild != null) {
                            child.animationFrame = savedChild.animationFrame;
                            child.contentContainer = savedChild.contentContainer;
                            child.childContainer = savedChild.childContainer;
                            child.children = savedChild.children;
                            child.emptyMessageElem = savedChild.emptyMessageElem;
                            child.nodeInfo = savedChild.nodeInfo;
                            child.nodeInfoLoaded = savedChild.nodeInfoLoaded;
                            child.open = savedChild.open;
                            child.showMoreElem = savedChild.showMoreElem;
                            ((NodeListView)savedChild.listView).setNodeView(child);
                            child.getElement().appendChild(savedChild.ensureAnimationFrame());
                        }
                        if (childCount > i) {
                            if (savedChild == null) {
                                ((CellTreeNodeView)nodeView.children.get(i)).cleanup();
                            }
                            nodeView.children.set(i, child);
                        } else {
                            nodeView.children.add(child);
                        }
                        childElem = childElem.getNextSiblingElement();
                    }
                    NodeListView.this.savedViews = null;
                    if (nodeView.tree.isAnimationEnabled()) {
                        nodeView.tree.maybeAnimateTreeNode(nodeView);
                    }
                }

                @Override
                protected boolean dependsOnSelection() {
                    return cell.dependsOnSelection();
                }

                @Override
                protected void emitHtml(StringBuilder sb, List<C> values, int start, SelectionModel<? super C> selectionModel) {
                    CellTree.Style style = nodeView.tree.getStyle();
                    String selectedStyle = style.selectedItem();
                    String itemStyle = style.item();
                    String itemImageValueStyle = style.itemImageValue();
                    String itemValueStyle = style.itemValue();
                    String openStyle = style.openItem();
                    String topStyle = style.topItem();
                    String topImageValueStyle = style.topItemImageValue();
                    boolean isRootNode = nodeView.isRootNode();
                    String openImage = nodeView.tree.getOpenImageHtml(isRootNode);
                    String closedImage = nodeView.tree.getClosedImageHtml(isRootNode);
                    int imageWidth = nodeView.tree.getImageWidth();
                    int paddingLeft = imageWidth * nodeView.depth;
                    ProvidesKey providesKey = nodeInfo.getProvidesKey();
                    TreeViewModel model = nodeView.tree.getTreeViewModel();
                    for (Object value : values) {
                        Object key = providesKey.getKey(value);
                        boolean isOpen = NodeListView.this.savedViews.containsKey(key);
                        sb.append("<div>");
                        sb.append("<div style='padding-left:");
                        sb.append(paddingLeft);
                        sb.append("px;' class='").append(itemStyle);
                        if (isOpen) {
                            sb.append(" ").append(openStyle);
                        }
                        if (isRootNode) {
                            sb.append(" ").append(topStyle);
                        }
                        if (selectionModel != null && selectionModel.isSelected(value)) {
                            sb.append(" ").append(selectedStyle);
                        }
                        sb.append("'>");
                        sb.append("<div onclick='' style='position:relative;padding-left:");
                        sb.append(imageWidth);
                        sb.append("px;' class='").append(itemImageValueStyle);
                        if (isRootNode) {
                            sb.append(" ").append(topImageValueStyle);
                        }
                        sb.append("'>");
                        if (isOpen) {
                            sb.append(openImage);
                        } else if (model.isLeaf(value)) {
                            sb.append(CellTreeNodeView.LEAF_IMAGE);
                        } else {
                            sb.append(closedImage);
                        }
                        sb.append("<div class='").append(itemValueStyle).append("'>");
                        cell.render(value, null, sb);
                        sb.append("</div></div></div></div>");
                    }
                }

                @Override
                protected void removeLastItem() {
                    CellTreeNodeView child = (CellTreeNodeView)nodeView.children.remove(nodeView.children.size() - 1);
                    child.cleanup();
                    super.removeLastItem();
                }

                @Override
                protected void setSelected(Element elem, boolean selected) {
                    CellTreeNodeView.setStyleName(CellTreeNodeView.getSelectionElement(elem), nodeView.tree.getStyle().selectedItem(), selected);
                }
            };
            this.impl.setPager(new PagingListView.Pager<C>(){

                @Override
                public void onRangeOrSizeChanged(PagingListView<C> listView) {
                    int dataSize = NodeListView.this.impl.getDataSize();
                    CellTreeNodeView.showOrHide(nodeView.showMoreElem, dataSize > NodeListView.this.impl.getPageSize());
                    if (dataSize == 0) {
                        CellTreeNodeView.showOrHide(nodeView.emptyMessageElem, true);
                        nodeView.updateImage(false);
                    } else {
                        CellTreeNodeView.showOrHide(nodeView.emptyMessageElem, false);
                    }
                }
            });
        }

        public void cleanup() {
            this.impl.setSelectionModel(null, false);
        }

        @Override
        public int getDataSize() {
            return this.impl.getDataSize();
        }

        public int getDefaultPageSize() {
            return this.defaultPageSize;
        }

        @Override
        public int getPageSize() {
            return this.impl.getPageSize();
        }

        @Override
        public int getPageStart() {
            return this.impl.getPageStart();
        }

        @Override
        public Range getRange() {
            return this.impl.getRange();
        }

        @Override
        public boolean isDataSizeExact() {
            return this.impl.dataSizeIsExact();
        }

        @Override
        public void setData(int start, int length, List<C> values) {
            this.impl.setData(values, start);
        }

        @Override
        public void setDataSize(int size, boolean isExact) {
            this.impl.setDataSize(size, isExact);
        }

        @Override
        public void setDelegate(ListView.Delegate<C> delegate) {
            this.impl.setDelegate(delegate);
        }

        @Override
        public void setPager(PagingListView.Pager<C> pager) {
            this.impl.setPager(pager);
        }

        @Override
        public void setPageSize(int pageSize) {
            this.impl.setPageSize(pageSize);
        }

        @Override
        public void setPageStart(int pageStart) {
            this.impl.setPageStart(pageStart);
        }

        @Override
        public void setSelectionModel(SelectionModel<? super C> selectionModel) {
            this.impl.setSelectionModel(selectionModel, true);
        }

        private void setNodeView(CellTreeNodeView<?> nodeView) {
            ((CellTreeNodeView)this.nodeView).listView = null;
            this.nodeView = nodeView;
            ((CellTreeNodeView)nodeView).listView = this;
        }
    }
}

