/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.IconCellDecorator;
import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableColElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractHasData;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.HasDataPresenter;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.LoadingStateChangeEvent;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.cellview.client.SafeHtmlHeader;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellTable<T>
extends AbstractHasData<T> {
    private String tableId = "t_" + DOM.createUniqueId();
    private static final int DEFAULT_PAGESIZE = 15;
    private static Resources DEFAULT_RESOURCES;
    private static Impl TABLE_IMPL;
    private static Template template;
    final TableColElement colgroup;
    private boolean cellIsEditing;
    private final List<Column<T, ?>> columns = new ArrayList();
    private final Map<Column<T, ?>, String> columnWidths = new HashMap();
    private boolean dependsOnSelection;
    private final SimplePanel emptyTableWidgetContainer = new SimplePanel();
    private final List<Header<?>> footers = new ArrayList();
    private boolean handlesSelection;
    private final List<Header<?>> headers = new ArrayList();
    private TableRowElement hoveringRow;
    private boolean isInteractive;
    private int keyboardSelectedColumn = 0;
    private final SimplePanel loadingIndicatorContainer = new SimplePanel();
    private final DeckPanel messagesPanel = new DeckPanel();
    private final Resources resources;
    private RowStyles<T> rowStyles;
    private IconCellDecorator<SafeHtml> sortAscDecorator;
    private IconCellDecorator<SafeHtml> sortDescDecorator;
    private final ColumnSortList sortList;
    private final Style style;
    private final TableElement table;
    private final TableSectionElement tbody;
    private final TableSectionElement tbodyLoading;
    private final TableCellElement tbodyLoadingCell;
    private final TableSectionElement tfoot;
    private final TableSectionElement thead;
    private boolean updatingSortList;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    private static Widget createDefaultLoadingIndicator(Resources resources) {
        ImageResource loadingImg = resources.cellTableLoading();
        return loadingImg == null ? null : new Image(resources.cellTableLoading());
    }

    public CellTable() {
        this(15);
    }

    public CellTable(int pageSize) {
        this(pageSize, CellTable.getDefaultResources(), null);
    }

    public CellTable(ProvidesKey<T> keyProvider) {
        this(15, CellTable.getDefaultResources(), keyProvider);
    }

    public CellTable(int pageSize, Resources resources) {
        this(pageSize, resources, null);
    }

    public CellTable(int pageSize, ProvidesKey<T> keyProvider) {
        this(pageSize, CellTable.getDefaultResources(), keyProvider);
    }

    public CellTable(int pageSize, Resources resources, ProvidesKey<T> keyProvider) {
        this(pageSize, resources, keyProvider, CellTable.createDefaultLoadingIndicator(resources));
    }

    public CellTable(int pageSize, Resources resources, ProvidesKey<T> keyProvider, Widget loadingIndicator) {
        super(Document.get().createTableElement(), pageSize, keyProvider);
        if (TABLE_IMPL == null) {
            TABLE_IMPL = (Impl)GWT.create(Impl.class);
        }
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        this.resources = resources;
        this.style = resources.cellTableStyle();
        this.style.ensureInjected();
        this.sortList = new ColumnSortList(new ColumnSortList.Delegate(){

            public void onModification() {
                if (!CellTable.this.updatingSortList) {
                    CellTable.this.createHeaders(false);
                }
            }
        });
        this.table = (TableElement)this.getElement().cast();
        this.table.setCellSpacing(0);
        this.colgroup = Document.get().createColGroupElement();
        this.table.appendChild(this.colgroup);
        this.thead = this.table.createTHead();
        if (this.table.getTBodies().getLength() > 0) {
            this.tbody = this.table.getTBodies().getItem(0);
        } else {
            this.tbody = Document.get().createTBodyElement();
            this.table.appendChild(this.tbody);
        }
        this.tbodyLoading = Document.get().createTBodyElement();
        this.table.appendChild(this.tbodyLoading);
        this.tfoot = this.table.createTFoot();
        this.setStyleName(this.style.cellTableWidget());
        this.tbodyLoadingCell = Document.get().createTDElement();
        TableRowElement tr = Document.get().createTRElement();
        this.tbodyLoading.appendChild(tr);
        tr.appendChild(this.tbodyLoadingCell);
        this.tbodyLoadingCell.setAlign("center");
        this.tbodyLoadingCell.appendChild(this.messagesPanel.getElement());
        this.adopt(this.messagesPanel);
        this.messagesPanel.add(this.emptyTableWidgetContainer);
        this.messagesPanel.add(this.loadingIndicatorContainer);
        this.loadingIndicatorContainer.setStyleName(this.style.cellTableLoading());
        this.setLoadingIndicator(loadingIndicator);
        HashSet<String> eventTypes = new HashSet<String>();
        eventTypes.add("mouseover");
        eventTypes.add("mouseout");
        CellBasedWidgetImpl.get().sinkEvents(this, eventTypes);
    }

    public void addColumn(Column<T, ?> col) {
        this.insertColumn(this.getColumnCount(), col);
    }

    public void addColumn(Column<T, ?> col, Header<?> header) {
        this.insertColumn(this.getColumnCount(), col, header);
    }

    public void addColumn(Column<T, ?> col, Header<?> header, Header<?> footer) {
        this.insertColumn(this.getColumnCount(), col, header, footer);
    }

    public void addColumn(Column<T, ?> col, String headerString) {
        this.insertColumn(this.getColumnCount(), col, headerString);
    }

    public void addColumn(Column<T, ?> col, SafeHtml headerHtml) {
        this.insertColumn(this.getColumnCount(), col, headerHtml);
    }

    public void addColumn(Column<T, ?> col, String headerString, String footerString) {
        this.insertColumn(this.getColumnCount(), col, headerString, footerString);
    }

    public void addColumn(Column<T, ?> col, SafeHtml headerHtml, SafeHtml footerHtml) {
        this.insertColumn(this.getColumnCount(), col, headerHtml, footerHtml);
    }

    public HandlerRegistration addColumnSortHandler(ColumnSortEvent.Handler handler) {
        return this.addHandler(handler, ColumnSortEvent.getType());
    }

    public void addColumnStyleName(int index, String styleName) {
        this.ensureTableColElement(index).addClassName(styleName);
    }

    public void clearColumnWidth(Column<T, ?> column) {
        this.columnWidths.remove(column);
        this.refreshColumnWidths();
    }

    public int getBodyHeight() {
        int height = this.getClientHeight(this.tbody);
        return height;
    }

    public Column<T, ?> getColumn(int col) {
        this.checkColumnBounds(col);
        return this.columns.get(col);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnIndex(Column<T, ?> column) {
        return this.columns.indexOf(column);
    }

    public ColumnSortList getColumnSortList() {
        return this.sortList;
    }

    public Widget getEmptyTableWidget() {
        return this.emptyTableWidgetContainer.getWidget();
    }

    public int getHeaderHeight() {
        int height = this.getClientHeight(this.thead);
        return height;
    }

    public Widget getLoadingIndicator() {
        return this.loadingIndicatorContainer.getWidget();
    }

    public TableRowElement getRowElement(int row) {
        this.getPresenter().flush();
        this.checkRowBounds(row);
        NodeList<TableRowElement> rows = this.tbody.getRows();
        return rows.getLength() > row ? rows.getItem(row) : null;
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col) {
        this.insertColumn(beforeIndex, col, (Header)null, (Header)null);
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, Header<?> header) {
        this.insertColumn(beforeIndex, col, header, null);
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, Header<?> header, Header<?> footer) {
        Set<String> footerEvents;
        Set<String> headerEvents;
        if (beforeIndex != this.getColumnCount()) {
            this.checkColumnBounds(beforeIndex);
        }
        this.headers.add(beforeIndex, header);
        this.footers.add(beforeIndex, footer);
        this.columns.add(beforeIndex, col);
        boolean wasinteractive = this.isInteractive;
        this.updateDependsOnSelection();
        if (!wasinteractive && this.isInteractive) {
            this.keyboardSelectedColumn = beforeIndex;
        }
        HashSet<String> consumedEvents = new HashSet<String>();
        Set<String> cellEvents = col.getCell().getConsumedEvents();
        if (cellEvents != null) {
            consumedEvents.addAll(cellEvents);
        }
        if (header != null && (headerEvents = header.getCell().getConsumedEvents()) != null) {
            consumedEvents.addAll(headerEvents);
        }
        if (footer != null && (footerEvents = footer.getCell().getConsumedEvents()) != null) {
            consumedEvents.addAll(footerEvents);
        }
        CellBasedWidgetImpl.get().sinkEvents(this, consumedEvents);
        this.redraw();
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, String headerString) {
        this.insertColumn(beforeIndex, col, new TextHeader(headerString), null);
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, SafeHtml headerHtml) {
        this.insertColumn(beforeIndex, col, new SafeHtmlHeader(headerHtml), null);
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, String headerString, String footerString) {
        this.insertColumn(beforeIndex, col, new TextHeader(headerString), new TextHeader(footerString));
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, SafeHtml headerHtml, SafeHtml footerHtml) {
        this.insertColumn(beforeIndex, col, new SafeHtmlHeader(headerHtml), new SafeHtmlHeader(footerHtml));
    }

    @Override
    public void redraw() {
        this.refreshColumnWidths();
        super.redraw();
    }

    public void redrawFooters() {
        this.createHeaders(true);
    }

    public void redrawHeaders() {
        this.createHeaders(false);
    }

    public void removeColumn(Column<T, ?> col) {
        int index = this.columns.indexOf(col);
        if (index < 0) {
            throw new IllegalArgumentException("The specified column is not part of this table.");
        }
        this.removeColumn(index);
    }

    public void removeColumn(int index) {
        if (index < 0 || index >= this.columns.size()) {
            throw new IndexOutOfBoundsException("The specified column index is out of bounds.");
        }
        this.columns.remove(index);
        this.headers.remove(index);
        this.footers.remove(index);
        this.updateDependsOnSelection();
        if (index <= this.keyboardSelectedColumn) {
            this.keyboardSelectedColumn = 0;
            if (this.isInteractive) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    if (!this.isColumnInteractive(this.columns.get(i))) continue;
                    this.keyboardSelectedColumn = i;
                    break;
                }
            }
        }
        this.redraw();
    }

    public void removeColumnStyleName(int index, String styleName) {
        if (index >= this.colgroup.getChildCount()) {
            return;
        }
        this.ensureTableColElement(index).removeClassName(styleName);
    }

    public void setColumnWidth(Column<T, ?> column, String width) {
        this.columnWidths.put(column, width);
        this.refreshColumnWidths();
    }

    public void setColumnWidth(Column<T, ?> column, double width, Style.Unit unit) {
        this.setColumnWidth(column, width + unit.getType());
    }

    public void setEmptyTableWidget(Widget widget) {
        this.emptyTableWidgetContainer.setWidget(widget);
    }

    public void setLoadingIndicator(Widget widget) {
        this.loadingIndicatorContainer.setWidget(widget);
    }

    public void setRowStyles(RowStyles<T> rowStyles) {
        this.rowStyles = rowStyles;
    }

    public void setTableLayoutFixed(boolean isFixed) {
        if (isFixed) {
            this.table.getStyle().setTableLayout(Style.TableLayout.FIXED);
        } else {
            this.table.getStyle().clearTableLayout();
        }
    }

    public final void setWidth(String width, boolean isFixedLayout) {
        super.setWidth(width);
        this.setTableLayoutFixed(isFixedLayout);
    }

    @Override
    protected Element convertToElements(SafeHtml html) {
        return TABLE_IMPL.convertToSectionElement(this, "tbody", html);
    }

    @Override
    protected boolean dependsOnSelection() {
        return this.dependsOnSelection;
    }

    @Deprecated
    protected void doSelection(Event event, T value, int row, int column) {
    }

    @Override
    protected Element getChildContainer() {
        return this.tbody;
    }

    @Override
    protected Element getKeyboardSelectedElement() {
        int rowIndex = this.getKeyboardSelectedRow();
        NodeList<TableRowElement> rows = this.tbody.getRows();
        if (rowIndex >= 0 && rowIndex < rows.getLength() && this.columns.size() > 0) {
            TableRowElement tr = rows.getItem(rowIndex);
            TableCellElement td = tr.getCells().getItem(this.keyboardSelectedColumn);
            return this.getCellParent(td);
        }
        return null;
    }

    @Override
    protected boolean isKeyboardNavigationSuppressed() {
        return this.cellIsEditing;
    }

    @Override
    protected void onBlur() {
        Element elem = this.getKeyboardSelectedElement();
        if (elem != null) {
            TableCellElement td = (TableCellElement)elem.getParentElement().cast();
            TableRowElement tr = (TableRowElement)td.getParentElement().cast();
            td.removeClassName(this.style.cellTableKeyboardSelectedCell());
            td.removeAttribute("aria-selected");
            this.setRowStyleName(tr, this.style.cellTableKeyboardSelectedRow(), this.style.cellTableKeyboardSelectedRowCell(), false);
        }
    }

    @Override
    protected void onBrowserEvent2(Event event) {
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is(eventTarget)) {
            return;
        }
        Element target = (Element)event.getEventTarget().cast();
        String eventType = event.getType();
        if ("keydown".equals(eventType) && !this.isKeyboardNavigationSuppressed() && HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED != this.getKeyboardSelectionPolicy() && this.handleKey(event)) {
            return;
        }
        TableCellElement tableCell = this.findNearestParentCell(target);
        if (tableCell == null) {
            return;
        }
        Element trElem = tableCell.getParentElement();
        if (trElem == null) {
            return;
        }
        TableRowElement tr = TableRowElement.as(trElem);
        Element sectionElem = tr.getParentElement();
        if (sectionElem == null) {
            return;
        }
        TableSectionElement section = TableSectionElement.as(sectionElem);
        boolean isClick = "click".equals(eventType);
        int col = tableCell.getCellIndex();
        if (section == this.thead) {
            Header<?> header = this.headers.get(col);
            if (header != null) {
                if (this.cellConsumesEventType(header.getCell(), eventType)) {
                    Cell.Context context = new Cell.Context(0, col, header.getKey());
                    header.onBrowserEvent(context, tableCell, event);
                }
                Column<T, ?> column = this.columns.get(col);
                if (isClick && column.isSortable()) {
                    this.updatingSortList = true;
                    this.sortList.push(column);
                    this.updatingSortList = false;
                    ColumnSortEvent.fire(this, this.sortList);
                }
            }
        } else if (section == this.tfoot) {
            Header<?> footer = this.footers.get(col);
            if (footer != null && this.cellConsumesEventType(footer.getCell(), eventType)) {
                Cell.Context context = new Cell.Context(0, col, footer.getKey());
                footer.onBrowserEvent(context, tableCell, event);
            }
        } else if (section == this.tbody) {
            int row = tr.getSectionRowIndex();
            if ("mouseover".equals(eventType)) {
                if (this.hoveringRow != null && this.tbody.isOrHasChild(this.hoveringRow)) {
                    this.setRowStyleName(this.hoveringRow, this.style.cellTableHoveredRow(), this.style.cellTableHoveredRowCell(), false);
                }
                this.hoveringRow = tr;
                this.setRowStyleName(this.hoveringRow, this.style.cellTableHoveredRow(), this.style.cellTableHoveredRowCell(), true);
            } else if ("mouseout".equals(eventType) && this.hoveringRow != null) {
                this.setRowStyleName(this.hoveringRow, this.style.cellTableHoveredRow(), this.style.cellTableHoveredRowCell(), false);
                this.hoveringRow = null;
            } else if (isClick && (this.getPresenter().getKeyboardSelectedRowInView() != row || this.keyboardSelectedColumn != col)) {
                boolean isFocusable = CellBasedWidgetImpl.get().isFocusable(target);
                this.isFocused = this.isFocused || isFocusable;
                this.keyboardSelectedColumn = col;
                this.getPresenter().setKeyboardSelectedRow(row, !isFocusable, true);
            }
            if (!this.isRowWithinBounds(row)) {
                return;
            }
            boolean isSelectionHandled = this.handlesSelection || HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.getKeyboardSelectionPolicy();
            Object value = this.getVisibleItem(row);
            Cell.Context context = new Cell.Context(row + this.getPageStart(), col, this.getValueKey(value));
            CellPreviewEvent previewEvent = CellPreviewEvent.fire(this, event, this, context, value, this.cellIsEditing, isSelectionHandled);
            if (isClick && !this.cellIsEditing && !isSelectionHandled) {
                this.doSelection(event, value, row, col);
            }
            if (!previewEvent.isCanceled()) {
                this.fireEventToCell(event, eventType, tableCell, value, context, this.columns.get(col));
            }
        }
    }

    @Override
    protected void onFocus() {
        Element elem = this.getKeyboardSelectedElement();
        if (elem != null) {
            TableCellElement td = (TableCellElement)elem.getParentElement().cast();
            TableRowElement tr = (TableRowElement)td.getParentElement().cast();
            td.addClassName(this.style.cellTableKeyboardSelectedCell());
            td.setAttribute("aria-selected", "true");
            this.setRowStyleName(tr, this.style.cellTableKeyboardSelectedRow(), this.style.cellTableKeyboardSelectedRowCell(), true);
        }
    }

    @Override
    protected void onLoadingStateChanged(LoadingStateChangeEvent.LoadingState state) {
        SimplePanel message = null;
        if (state == LoadingStateChangeEvent.LoadingState.LOADING) {
            message = this.loadingIndicatorContainer;
        } else if (state == LoadingStateChangeEvent.LoadingState.LOADED && this.getPresenter().isEmpty()) {
            message = this.emptyTableWidgetContainer;
        }
        if (message != null) {
            this.messagesPanel.showWidget(this.messagesPanel.getWidgetIndex(message));
        }
        this.tbodyLoadingCell.setColSpan(Math.max(1, this.columns.size()));
        this.showOrHide(this.getChildContainer(), message == null);
        this.showOrHide(this.tbodyLoading, message != null);
        super.onLoadingStateChanged(state);
    }

    @Override
    protected void renderRowValues(SafeHtmlBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
        this.createHeadersAndFooters();
        int keyboardSelectedRow = this.getKeyboardSelectedRow() + this.getPageStart();
        String evenRowStyle = this.style.cellTableEvenRow();
        String oddRowStyle = this.style.cellTableOddRow();
        String cellStyle = this.style.cellTableCell();
        String evenCellStyle = " " + this.style.cellTableEvenRowCell();
        String oddCellStyle = " " + this.style.cellTableOddRowCell();
        String firstColumnStyle = " " + this.style.cellTableFirstColumn();
        String lastColumnStyle = " " + this.style.cellTableLastColumn();
        String selectedRowStyle = " " + this.style.cellTableSelectedRow();
        String selectedCellStyle = " " + this.style.cellTableSelectedRowCell();
        String keyboardRowStyle = " " + this.style.cellTableKeyboardSelectedRow();
        String keyboardRowCellStyle = " " + this.style.cellTableKeyboardSelectedRowCell();
        String keyboardCellStyle = " " + this.style.cellTableKeyboardSelectedCell();
        int columnCount = this.columns.size();
        int length = values.size();
        int end = start + length;
        for (int i = start; i < end; ++i) {
            String extraRowStyles;
            String trClasses;
            T value = values.get(i - start);
            boolean isSelected = selectionModel == null || value == null ? false : selectionModel.isSelected(value);
            boolean isEven = i % 2 == 0;
            boolean isKeyboardSelected = i == keyboardSelectedRow && this.isFocused;
            String string = trClasses = isEven ? evenRowStyle : oddRowStyle;
            if (isSelected) {
                trClasses = trClasses + selectedRowStyle;
            }
            if (isKeyboardSelected) {
                trClasses = trClasses + keyboardRowStyle;
            }
            if (this.rowStyles != null && (extraRowStyles = this.rowStyles.getStyleNames(value, i)) != null) {
                trClasses = trClasses + " ";
                trClasses = trClasses + extraRowStyles;
            }
            SafeHtmlBuilder trBuilder = new SafeHtmlBuilder();
            int curColumn = 0;
            for (Column<T, ?> column : this.columns) {
                String tdClasses = cellStyle;
                tdClasses = tdClasses + (isEven ? evenCellStyle : oddCellStyle);
                if (curColumn == 0) {
                    tdClasses = tdClasses + firstColumnStyle;
                }
                if (isSelected) {
                    tdClasses = tdClasses + selectedCellStyle;
                }
                if (isKeyboardSelected) {
                    tdClasses = tdClasses + keyboardRowCellStyle;
                }
                if (curColumn == columnCount - 1) {
                    tdClasses = tdClasses + lastColumnStyle;
                }
                SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
                if (value != null) {
                    Cell.Context context = new Cell.Context(i, curColumn, this.getValueKey(value));
                    column.render(context, value, cellBuilder);
                }
                SafeHtml contents = SafeHtmlUtils.EMPTY_SAFE_HTML;
                if (i == keyboardSelectedRow && curColumn == this.keyboardSelectedColumn) {
                    char accessKey;
                    if (this.isFocused) {
                        tdClasses = tdClasses + keyboardCellStyle;
                    }
                    contents = (accessKey = this.getAccessKey()) != '\u0000' ? template.divFocusableWithKey(this.getTabIndex(), accessKey, cellBuilder.toSafeHtml()) : template.divFocusable(this.getTabIndex(), cellBuilder.toSafeHtml());
                } else {
                    contents = template.div(cellBuilder.toSafeHtml());
                }
                HasHorizontalAlignment.HorizontalAlignmentConstant hAlign = column.getHorizontalAlignment();
                HasVerticalAlignment.VerticalAlignmentConstant vAlign = column.getVerticalAlignment();
                String headerRef = this.tableId + "_h_" + curColumn;
                if (hAlign != null && vAlign != null) {
                    trBuilder.append(template.tdBothAlign(tdClasses, headerRef, hAlign.getTextAlignString(), vAlign.getVerticalAlignString(), contents));
                } else if (hAlign != null) {
                    trBuilder.append(template.tdHorizontalAlign(tdClasses, headerRef, hAlign.getTextAlignString(), contents));
                } else if (vAlign != null) {
                    trBuilder.append(template.tdVerticalAlign(tdClasses, headerRef, vAlign.getVerticalAlignString(), contents));
                } else {
                    trBuilder.append(template.td(tdClasses, headerRef, contents));
                }
                ++curColumn;
            }
            sb.append(template.tr(trClasses, trBuilder.toSafeHtml()));
        }
    }

    @Override
    protected void replaceAllChildren(List<T> values, SafeHtml html) {
        TABLE_IMPL.replaceAllRows(this, this.tbody, CellBasedWidgetImpl.get().processHtml(html));
    }

    @Override
    protected boolean resetFocusOnCell() {
        int row = this.getKeyboardSelectedRow();
        if (this.isRowWithinBounds(row) && this.columns.size() > 0) {
            Column<T, ?> column = this.columns.get(this.keyboardSelectedColumn);
            return this.resetFocusOnCellImpl(row, this.keyboardSelectedColumn, column);
        }
        return false;
    }

    @Override
    protected void setKeyboardSelected(int index, boolean selected, boolean stealFocus) {
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.getKeyboardSelectionPolicy() || !this.isRowWithinBounds(index) || this.columns.size() == 0) {
            return;
        }
        TableRowElement tr = this.getRowElement(index);
        String cellStyle = this.style.cellTableKeyboardSelectedCell();
        boolean updatedSelection = !selected || this.isFocused || stealFocus;
        this.setRowStyleName(tr, this.style.cellTableKeyboardSelectedRow(), this.style.cellTableKeyboardSelectedRowCell(), selected);
        NodeList<TableCellElement> cells = tr.getCells();
        for (int i = 0; i < cells.getLength(); ++i) {
            TableCellElement td = cells.getItem(i);
            CellTable.setStyleName(td, cellStyle, updatedSelection && selected && i == this.keyboardSelectedColumn);
            com.google.gwt.user.client.Element cellParent = (com.google.gwt.user.client.Element)this.getCellParent(td).cast();
            this.setFocusable(cellParent, selected && i == this.keyboardSelectedColumn);
        }
        if (selected && stealFocus && !this.cellIsEditing) {
            TableCellElement td = tr.getCells().getItem(this.keyboardSelectedColumn);
            final com.google.gwt.user.client.Element cellParent = (com.google.gwt.user.client.Element)this.getCellParent(td).cast();
            CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

                public void execute() {
                    cellParent.focus();
                }
            });
        }
    }

    @Override
    @Deprecated
    protected void setSelected(Element elem, boolean selected) {
        TableRowElement tr = (TableRowElement)elem.cast();
        this.setRowStyleName(tr, this.style.cellTableSelectedRow(), this.style.cellTableSelectedRowCell(), selected);
    }

    private void checkColumnBounds(int col) {
        if (col < 0 || col >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException("Column index is out of bounds: " + col);
        }
    }

    private void createHeaders(boolean isFooter) {
        List<Header<?>> theHeaders = isFooter ? this.footers : this.headers;
        TableSectionElement section = isFooter ? this.tfoot : this.thead;
        String className = isFooter ? this.style.cellTableFooter() : this.style.cellTableHeader();
        String firstColumnStyle = " " + (isFooter ? this.style.cellTableFirstColumnFooter() : this.style.cellTableFirstColumnHeader());
        String lastColumnStyle = " " + (isFooter ? this.style.cellTableLastColumnFooter() : this.style.cellTableLastColumnHeader());
        String sortableStyle = " " + this.style.cellTableSortableHeader();
        String sortedAscStyle = " " + this.style.cellTableSortedHeaderAscending();
        String sortedDescStyle = " " + this.style.cellTableSortedHeaderDescending();
        boolean hasHeader = false;
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.appendHtmlConstant("<tr role='row'>");
        int columnCount = this.columns.size();
        if (columnCount > 0) {
            int curColumn;
            ColumnSortList.ColumnSortInfo sortedInfo = this.sortList.size() == 0 ? null : this.sortList.get(0);
            Column<?, ?> sortedColumn = sortedInfo == null ? null : sortedInfo.getColumn();
            boolean isSortAscending = sortedInfo == null ? false : sortedInfo.isAscending();
            Header<?> prevHeader = theHeaders.get(0);
            Column<T, ?> column = this.columns.get(0);
            int prevColspan = 1;
            boolean isSortable = false;
            boolean isSorted = false;
            StringBuilder classesBuilder = new StringBuilder(className);
            classesBuilder.append(firstColumnStyle);
            if (!isFooter && column.isSortable()) {
                isSortable = true;
                isSorted = column == sortedColumn;
            }
            for (curColumn = 1; curColumn < columnCount; ++curColumn) {
                Header<?> header = theHeaders.get(curColumn);
                if (header != prevHeader) {
                    SafeHtml headerHtml = SafeHtmlUtils.EMPTY_SAFE_HTML;
                    if (prevHeader != null) {
                        hasHeader = true;
                        SafeHtmlBuilder headerBuilder = new SafeHtmlBuilder();
                        Cell.Context context = new Cell.Context(0, curColumn - prevColspan, prevHeader.getKey());
                        prevHeader.render(context, headerBuilder);
                        if (isSorted) {
                            SafeHtml unwrappedHeader = headerBuilder.toSafeHtml();
                            headerBuilder = new SafeHtmlBuilder();
                            this.getSortDecorator(isSortAscending).render(null, unwrappedHeader, headerBuilder);
                        }
                        headerHtml = headerBuilder.toSafeHtml();
                    }
                    if (isSortable) {
                        classesBuilder.append(sortableStyle);
                    }
                    if (isSorted) {
                        classesBuilder.append(isSortAscending ? sortedAscStyle : sortedDescStyle);
                    }
                    if (isFooter) {
                        sb.append(template.th(prevColspan, classesBuilder.toString(), headerHtml));
                    } else {
                        String headerId = this.tableId + "_h_" + (curColumn - prevColspan);
                        sb.append(template.th(headerId, prevColspan, classesBuilder.toString(), headerHtml));
                    }
                    prevHeader = header;
                    prevColspan = 1;
                    classesBuilder = new StringBuilder(className);
                    isSortable = false;
                    isSorted = false;
                } else {
                    ++prevColspan;
                }
                column = this.columns.get(curColumn);
                if (isFooter || !column.isSortable()) continue;
                isSortable = true;
                isSorted = column == sortedColumn;
            }
            SafeHtml headerHtml = SafeHtmlUtils.EMPTY_SAFE_HTML;
            if (prevHeader != null) {
                hasHeader = true;
                SafeHtmlBuilder headerBuilder = new SafeHtmlBuilder();
                Cell.Context context = new Cell.Context(0, curColumn - prevColspan, prevHeader.getKey());
                prevHeader.render(context, headerBuilder);
                if (isSorted) {
                    SafeHtml unwrappedHeader = headerBuilder.toSafeHtml();
                    headerBuilder = new SafeHtmlBuilder();
                    this.getSortDecorator(isSortAscending).render(null, unwrappedHeader, headerBuilder);
                }
                headerHtml = headerBuilder.toSafeHtml();
            }
            if (isSortable) {
                classesBuilder.append(sortableStyle);
            }
            if (isSorted) {
                classesBuilder.append(isSortAscending ? sortedAscStyle : sortedDescStyle);
            }
            classesBuilder.append(" ");
            classesBuilder.append(lastColumnStyle);
            if (isFooter) {
                sb.append(template.th(prevColspan, classesBuilder.toString(), headerHtml));
            } else {
                String headerId = this.tableId + "_h_" + (curColumn - 1);
                sb.append(template.th(headerId, prevColspan, classesBuilder.toString(), headerHtml));
            }
        }
        sb.appendHtmlConstant("</tr>");
        TABLE_IMPL.replaceAllRows(this, section, sb.toSafeHtml());
        CellTable.setVisible(section, hasHeader);
    }

    private void createHeadersAndFooters() {
        this.createHeaders(false);
        this.createHeaders(true);
    }

    private TableColElement ensureTableColElement(int index) {
        for (int i = this.colgroup.getChildCount(); i <= index; ++i) {
            this.colgroup.appendChild(Document.get().createColElement());
        }
        return (TableColElement)this.colgroup.getChild(index).cast();
    }

    private int findInteractiveColumn(int start, boolean reverse) {
        if (!this.isInteractive) {
            return 0;
        }
        if (reverse) {
            int i;
            for (i = start - 1; i >= 0; --i) {
                if (!this.isColumnInteractive(this.columns.get(i))) continue;
                return i;
            }
            for (i = this.columns.size() - 1; i >= start; --i) {
                if (!this.isColumnInteractive(this.columns.get(i))) continue;
                return i;
            }
        } else {
            int i;
            for (i = start + 1; i < this.columns.size(); ++i) {
                if (!this.isColumnInteractive(this.columns.get(i))) continue;
                return i;
            }
            for (i = 0; i <= start; ++i) {
                if (!this.isColumnInteractive(this.columns.get(i))) continue;
                return i;
            }
        }
        return 0;
    }

    private TableCellElement findNearestParentCell(Element elem) {
        while (elem != null && elem != this.table) {
            String tagName = elem.getTagName();
            if ("td".equalsIgnoreCase(tagName) || "th".equalsIgnoreCase(tagName)) {
                return (TableCellElement)elem.cast();
            }
            elem = elem.getParentElement();
        }
        return null;
    }

    private <C> void fireEventToCell(Event event, String eventType, TableCellElement tableCell, T value, Cell.Context context, Column<T, C> column) {
        Cell<C> cell = column.getCell();
        if (this.cellConsumesEventType(cell, eventType)) {
            C cellValue = column.getValue(value);
            Element parentElem = this.getCellParent(tableCell);
            boolean cellWasEditing = cell.isEditing(context, parentElem, cellValue);
            column.onBrowserEvent(context, parentElem, value, event);
            this.cellIsEditing = cell.isEditing(context, parentElem, cellValue);
            if (cellWasEditing && !this.cellIsEditing) {
                CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        CellTable.this.setFocus(true);
                    }
                });
            }
        }
    }

    private Element getCellParent(TableCellElement td) {
        return td.getFirstChildElement();
    }

    private native int getClientHeight(Element var1);

    private IconCellDecorator<SafeHtml> getSortDecorator(boolean ascending) {
        if (ascending) {
            if (this.sortAscDecorator == null) {
                this.sortAscDecorator = new IconCellDecorator<SafeHtml>(this.resources.cellTableSortAscending(), new SafeHtmlCell());
            }
            return this.sortAscDecorator;
        }
        if (this.sortDescDecorator == null) {
            this.sortDescDecorator = new IconCellDecorator<SafeHtml>(this.resources.cellTableSortDescending(), new SafeHtmlCell());
        }
        return this.sortDescDecorator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleKey(Event event) {
        HasDataPresenter presenter = this.getPresenter();
        int oldRow = this.getKeyboardSelectedRow();
        boolean isRtl = LocaleInfo.getCurrentLocale().isRTL();
        int keyCodeLineEnd = isRtl ? 37 : 39;
        int keyCodeLineStart = isRtl ? 39 : 37;
        int keyCode = event.getKeyCode();
        if (keyCode == keyCodeLineEnd) {
            int nextColumn = this.findInteractiveColumn(this.keyboardSelectedColumn, false);
            if (nextColumn <= this.keyboardSelectedColumn) {
                if (!presenter.hasKeyboardNext()) return false;
                this.keyboardSelectedColumn = nextColumn;
                presenter.keyboardNext();
                event.preventDefault();
                return true;
            }
            this.keyboardSelectedColumn = nextColumn;
            this.getPresenter().setKeyboardSelectedRow(oldRow, true, true);
            event.preventDefault();
            return true;
        }
        if (keyCode != keyCodeLineStart) return false;
        int prevColumn = this.findInteractiveColumn(this.keyboardSelectedColumn, true);
        if (prevColumn >= this.keyboardSelectedColumn) {
            if (!presenter.hasKeyboardPrev()) return false;
            this.keyboardSelectedColumn = prevColumn;
            presenter.keyboardPrev();
            event.preventDefault();
            return true;
        }
        this.keyboardSelectedColumn = prevColumn;
        this.getPresenter().setKeyboardSelectedRow(oldRow, true, true);
        event.preventDefault();
        return true;
    }

    private boolean isColumnInteractive(Column<T, ?> column) {
        Set<String> consumedEvents = column.getCell().getConsumedEvents();
        return consumedEvents != null && consumedEvents.size() > 0;
    }

    private void refreshColumnWidths() {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Column<T, ?> column = this.columns.get(i);
            String width = this.columnWidths.get(column);
            if (width == null) {
                this.ensureTableColElement(i).getStyle().clearWidth();
                continue;
            }
            this.ensureTableColElement(i).getStyle().setProperty("width", width);
        }
        int colCount = this.colgroup.getChildCount();
        for (int i = columnCount; i < colCount; ++i) {
            this.ensureTableColElement(i).getStyle().setWidth(0.0, Style.Unit.PX);
        }
    }

    private <C> boolean resetFocusOnCellImpl(int row, int col, Column<T, C> column) {
        Element parent = this.getKeyboardSelectedElement();
        Object value = this.getVisibleItem(row);
        Object key = this.getValueKey(value);
        C cellValue = column.getValue(value);
        Cell<C> cell = column.getCell();
        Cell.Context context = new Cell.Context(row + this.getPageStart(), col, key);
        return cell.resetFocus(context, parent, cellValue);
    }

    private void setRowStyleName(TableRowElement tr, String rowStyle, String cellStyle, boolean add) {
        CellTable.setStyleName(tr, rowStyle, add);
        NodeList<TableCellElement> cells = tr.getCells();
        for (int i = 0; i < cells.getLength(); ++i) {
            CellTable.setStyleName(cells.getItem(i), cellStyle, add);
        }
    }

    private void updateDependsOnSelection() {
        this.dependsOnSelection = false;
        this.handlesSelection = false;
        this.isInteractive = false;
        for (Column<T, ?> column : this.columns) {
            Cell<?> cell = column.getCell();
            if (cell.dependsOnSelection()) {
                this.dependsOnSelection = true;
            }
            if (cell.handlesSelection()) {
                this.handlesSelection = true;
            }
            if (!this.isColumnInteractive(column)) continue;
            this.isInteractive = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplTrident
    extends Impl {
        private ImplTrident() {
        }

        @Override
        protected void replaceAllRows(CellTable<?> table, TableSectionElement section, SafeHtml html) {
            Element child = section.getFirstChildElement();
            while (child != null) {
                Element next = child.getNextSiblingElement();
                section.removeChild(child);
                child = next;
            }
            TableSectionElement newSection = this.convertToSectionElement(table, section.getTagName(), html);
            child = newSection.getFirstChildElement();
            while (child != null) {
                Element next = child.getNextSiblingElement();
                section.appendChild(child);
                child = next;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Impl {
        private final com.google.gwt.user.client.Element tmpElem = (com.google.gwt.user.client.Element)Document.get().createDivElement().cast();

        private Impl() {
        }

        protected TableSectionElement convertToSectionElement(CellTable<?> table, String sectionTag, SafeHtml rowHtml) {
            DOM.setEventListener(this.tmpElem, table);
            sectionTag = sectionTag.toLowerCase();
            if ("tbody".equals(sectionTag)) {
                this.tmpElem.setInnerHTML(template.tbody(rowHtml).asString());
            } else if ("thead".equals(sectionTag)) {
                this.tmpElem.setInnerHTML(template.thead(rowHtml).asString());
            } else if ("tfoot".equals(sectionTag)) {
                this.tmpElem.setInnerHTML(template.tfoot(rowHtml).asString());
            } else {
                throw new IllegalArgumentException("Invalid table section tag: " + sectionTag);
            }
            TableElement tableElem = (TableElement)this.tmpElem.getFirstChildElement().cast();
            DOM.setEventListener(this.tmpElem, null);
            if ("tbody".equals(sectionTag)) {
                return tableElem.getTBodies().getItem(0);
            }
            if ("thead".equals(sectionTag)) {
                return tableElem.getTHead();
            }
            if ("tfoot".equals(sectionTag)) {
                return tableElem.getTFoot();
            }
            throw new IllegalArgumentException("Invalid table section tag: " + sectionTag);
        }

        protected void replaceAllRows(CellTable<?> table, TableSectionElement section, SafeHtml html) {
            if (!table.isAttached()) {
                DOM.setEventListener(table.getElement(), table);
            }
            section.setInnerHTML(html.asString());
            if (!table.isAttached()) {
                DOM.setEventListener(table.getElement(), null);
            }
        }
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div style=\"outline:none;\">{0}</div>")
        public SafeHtml div(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<div style=\"outline:none;\" tabindex=\"{0}\">{1}</div>")
        public SafeHtml divFocusable(int var1, SafeHtml var2);

        @SafeHtmlTemplates.Template(value="<div style=\"outline:none;\" tabindex=\"{0}\" accessKey=\"{1}\">{2}</div>")
        public SafeHtml divFocusableWithKey(int var1, char var2, SafeHtml var3);

        @SafeHtmlTemplates.Template(value="<table role=\"grid\"><tbody>{0}</tbody></table>")
        public SafeHtml tbody(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<td class=\"{0}\" aria-labelledby=\"{1}\" role=\"gridcell\">{2}</td>")
        public SafeHtml td(String var1, String var2, SafeHtml var3);

        @SafeHtmlTemplates.Template(value="<td class=\"{0}\" aria-labelledby=\"{1}\" align=\"{2}\" valign=\"{3}\" role=\"gridcell\">{4}</td>")
        public SafeHtml tdBothAlign(String var1, String var2, String var3, String var4, SafeHtml var5);

        @SafeHtmlTemplates.Template(value="<td class=\"{0}\" aria-labelledby=\"{1}\" align=\"{2}\" role=\"gridcell\">{3}</td>")
        public SafeHtml tdHorizontalAlign(String var1, String var2, String var3, SafeHtml var4);

        @SafeHtmlTemplates.Template(value="<td class=\"{0}\" aria-labelledby=\"{1}\" valign=\"{2}\" role=\"gridcell\">{3}</td>")
        public SafeHtml tdVerticalAlign(String var1, String var2, String var3, SafeHtml var4);

        @SafeHtmlTemplates.Template(value="<table><tfoot>{0}</tfoot></table>")
        public SafeHtml tfoot(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<th id=\"{0}\" colspan=\"{1}\" class=\"{2}\" role=\"columnheader\">{3}</th>")
        public SafeHtml th(String var1, int var2, String var3, SafeHtml var4);

        @SafeHtmlTemplates.Template(value="<th colspan=\"{0}\" class=\"{1}\">{2}</th>")
        public SafeHtml th(int var1, String var2, SafeHtml var3);

        @SafeHtmlTemplates.Template(value="<table><thead>{0}</thead></table>")
        public SafeHtml thead(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<tr onclick=\"\" class=\"{0}\" role=\"row\">{1}</tr>")
        public SafeHtml tr(String var1, SafeHtml var2);
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellTable")
    static interface BasicStyle
    extends Style {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellTableBasic.css";
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellTable")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellTable.css";

        public String cellTableCell();

        public String cellTableEvenRow();

        public String cellTableEvenRowCell();

        public String cellTableFirstColumn();

        public String cellTableFirstColumnFooter();

        public String cellTableFirstColumnHeader();

        public String cellTableFooter();

        public String cellTableHeader();

        public String cellTableHoveredRow();

        public String cellTableHoveredRowCell();

        public String cellTableKeyboardSelectedCell();

        public String cellTableKeyboardSelectedRow();

        public String cellTableKeyboardSelectedRowCell();

        public String cellTableLastColumn();

        public String cellTableLastColumnFooter();

        public String cellTableLastColumnHeader();

        public String cellTableLoading();

        public String cellTableOddRow();

        public String cellTableOddRowCell();

        public String cellTableSelectedRow();

        public String cellTableSelectedRowCell();

        public String cellTableSortableHeader();

        public String cellTableSortedHeaderAscending();

        public String cellTableSortedHeaderDescending();

        public String cellTableWidget();
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"cellTableHeaderBackground.png"})
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellTableFooterBackground();

        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellTableHeaderBackground();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTableLoading();

        @ClientBundle.Source(value={"cellListSelectedBackground.png"})
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellTableSelectedBackground();

        @ClientBundle.Source(value={"sortAscending.png"})
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTableSortAscending();

        @ClientBundle.Source(value={"sortDescending.png"})
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTableSortDescending();

        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellTable.css"})
        public Style cellTableStyle();
    }

    public static interface BasicResources
    extends Resources {
        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellTableBasic.css"})
        public BasicStyle cellTableStyle();
    }
}

