/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.impl;

import com.google.gwt.core.client.impl.ConsoleLogger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class SimpleConsoleLogHandler
extends Handler {
    SimpleConsoleLogHandler() {
    }

    @Override
    public void publish(LogRecord record) {
        ConsoleLogger console = ConsoleLogger.createIfSupported();
        if (console == null) {
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        String level = this.toConsoleLogLevel(record.getLevel());
        console.log(level, record.getMessage());
        if (record.getThrown() != null) {
            console.log(level, record.getThrown());
        }
    }

    private String toConsoleLogLevel(Level level) {
        int val = level.intValue();
        if (val >= Level.SEVERE.intValue()) {
            return "error";
        }
        if (val >= Level.WARNING.intValue()) {
            return "warn";
        }
        if (val >= Level.INFO.intValue()) {
            return "info";
        }
        return "log";
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

