/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;

public class Property
extends PersistentObject {
    public static final Property DEFAULT = new Property(1.0E-9);
    public static final Property ZERO = new Property(0.0);
    public static final Property TWELVE = new Property(1.0E-12);
    protected double tolerance;

    private Property() {
        this(1.0E-9);
    }

    public Property(double d) {
        this.tolerance = Math.abs(d);
    }

    protected static String blanks(int n) {
        if (n < 0) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public void checkRectangular(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() < doubleMatrix2D.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular: " + Formatter.shape(doubleMatrix2D));
        }
    }

    public void checkSquare(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != doubleMatrix2D.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + Formatter.shape(doubleMatrix2D));
        }
    }

    public double density(DoubleMatrix2D doubleMatrix2D) {
        return (double)doubleMatrix2D.cardinality() / (double)doubleMatrix2D.size();
    }

    public boolean equals(DoubleMatrix1D doubleMatrix1D, double d) {
        if (doubleMatrix1D == null) {
            return false;
        }
        double d2 = this.tolerance();
        int n = doubleMatrix1D.size();
        while (--n >= 0) {
            double d3 = doubleMatrix1D.getQuick(n);
            double d4 = Math.abs(d - d3);
            if (d4 != d4 && (d != d && d3 != d3 || d == d3)) {
                d4 = 0.0;
            }
            if (d4 <= d2) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D == doubleMatrix1D2) {
            return true;
        }
        if (doubleMatrix1D == null || doubleMatrix1D2 == null) {
            return false;
        }
        int n = doubleMatrix1D.size();
        if (n != doubleMatrix1D2.size()) {
            return false;
        }
        double d = this.tolerance();
        int n2 = n;
        while (--n2 >= 0) {
            double d2 = doubleMatrix1D.getQuick(n2);
            double d3 = doubleMatrix1D2.getQuick(n2);
            double d4 = Math.abs(d3 - d2);
            if (d4 != d4 && (d3 != d3 && d2 != d2 || d3 == d2)) {
                d4 = 0.0;
            }
            if (d4 <= d) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DoubleMatrix2D doubleMatrix2D, double d) {
        if (doubleMatrix2D == null) {
            return false;
        }
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        double d2 = this.tolerance();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                double d3 = doubleMatrix2D.getQuick(n3, n4);
                double d4 = Math.abs(d - d3);
                if (d4 != d4 && (d != d && d3 != d3 || d == d3)) {
                    d4 = 0.0;
                }
                if (d4 <= d2) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        if (doubleMatrix2D == doubleMatrix2D2) {
            return true;
        }
        if (doubleMatrix2D == null || doubleMatrix2D2 == null) {
            return false;
        }
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        if (n2 != doubleMatrix2D2.columns() || n != doubleMatrix2D2.rows()) {
            return false;
        }
        double d = this.tolerance();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                double d2 = doubleMatrix2D.getQuick(n3, n4);
                double d3 = doubleMatrix2D2.getQuick(n3, n4);
                double d4 = Math.abs(d3 - d2);
                if (d4 != d4 && (d3 != d3 && d2 != d2 || d3 == d2)) {
                    d4 = 0.0;
                }
                if (d4 <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(DoubleMatrix3D doubleMatrix3D, double d) {
        if (doubleMatrix3D == null) {
            return false;
        }
        int n = doubleMatrix3D.rows();
        int n2 = doubleMatrix3D.columns();
        double d2 = this.tolerance();
        int n3 = doubleMatrix3D.slices();
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                int n5 = n2;
                while (--n5 >= 0) {
                    double d3 = doubleMatrix3D.getQuick(n3, n4, n5);
                    double d4 = Math.abs(d - d3);
                    if (d4 != d4 && (d != d && d3 != d3 || d == d3)) {
                        d4 = 0.0;
                    }
                    if (d4 <= d2) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(DoubleMatrix3D doubleMatrix3D, DoubleMatrix3D doubleMatrix3D2) {
        if (doubleMatrix3D == doubleMatrix3D2) {
            return true;
        }
        if (doubleMatrix3D == null || doubleMatrix3D2 == null) {
            return false;
        }
        int n = doubleMatrix3D.slices();
        int n2 = doubleMatrix3D.rows();
        int n3 = doubleMatrix3D.columns();
        if (n3 != doubleMatrix3D2.columns() || n2 != doubleMatrix3D2.rows() || n != doubleMatrix3D2.slices()) {
            return false;
        }
        double d = this.tolerance();
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                int n6 = n3;
                while (--n6 >= 0) {
                    double d2 = doubleMatrix3D.getQuick(n4, n5, n6);
                    double d3 = doubleMatrix3D2.getQuick(n4, n5, n6);
                    double d4 = Math.abs(d3 - d2);
                    if (d4 != d4 && (d3 != d3 && d2 != d2 || d3 == d2)) {
                        d4 = 0.0;
                    }
                    if (d4 <= d) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateNonSingular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        this.checkSquare(doubleMatrix2D);
        Functions functions = Functions.functions;
        int n2 = n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        while (--n2 >= 0) {
            doubleMatrix2D.setQuick(n2, n2, 0.0);
        }
        n2 = n;
        while (--n2 >= 0) {
            double d = doubleMatrix2D.viewRow(n2).aggregate(Functions.plus, Functions.abs);
            double d2 = doubleMatrix2D.viewColumn(n2).aggregate(Functions.plus, Functions.abs);
            doubleMatrix2D.setQuick(n2, n2, Math.max(d, d2) + (double)n2 + 1.0);
        }
    }

    protected static String get(ObjectArrayList objectArrayList, int n) {
        return (String)objectArrayList.get(n);
    }

    public boolean isDiagonal(DoubleMatrix2D doubleMatrix2D) {
        double d = this.tolerance();
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || Math.abs(doubleMatrix2D.getQuick(n3, n4)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonallyDominantByColumn(DoubleMatrix2D doubleMatrix2D) {
        int n;
        Functions functions = Functions.functions;
        double d = this.tolerance();
        int n2 = n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        while (--n2 >= 0) {
            double d2 = Math.abs(doubleMatrix2D.getQuick(n2, n2));
            d2 += d2;
            if (!(d2 <= doubleMatrix2D.viewColumn(n2).aggregate(Functions.plus, Functions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonallyDominantByRow(DoubleMatrix2D doubleMatrix2D) {
        int n;
        Functions functions = Functions.functions;
        double d = this.tolerance();
        int n2 = n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        while (--n2 >= 0) {
            double d2 = Math.abs(doubleMatrix2D.getQuick(n2, n2));
            d2 += d2;
            if (!(d2 <= doubleMatrix2D.viewRow(n2).aggregate(Functions.plus, Functions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(DoubleMatrix2D doubleMatrix2D) {
        double d = this.tolerance();
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                double d2 = doubleMatrix2D.getQuick(n3, n4);
                if (!(n3 == n4 ? !(Math.abs(1.0 - d2) < d) : !(Math.abs(d2) <= d))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(DoubleMatrix2D doubleMatrix2D) {
        double d = this.tolerance();
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || n3 == n4 + 1 || Math.abs(doubleMatrix2D.getQuick(n3, n4)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        double d = this.tolerance();
        int n2 = doubleMatrix2D.rows();
        int n3 = n = doubleMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = Math.min(n3, n2);
            while (--n4 >= 0) {
                if (Math.abs(doubleMatrix2D.getQuick(n4, n3)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNonNegative(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (doubleMatrix2D.getQuick(n3, n4) >= 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(DoubleMatrix2D doubleMatrix2D) {
        this.checkSquare(doubleMatrix2D);
        return this.equals(doubleMatrix2D.zMult(doubleMatrix2D, null, 1.0, 0.0, false, true), DoubleFactory2D.dense.identity(doubleMatrix2D.rows()));
    }

    public boolean isPositive(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (doubleMatrix2D.getQuick(n3, n4) > 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSingular(DoubleMatrix2D doubleMatrix2D) {
        return !(Math.abs(Algebra.DEFAULT.det(doubleMatrix2D)) >= this.tolerance());
    }

    public boolean isSkewSymmetric(DoubleMatrix2D doubleMatrix2D) {
        this.checkSquare(doubleMatrix2D);
        double d = this.tolerance();
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                if (Math.abs(doubleMatrix2D.getQuick(n3, n4) + doubleMatrix2D.getQuick(n4, n3)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare(DoubleMatrix2D doubleMatrix2D) {
        return doubleMatrix2D.rows() == doubleMatrix2D.columns();
    }

    public boolean isStrictlyLowerTriangular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        double d = this.tolerance();
        int n2 = doubleMatrix2D.rows();
        int n3 = n = doubleMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = Math.min(n2, n3 + 1);
            while (--n4 >= 0) {
                if (Math.abs(doubleMatrix2D.getQuick(n4, n3)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(DoubleMatrix2D doubleMatrix2D) {
        if (!this.isTriangular(doubleMatrix2D)) {
            return false;
        }
        double d = this.tolerance();
        int n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        while (--n >= 0) {
            if (Math.abs(doubleMatrix2D.getQuick(n, n)) <= d) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictlyUpperTriangular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        double d = this.tolerance();
        int n2 = doubleMatrix2D.rows();
        int n3 = n = doubleMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= n3) {
                if (Math.abs(doubleMatrix2D.getQuick(n4, n3)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(DoubleMatrix2D doubleMatrix2D) {
        this.checkSquare(doubleMatrix2D);
        return this.equals(doubleMatrix2D, doubleMatrix2D.viewDice());
    }

    public boolean isTriangular(DoubleMatrix2D doubleMatrix2D) {
        return this.isLowerTriangular(doubleMatrix2D) || this.isUpperTriangular(doubleMatrix2D);
    }

    public boolean isTridiagonal(DoubleMatrix2D doubleMatrix2D) {
        double d = this.tolerance();
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (Math.abs(n3 - n4) <= 1 || Math.abs(doubleMatrix2D.getQuick(n3, n4)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(DoubleMatrix2D doubleMatrix2D) {
        if (!this.isTriangular(doubleMatrix2D)) {
            return false;
        }
        double d = this.tolerance();
        int n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        while (--n >= 0) {
            if (Math.abs(1.0 - doubleMatrix2D.getQuick(n, n)) <= d) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperBidiagonal(DoubleMatrix2D doubleMatrix2D) {
        double d = this.tolerance();
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || n3 == n4 - 1 || Math.abs(doubleMatrix2D.getQuick(n3, n4)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        double d = this.tolerance();
        int n2 = doubleMatrix2D.rows();
        int n3 = n = doubleMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 > n3) {
                if (Math.abs(doubleMatrix2D.getQuick(n4, n3)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(DoubleMatrix2D doubleMatrix2D) {
        return this.equals(doubleMatrix2D, 0.0);
    }

    public int lowerBandwidth(DoubleMatrix2D doubleMatrix2D) {
        int n;
        this.checkSquare(doubleMatrix2D);
        double d = this.tolerance();
        int n2 = n = doubleMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (Math.abs(doubleMatrix2D.getQuick(n4, n3)) <= d) continue;
                return n2;
            }
        }
        return 0;
    }

    public int semiBandwidth(DoubleMatrix2D doubleMatrix2D) {
        int n;
        this.checkSquare(doubleMatrix2D);
        double d = this.tolerance();
        int n2 = n = doubleMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (!(Math.abs(doubleMatrix2D.getQuick(n4, n3)) <= d)) {
                    return n2 + 1;
                }
                if (Math.abs(doubleMatrix2D.getQuick(n3, n4)) <= d) continue;
                return n2 + 1;
            }
        }
        return 1;
    }

    public void setTolerance(double d) {
        if (this == DEFAULT || this == ZERO || this == TWELVE) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(d);
    }

    public double tolerance() {
        return this.tolerance;
    }

    public String toString(DoubleMatrix2D doubleMatrix2D) {
        int n;
        final ObjectArrayList objectArrayList = new ObjectArrayList();
        final ObjectArrayList objectArrayList2 = new ObjectArrayList();
        String string = "Illegal operation or error: ";
        objectArrayList.add("density");
        try {
            objectArrayList2.add(String.valueOf(this.density(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonal(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonallyDominantByRow");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonallyDominantByRow(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonallyDominantByColumn");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonallyDominantByColumn(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isIdentity");
        try {
            objectArrayList2.add(String.valueOf(this.isIdentity(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isLowerBidiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isLowerBidiagonal(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isLowerTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isLowerTriangular(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isNonNegative");
        try {
            objectArrayList2.add(String.valueOf(this.isNonNegative(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isOrthogonal");
        try {
            objectArrayList2.add(String.valueOf(this.isOrthogonal(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isPositive");
        try {
            objectArrayList2.add(String.valueOf(this.isPositive(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSingular");
        try {
            objectArrayList2.add(String.valueOf(this.isSingular(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSkewSymmetric");
        try {
            objectArrayList2.add(String.valueOf(this.isSkewSymmetric(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSquare");
        try {
            objectArrayList2.add(String.valueOf(this.isSquare(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyLowerTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyLowerTriangular(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyTriangular(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyUpperTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyUpperTriangular(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSymmetric");
        try {
            objectArrayList2.add(String.valueOf(this.isSymmetric(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isTriangular(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isTridiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isTridiagonal(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUnitTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isUnitTriangular(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUpperBidiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isUpperBidiagonal(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUpperTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isUpperTriangular(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isZero");
        try {
            objectArrayList2.add(String.valueOf(this.isZero(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("lowerBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.lowerBandwidth(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("semiBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.semiBandwidth(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("upperBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.upperBandwidth(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return Property.get(objectArrayList, n).compareTo(Property.get(objectArrayList, n2));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArrayList.get(n);
                objectArrayList.set(n, objectArrayList.get(n2));
                objectArrayList.set(n2, object);
                object = objectArrayList2.get(n);
                objectArrayList2.set(n, objectArrayList2.get(n2));
                objectArrayList2.set(n2, object);
            }
        };
        GenericSorting.quickSort(0, objectArrayList.size(), intComparator, swapper);
        int n2 = 0;
        for (int i = 0; i < objectArrayList.size(); ++i) {
            n = ((String)objectArrayList.get(i)).length();
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < objectArrayList.size(); ++n) {
            String string2 = (String)objectArrayList.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(Property.blanks(n2 - string2.length()));
            stringBuffer.append(" : ");
            stringBuffer.append(objectArrayList2.get(n));
            if (n >= objectArrayList.size() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int upperBandwidth(DoubleMatrix2D doubleMatrix2D) {
        int n;
        this.checkSquare(doubleMatrix2D);
        double d = this.tolerance();
        int n2 = n = doubleMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (Math.abs(doubleMatrix2D.getQuick(n3, n4)) <= d) continue;
                return n2;
            }
        }
        return 0;
    }
}

