/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Implementation of DateTimeFormatInfo for locale "lv".
 */
public class DateTimeFormatInfoImpl_lv extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, y. 'gada' d. MMMM";
  }

  @Override
  public String dateFormatLong() {
    return "y. 'gada' d. MMMM";
  }

  @Override
  public String dateFormatMedium() {
    return "y. 'gada' d. MMM";
  }

  @Override
  public String dateFormatShort() {
    return "dd.MM.yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] { 
        "pirms mūsu ēras",
        "mūsu ērā"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] { 
        "p.m.ē.",
        "m.ē."
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 1;
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d. MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d. MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d. MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "dd.mm.";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "yyyy. 'g'. MMM";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y. 'gada' d. MMM";
  }

  @Override
  public String formatYearMonthFull() {
    return "yyyy. 'g'. MMMM";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y. 'gada' d. MMMM";
  }

  @Override
  public String formatYearMonthNum() {
    return "mm.yyyy.";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d.M.y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, y. 'gada' d. MMM";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ yyyy";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q yyyy";
  }

  @Override
  public String[] monthsFull() {
    return new String[] { 
        "janvāris",
        "februāris",
        "marts",
        "aprīlis",
        "maijs",
        "jūnijs",
        "jūlijs",
        "augusts",
        "septembris",
        "oktobris",
        "novembris",
        "decembris"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return monthsFull();
  }

  @Override
  public String[] monthsShort() {
    return new String[] { 
        "janv.",
        "febr.",
        "marts",
        "apr.",
        "maijs",
        "jūn.",
        "jūl.",
        "aug.",
        "sept.",
        "okt.",
        "nov.",
        "dec."
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return monthsShort();
  }

  @Override
  public String[] quartersFull() {
    return new String[] { 
        "1. ceturksnis",
        "2. ceturksnis",
        "3. ceturksnis",
        "4. ceturksnis"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] { 
        "C1",
        "C2",
        "C3",
        "C4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "HH:mm:ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "HH:mm:ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "HH:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "HH:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] { 
        "svētdiena",
        "pirmdiena",
        "otrdiena",
        "trešdiena",
        "ceturtdiena",
        "piektdiena",
        "sestdiena"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] { 
        "S",
        "P",
        "O",
        "T",
        "C",
        "P",
        "S"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] { 
        "Sv",
        "Pr",
        "Ot",
        "Tr",
        "Ce",
        "Pk",
        "Se"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }
}
