/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "tzm" locale.
 */
public class LocalizedNamesImpl_tzm extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "PS",
        "AL",
        "DE",
        "IO",
        "AD",
        "AO",
        "AI",
        "AG",
        "AN",
        "AQ",
        "AR",
        "AM",
        "AW",
        "VA",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BG",
        "BY",
        "BZ",
        "BJ",
        "BM",
        "BL",
        "BQ",
        "BR",
        "BN",
        "BO",
        "BF",
        "BI",
        "BA",
        "BT",
        "BW",
        "BV",
        "CC",
        "CL",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "DZ",
        "EA",
        "EH",
        "EU",
        "FJ",
        "PH",
        "FI",
        "FO",
        "FR",
        "GA",
        "GM",
        "GG",
        "DJ",
        "GD",
        "GL",
        "GS",
        "GY",
        "GF",
        "GP",
        "GU",
        "GT",
        "HT",
        "HU",
        "IN",
        "HN",
        "HK",
        "HM",
        "NL",
        "IC",
        "EC",
        "IM",
        "AE",
        "ID",
        "IR",
        "ER",
        "IE",
        "IS",
        "IL",
        "EE",
        "IT",
        "ET",
        "US",
        "JM",
        "JE",
        "GI",
        "JP",
        "GE",
        "NC",
        "KH",
        "CM",
        "CA",
        "KZ",
        "KE",
        "KI",
        "KG",
        "HR",
        "CU",
        "CO",
        "CG",
        "KP",
        "KR",
        "CR",
        "KW",
        "LA",
        "LR",
        "LY",
        "LI",
        "LU",
        "LS",
        "LV",
        "LT",
        "LB",
        "MG",
        "MW",
        "MV",
        "ML",
        "MY",
        "MT",
        "MN",
        "MK",
        "MQ",
        "YT",
        "ME",
        "MA",
        "MF",
        "FM",
        "MX",
        "EG",
        "MO",
        "MD",
        "MC",
        "MS",
        "MU",
        "MR",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NG",
        "NI",
        "NP",
        "NU",
        "NE",
        "NO",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "QA",
        "QO",
        "CY",
        "KM",
        "RE",
        "RS",
        "RO",
        "RU",
        "RW",
        "SV",
        "WS",
        "AS",
        "SM",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "SG",
        "ST",
        "ES",
        "SL",
        "SJ",
        "SK",
        "SI",
        "LK",
        "SS",
        "SA",
        "SE",
        "SC",
        "CN",
        "SN",
        "SD",
        "SO",
        "SR",
        "SY",
        "SZ",
        "CH",
        "SX",
        "TA",
        "ZA",
        "CF",
        "CZ",
        "DO",
        "CD",
        "GB",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "CI",
        "TD",
        "TF",
        "VG",
        "FK",
        "CV",
        "KY",
        "CK",
        "MH",
        "MP",
        "SB",
        "VI",
        "TC",
        "NF",
        "TL",
        "TT",
        "TG",
        "TK",
        "TN",
        "TO",
        "TM",
        "TR",
        "TV",
        "UA",
        "UM",
        "JO",
        "UY",
        "AU",
        "AT",
        "UZ",
        "UG",
        "VU",
        "VE",
        "VN",
        "WF",
        "XK",
        "YE",
        "GR",
        "ZM",
        "NZ",
        "ZW",
        "IQ",
        "OM",
        "GH",
        "GN",
        "GW",
        "GQ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Anḍurra");
    namesMap.put("AE", "Imarat Tiεrabin Tidduklin");
    namesMap.put("AF", "Afɣanistan");
    namesMap.put("AG", "Antigwa d Barbuda");
    namesMap.put("AI", "Angwilla");
    namesMap.put("AL", "Albanya");
    namesMap.put("AM", "Arminya");
    namesMap.put("AN", "Antil Tihulanḍiyyin");
    namesMap.put("AO", "Angula");
    namesMap.put("AR", "Arjuntin");
    namesMap.put("AS", "Samwa Imirikaniyyin");
    namesMap.put("AT", "Ustriyya");
    namesMap.put("AU", "Usṭralya");
    namesMap.put("AZ", "Azerbiǧan");
    namesMap.put("BA", "Busna-d-Hirsik");
    namesMap.put("BB", "Barbadus");
    namesMap.put("BD", "Bangladic");
    namesMap.put("BE", "Beljika");
    namesMap.put("BF", "Burkina Fasu");
    namesMap.put("BG", "Belɣarya");
    namesMap.put("BH", "Baḥrayn");
    namesMap.put("BJ", "Binin");
    namesMap.put("BM", "Birmuda");
    namesMap.put("BN", "Brunay");
    namesMap.put("BO", "Bulivya");
    namesMap.put("BR", "Bṛazil");
    namesMap.put("BT", "Buṭan");
    namesMap.put("BW", "Butswana");
    namesMap.put("BY", "Bilarusya");
    namesMap.put("BZ", "Biliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Tagduda Tadimuqraṭit n Kungu");
    namesMap.put("CF", "Tagduda n Afrika Wammas");
    namesMap.put("CG", "Kungu");
    namesMap.put("CH", "Swisra");
    namesMap.put("CI", "Taɣazut n Uszer");
    namesMap.put("CK", "Tigzirin n Kuk");
    namesMap.put("CL", "Ccili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Ṣṣin");
    namesMap.put("CO", "Kulumbya");
    namesMap.put("CR", "Kusṭa Rika");
    namesMap.put("CU", "kuba");
    namesMap.put("CV", "Tigzirin n Iɣf Uzegzaw");
    namesMap.put("CY", "Qubrus");
    namesMap.put("CZ", "Tagduda n Čik");
    namesMap.put("DE", "Almanya");
    namesMap.put("DJ", "Ǧibuti");
    namesMap.put("DK", "Danmark");
    namesMap.put("DM", "Ḍuminika");
    namesMap.put("DO", "Tagduda n Ḍuminikan");
    namesMap.put("DZ", "Dzayer");
    namesMap.put("EC", "Ikwaḍur");
    namesMap.put("EE", "Isṭunya");
    namesMap.put("EG", "Miṣr");
    namesMap.put("ER", "Iritrya");
    namesMap.put("ES", "Sbanya");
    namesMap.put("ET", "Ityupya");
    namesMap.put("FI", "Finlanḍa");
    namesMap.put("FK", "Tigzirin n Falkland");
    namesMap.put("FM", "Mikrunizya");
    namesMap.put("FR", "Fṛansa");
    namesMap.put("GA", "Gabun");
    namesMap.put("GB", "Tagelda Taddukelt");
    namesMap.put("GD", "Grinada");
    namesMap.put("GE", "Jyurjya");
    namesMap.put("GF", "Guyana Tafransist");
    namesMap.put("GH", "Ɣana");
    namesMap.put("GI", "Jibralṭar");
    namesMap.put("GL", "Grinlanḍa");
    namesMap.put("GM", "Gambya");
    namesMap.put("GN", "Ɣinya");
    namesMap.put("GP", "Gwadalup");
    namesMap.put("GQ", "Ɣinya Tikwaṭur it");
    namesMap.put("GR", "Yunan");
    namesMap.put("GT", "Gwatimala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ɣinya-Bissaw");
    namesMap.put("HN", "Hinduras");
    namesMap.put("HR", "Krwatya");
    namesMap.put("HT", "Hayti");
    namesMap.put("HU", "Henɣarya");
    namesMap.put("ID", "Indunizya");
    namesMap.put("IE", "Irlanḍa");
    namesMap.put("IL", "Israeil");
    namesMap.put("IN", "Hind");
    namesMap.put("IO", "Amur n Agaraw Uhindi Ubṛiṭani");
    namesMap.put("IQ", "Ɛiraq");
    namesMap.put("IS", "Islanḍa");
    namesMap.put("IT", "Iṭalya");
    namesMap.put("JM", "Jamayka");
    namesMap.put("JO", "Urḍun");
    namesMap.put("JP", "Jjappun");
    namesMap.put("KE", "Kinya");
    namesMap.put("KG", "Kirɣistan");
    namesMap.put("KH", "Kambudj");
    namesMap.put("KM", "Qumur");
    namesMap.put("KN", "Santekits d Nivis");
    namesMap.put("KP", "Kurya Tugafat");
    namesMap.put("KR", "Kurya Tunẓult");
    namesMap.put("KW", "Kuwwayt");
    namesMap.put("KY", "Tigzirin n Kayman");
    namesMap.put("KZ", "Kazaxistan");
    namesMap.put("LA", "Laws");
    namesMap.put("LB", "Lubnan");
    namesMap.put("LC", "Santelusya");
    namesMap.put("LI", "Lictencṭayn");
    namesMap.put("LK", "Srilanka");
    namesMap.put("LR", "Libirya");
    namesMap.put("LS", "Lisuṭu");
    namesMap.put("LT", "Litwanya");
    namesMap.put("LU", "Liksumburg");
    namesMap.put("LV", "Liṭṭunya");
    namesMap.put("MA", "Meṛṛuk");
    namesMap.put("MC", "Munaku");
    namesMap.put("MD", "Mulḍavya");
    namesMap.put("MG", "Madaɣacqar");
    namesMap.put("MH", "Tigzirin n Marcal");
    namesMap.put("MK", "Maqdunya");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Manɣulya");
    namesMap.put("MP", "Tigzirin n Maryana Tugafat");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Muritanya");
    namesMap.put("MS", "Muntsirra");
    namesMap.put("MT", "Malṭa");
    namesMap.put("MU", "Muris");
    namesMap.put("MV", "Maldiv");
    namesMap.put("MX", "Miksik");
    namesMap.put("MY", "Malizya");
    namesMap.put("MZ", "Muzambiq");
    namesMap.put("NA", "Namibya");
    namesMap.put("NC", "kalidunya Tamaynut");
    namesMap.put("NE", "Nnijer");
    namesMap.put("NF", "Tigzirt Nurfulk");
    namesMap.put("NG", "Nijiria");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Hulanḍa");
    namesMap.put("NO", "Nnurwij");
    namesMap.put("NP", "Nippal");
    namesMap.put("NR", "Nawru");
    namesMap.put("NU", "Niwi");
    namesMap.put("NZ", "Zilanḍa Tamaynut");
    namesMap.put("OM", "Ɛumman");
    namesMap.put("PE", "Piru");
    namesMap.put("PF", "Pulinizya Tafransist");
    namesMap.put("PG", "Papwa Ɣinya Tamaynut");
    namesMap.put("PH", "Filippin");
    namesMap.put("PL", "Pulunya");
    namesMap.put("PM", "Santepyir d Mikelun");
    namesMap.put("PN", "Pitkirn");
    namesMap.put("PR", "Purturiku");
    namesMap.put("PS", "Agemmaḍ Ugut d Ɣazza Ifilisṭiniyen");
    namesMap.put("PT", "Purtuɣal");
    namesMap.put("PW", "Palu");
    namesMap.put("PY", "Paragway");
    namesMap.put("QA", "Qaṭar");
    namesMap.put("RE", "Riyyunyun");
    namesMap.put("RO", "Ṛumanya");
    namesMap.put("RU", "Rusya");
    namesMap.put("RW", "Ruwwanḍa");
    namesMap.put("SA", "Ssaεudiyya Taεrabt");
    namesMap.put("SB", "Tigzirin n Salumun");
    namesMap.put("SC", "Ssicil");
    namesMap.put("SD", "Ssudan");
    namesMap.put("SE", "Ssewwid");
    namesMap.put("SG", "Sanɣafura");
    namesMap.put("SH", "Santehilin");
    namesMap.put("SI", "Sluvinya");
    namesMap.put("SK", "Sluvakya");
    namesMap.put("SL", "Siralyun");
    namesMap.put("SM", "Sanmarinu");
    namesMap.put("SN", "Ssiniɣal");
    namesMap.put("SO", "Ṣṣumal");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sawṭumi d Prinsip");
    namesMap.put("SV", "Salvaḍur");
    namesMap.put("SY", "Surya");
    namesMap.put("SZ", "Swazilanḍa");
    namesMap.put("TC", "Tigzirin Turkiyyin d Tikaykusin");
    namesMap.put("TD", "Tcad");
    namesMap.put("TG", "Ṭṭugu");
    namesMap.put("TH", "Ṭaylanḍa");
    namesMap.put("TJ", "Ṭaǧikistan");
    namesMap.put("TK", "Tuklu");
    namesMap.put("TL", "Timur Tagmuṭ");
    namesMap.put("TM", "Turkmanistan");
    namesMap.put("TN", "Tunes");
    namesMap.put("TO", "Ṭunga");
    namesMap.put("TR", "Turkya");
    namesMap.put("TT", "Trinidad d Ṭubagu");
    namesMap.put("TV", "Ṭuvalu");
    namesMap.put("TW", "Ṭaywan");
    namesMap.put("TZ", "Ṭanzanya");
    namesMap.put("UA", "Ukranya");
    namesMap.put("UG", "Uɣanda");
    namesMap.put("US", "Iwunak Idduklen n Amirika");
    namesMap.put("UY", "Urugway");
    namesMap.put("UZ", "Uzbakistan");
    namesMap.put("VA", "Awank iɣrem n Vatikan");
    namesMap.put("VC", "Santevinsent d Grinadin");
    namesMap.put("VE", "Vinzwilla");
    namesMap.put("VG", "Tigzirin (Virgin) Tibṛiṭaniyin");
    namesMap.put("VI", "Tigzirin n Virjin n Iwunak Yedduklen");
    namesMap.put("VN", "Viṭnam");
    namesMap.put("VU", "Vanwatu");
    namesMap.put("WF", "Walis d Futuna");
    namesMap.put("WS", "Samwa");
    namesMap.put("YE", "Yaman");
    namesMap.put("YT", "Mayuṭ");
    namesMap.put("ZA", "Tafrikt Tunẓul");
    namesMap.put("ZM", "Zambya");
    namesMap.put("ZW", "Zimbabwi");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Anḍurra",
        "AE": "Imarat Tiεrabin Tidduklin",
        "AF": "Afɣanistan",
        "AG": "Antigwa d Barbuda",
        "AI": "Angwilla",
        "AL": "Albanya",
        "AM": "Arminya",
        "AN": "Antil Tihulanḍiyyin",
        "AO": "Angula",
        "AR": "Arjuntin",
        "AS": "Samwa Imirikaniyyin",
        "AT": "Ustriyya",
        "AU": "Usṭralya",
        "AZ": "Azerbiǧan",
        "BA": "Busna-d-Hirsik",
        "BB": "Barbadus",
        "BD": "Bangladic",
        "BE": "Beljika",
        "BF": "Burkina Fasu",
        "BG": "Belɣarya",
        "BH": "Baḥrayn",
        "BJ": "Binin",
        "BM": "Birmuda",
        "BN": "Brunay",
        "BO": "Bulivya",
        "BR": "Bṛazil",
        "BT": "Buṭan",
        "BW": "Butswana",
        "BY": "Bilarusya",
        "BZ": "Biliz",
        "CA": "Kanada",
        "CD": "Tagduda Tadimuqraṭit n Kungu",
        "CF": "Tagduda n Afrika Wammas",
        "CG": "Kungu",
        "CH": "Swisra",
        "CI": "Taɣazut n Uszer",
        "CK": "Tigzirin n Kuk",
        "CL": "Ccili",
        "CM": "Kamerun",
        "CN": "Ṣṣin",
        "CO": "Kulumbya",
        "CR": "Kusṭa Rika",
        "CU": "kuba",
        "CV": "Tigzirin n Iɣf Uzegzaw",
        "CY": "Qubrus",
        "CZ": "Tagduda n Čik",
        "DE": "Almanya",
        "DJ": "Ǧibuti",
        "DK": "Danmark",
        "DM": "Ḍuminika",
        "DO": "Tagduda n Ḍuminikan",
        "DZ": "Dzayer",
        "EC": "Ikwaḍur",
        "EE": "Isṭunya",
        "EG": "Miṣr",
        "ER": "Iritrya",
        "ES": "Sbanya",
        "ET": "Ityupya",
        "FI": "Finlanḍa",
        "FK": "Tigzirin n Falkland",
        "FM": "Mikrunizya",
        "FR": "Fṛansa",
        "GA": "Gabun",
        "GB": "Tagelda Taddukelt",
        "GD": "Grinada",
        "GE": "Jyurjya",
        "GF": "Guyana Tafransist",
        "GH": "Ɣana",
        "GI": "Jibralṭar",
        "GL": "Grinlanḍa",
        "GM": "Gambya",
        "GN": "Ɣinya",
        "GP": "Gwadalup",
        "GQ": "Ɣinya Tikwaṭur it",
        "GR": "Yunan",
        "GT": "Gwatimala",
        "GU": "Gwam",
        "GW": "Ɣinya-Bissaw",
        "HN": "Hinduras",
        "HR": "Krwatya",
        "HT": "Hayti",
        "HU": "Henɣarya",
        "ID": "Indunizya",
        "IE": "Irlanḍa",
        "IL": "Israeil",
        "IN": "Hind",
        "IO": "Amur n Agaraw Uhindi Ubṛiṭani",
        "IQ": "Ɛiraq",
        "IS": "Islanḍa",
        "IT": "Iṭalya",
        "JM": "Jamayka",
        "JO": "Urḍun",
        "JP": "Jjappun",
        "KE": "Kinya",
        "KG": "Kirɣistan",
        "KH": "Kambudj",
        "KM": "Qumur",
        "KN": "Santekits d Nivis",
        "KP": "Kurya Tugafat",
        "KR": "Kurya Tunẓult",
        "KW": "Kuwwayt",
        "KY": "Tigzirin n Kayman",
        "KZ": "Kazaxistan",
        "LA": "Laws",
        "LB": "Lubnan",
        "LC": "Santelusya",
        "LI": "Lictencṭayn",
        "LK": "Srilanka",
        "LR": "Libirya",
        "LS": "Lisuṭu",
        "LT": "Litwanya",
        "LU": "Liksumburg",
        "LV": "Liṭṭunya",
        "MA": "Meṛṛuk",
        "MC": "Munaku",
        "MD": "Mulḍavya",
        "MG": "Madaɣacqar",
        "MH": "Tigzirin n Marcal",
        "MK": "Maqdunya",
        "MM": "Myanmar",
        "MN": "Manɣulya",
        "MP": "Tigzirin n Maryana Tugafat",
        "MQ": "Martinik",
        "MR": "Muritanya",
        "MS": "Muntsirra",
        "MT": "Malṭa",
        "MU": "Muris",
        "MV": "Maldiv",
        "MX": "Miksik",
        "MY": "Malizya",
        "MZ": "Muzambiq",
        "NA": "Namibya",
        "NC": "kalidunya Tamaynut",
        "NE": "Nnijer",
        "NF": "Tigzirt Nurfulk",
        "NG": "Nijiria",
        "NI": "Nikaragwa",
        "NL": "Hulanḍa",
        "NO": "Nnurwij",
        "NP": "Nippal",
        "NR": "Nawru",
        "NU": "Niwi",
        "NZ": "Zilanḍa Tamaynut",
        "OM": "Ɛumman",
        "PE": "Piru",
        "PF": "Pulinizya Tafransist",
        "PG": "Papwa Ɣinya Tamaynut",
        "PH": "Filippin",
        "PL": "Pulunya",
        "PM": "Santepyir d Mikelun",
        "PN": "Pitkirn",
        "PR": "Purturiku",
        "PS": "Agemmaḍ Ugut d Ɣazza Ifilisṭiniyen",
        "PT": "Purtuɣal",
        "PW": "Palu",
        "PY": "Paragway",
        "QA": "Qaṭar",
        "RE": "Riyyunyun",
        "RO": "Ṛumanya",
        "RU": "Rusya",
        "RW": "Ruwwanḍa",
        "SA": "Ssaεudiyya Taεrabt",
        "SB": "Tigzirin n Salumun",
        "SC": "Ssicil",
        "SD": "Ssudan",
        "SE": "Ssewwid",
        "SG": "Sanɣafura",
        "SH": "Santehilin",
        "SI": "Sluvinya",
        "SK": "Sluvakya",
        "SL": "Siralyun",
        "SM": "Sanmarinu",
        "SN": "Ssiniɣal",
        "SO": "Ṣṣumal",
        "SR": "Surinam",
        "ST": "Sawṭumi d Prinsip",
        "SV": "Salvaḍur",
        "SY": "Surya",
        "SZ": "Swazilanḍa",
        "TC": "Tigzirin Turkiyyin d Tikaykusin",
        "TD": "Tcad",
        "TG": "Ṭṭugu",
        "TH": "Ṭaylanḍa",
        "TJ": "Ṭaǧikistan",
        "TK": "Tuklu",
        "TL": "Timur Tagmuṭ",
        "TM": "Turkmanistan",
        "TN": "Tunes",
        "TO": "Ṭunga",
        "TR": "Turkya",
        "TT": "Trinidad d Ṭubagu",
        "TV": "Ṭuvalu",
        "TW": "Ṭaywan",
        "TZ": "Ṭanzanya",
        "UA": "Ukranya",
        "UG": "Uɣanda",
        "US": "Iwunak Idduklen n Amirika",
        "UY": "Urugway",
        "UZ": "Uzbakistan",
        "VA": "Awank iɣrem n Vatikan",
        "VC": "Santevinsent d Grinadin",
        "VE": "Vinzwilla",
        "VG": "Tigzirin (Virgin) Tibṛiṭaniyin",
        "VI": "Tigzirin n Virjin n Iwunak Yedduklen",
        "VN": "Viṭnam",
        "VU": "Vanwatu",
        "WF": "Walis d Futuna",
        "WS": "Samwa",
        "YE": "Yaman",
        "YT": "Mayuṭ",
        "ZA": "Tafrikt Tunẓul",
        "ZM": "Zambya",
        "ZW": "Zimbabwi"
    };
  }-*/;
}
