/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "bg" locale.
 */
public class LocalizedNamesImpl_bg extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "BG",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AU",
        "AT",
        "AZ",
        "AL",
        "DZ",
        "AS",
        "VI",
        "AO",
        "AI",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AF",
        "BD",
        "BB",
        "BS",
        "BH",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BF",
        "BI",
        "BT",
        "BG",
        "VU",
        "VA",
        "VE",
        "VN",
        "GA",
        "GM",
        "GH",
        "GY",
        "GP",
        "GT",
        "GN",
        "GW",
        "DE",
        "GI",
        "GD",
        "GL",
        "GE",
        "GU",
        "GG",
        "GR",
        "DK",
        "DJ",
        "JE",
        "DG",
        "DM",
        "DO",
        "EZ",
        "EU",
        "EG",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "ZM",
        "EH",
        "ZW",
        "IL",
        "TL",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "YE",
        "JO",
        "CV",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "BQ",
        "QA",
        "KE",
        "CY",
        "KG",
        "KI",
        "CN",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "KW",
        "CW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LY",
        "LB",
        "LT",
        "LI",
        "LU",
        "MR",
        "MU",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MX",
        "MM",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "NI",
        "NU",
        "NZ",
        "NC",
        "NO",
        "AE",
        "GB",
        "AX",
        "OM",
        "UN",
        "BV",
        "AC",
        "CK",
        "PN",
        "TC",
        "HM",
        "CP",
        "IM",
        "NF",
        "CX",
        "QO",
        "UM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SJ",
        "SH",
        "KP",
        "MP",
        "VC",
        "KN",
        "LC",
        "SC",
        "BL",
        "SN",
        "MF",
        "PM",
        "EA",
        "SL",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "SD",
        "SR",
        "US",
        "RS",
        "TJ",
        "TW",
        "TH",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TM",
        "TR",
        "UG",
        "UZ",
        "UA",
        "HU",
        "WF",
        "UY",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "HT",
        "HN",
        "HK",
        "HR",
        "CF",
        "TD",
        "ME",
        "CZ",
        "CL",
        "CH",
        "SE",
        "LK",
        "SS",
        "ZA",
        "GS",
        "KR",
        "JM",
        "JP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Свят");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Северноамерикански континент");
    namesMap.put("005", "Южна Америка");
    namesMap.put("009", "Океания");
    namesMap.put("011", "Западна Афирка");
    namesMap.put("013", "Централна Америка");
    namesMap.put("014", "Източна Африка");
    namesMap.put("015", "Северна Африка");
    namesMap.put("017", "Централна Африка");
    namesMap.put("018", "Южноафрикански регион");
    namesMap.put("019", "Америка");
    namesMap.put("021", "Северна Америка");
    namesMap.put("029", "Карибски регион");
    namesMap.put("030", "Източна Азия");
    namesMap.put("034", "Южна Азия");
    namesMap.put("035", "Югоизточна Азия");
    namesMap.put("039", "Южна Европа");
    namesMap.put("053", "Австралазия");
    namesMap.put("054", "Меланезия");
    namesMap.put("057", "Микронезийски регион");
    namesMap.put("061", "Полинезия");
    namesMap.put("142", "Азия");
    namesMap.put("143", "Централна Азия");
    namesMap.put("145", "Западна Азия");
    namesMap.put("150", "Европа");
    namesMap.put("151", "Източна Европа");
    namesMap.put("154", "Северна Европа");
    namesMap.put("155", "Западна Европа");
    namesMap.put("202", "Субсахарска Африка");
    namesMap.put("419", "Латинска Америка");
    namesMap.put("AC", "остров Възнесение");
    namesMap.put("AD", "Андора");
    namesMap.put("AE", "Обединени арабски емирства");
    namesMap.put("AF", "Афганистан");
    namesMap.put("AG", "Антигуа и Барбуда");
    namesMap.put("AI", "Ангуила");
    namesMap.put("AL", "Албания");
    namesMap.put("AM", "Армения");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктика");
    namesMap.put("AR", "Аржентина");
    namesMap.put("AS", "Американска Самоа");
    namesMap.put("AT", "Австрия");
    namesMap.put("AU", "Австралия");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Оландски острови");
    namesMap.put("AZ", "Азербайджан");
    namesMap.put("BA", "Босна и Херцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Белгия");
    namesMap.put("BF", "Буркина Фасо");
    namesMap.put("BG", "България");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Сен Бартелеми");
    namesMap.put("BM", "Бермудски острови");
    namesMap.put("BN", "Бруней Даруссалам");
    namesMap.put("BO", "Боливия");
    namesMap.put("BQ", "Карибска Нидерландия");
    namesMap.put("BR", "Бразилия");
    namesMap.put("BS", "Бахамски острови");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "остров Буве");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Беларус");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокосови острови (острови Кийлинг)");
    namesMap.put("CD", "Конго (Киншаса)");
    namesMap.put("CF", "Централноафриканска република");
    namesMap.put("CG", "Конго (Бразавил)");
    namesMap.put("CH", "Швейцария");
    namesMap.put("CI", "Кот д’Ивоар");
    namesMap.put("CK", "острови Кук");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Китай");
    namesMap.put("CO", "Колумбия");
    namesMap.put("CP", "остров Клипертон");
    namesMap.put("CR", "Коста Рика");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо Верде");
    namesMap.put("CW", "Кюрасао");
    namesMap.put("CX", "остров Рождество");
    namesMap.put("CY", "Кипър");
    namesMap.put("CZ", "Чехия");
    namesMap.put("DE", "Германия");
    namesMap.put("DG", "Диего Гарсия");
    namesMap.put("DJ", "Джибути");
    namesMap.put("DK", "Дания");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминиканска република");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута и Мелия");
    namesMap.put("EC", "Еквадор");
    namesMap.put("EE", "Естония");
    namesMap.put("EG", "Египет");
    namesMap.put("EH", "Западна Сахара");
    namesMap.put("ER", "Еритрея");
    namesMap.put("ES", "Испания");
    namesMap.put("ET", "Етиопия");
    namesMap.put("EU", "Европейски съюз");
    namesMap.put("EZ", "Еврозона");
    namesMap.put("FI", "Финландия");
    namesMap.put("FJ", "Фиджи");
    namesMap.put("FK", "Фолкландски острови");
    namesMap.put("FM", "Микронезия");
    namesMap.put("FO", "Фарьорски острови");
    namesMap.put("FR", "Франция");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Обединеното кралство");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузия");
    namesMap.put("GF", "Френска Гвиана");
    namesMap.put("GG", "Гърнзи");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренландия");
    namesMap.put("GM", "Гамбия");
    namesMap.put("GN", "Гвинея");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Екваториална Гвинея");
    namesMap.put("GR", "Гърция");
    namesMap.put("GS", "Южна Джорджия и Южни Сандвичеви острови");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинея-Бисау");
    namesMap.put("GY", "Гаяна");
    namesMap.put("HK", "Хонконг, САР на Китай");
    namesMap.put("HM", "острови Хърд и Макдоналд");
    namesMap.put("HN", "Хондурас");
    namesMap.put("HR", "Хърватия");
    namesMap.put("HT", "Хаити");
    namesMap.put("HU", "Унгария");
    namesMap.put("IC", "Канарски острови");
    namesMap.put("ID", "Индонезия");
    namesMap.put("IE", "Ирландия");
    namesMap.put("IL", "Израел");
    namesMap.put("IM", "остров Ман");
    namesMap.put("IN", "Индия");
    namesMap.put("IO", "Британска територия в Индийския океан");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исландия");
    namesMap.put("IT", "Италия");
    namesMap.put("JE", "Джърси");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Йордания");
    namesMap.put("JP", "Япония");
    namesMap.put("KE", "Кения");
    namesMap.put("KG", "Киргизстан");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Коморски острови");
    namesMap.put("KN", "Сейнт Китс и Невис");
    namesMap.put("KP", "Северна Корея");
    namesMap.put("KR", "Южна Корея");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайманови острови");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Сейнт Лусия");
    namesMap.put("LI", "Лихтенщайн");
    namesMap.put("LK", "Шри Ланка");
    namesMap.put("LR", "Либерия");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвия");
    namesMap.put("LY", "Либия");
    namesMap.put("MA", "Мароко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Черна гора");
    namesMap.put("MF", "Сен Мартен");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалови острови");
    namesMap.put("MK", "Македония");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мианмар (Бирма)");
    namesMap.put("MN", "Монголия");
    namesMap.put("MO", "Макао, САР на Китай");
    namesMap.put("MP", "Северни Мариански острови");
    namesMap.put("MQ", "Мартиника");
    namesMap.put("MR", "Мавритания");
    namesMap.put("MS", "Монтсерат");
    namesMap.put("MT", "Малта");
    namesMap.put("MU", "Мавриций");
    namesMap.put("MV", "Малдиви");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексико");
    namesMap.put("MY", "Малайзия");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибия");
    namesMap.put("NC", "Нова Каледония");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "остров Норфолк");
    namesMap.put("NG", "Нигерия");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Нидерландия");
    namesMap.put("NO", "Норвегия");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуе");
    namesMap.put("NZ", "Нова Зеландия");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Френска Полинезия");
    namesMap.put("PG", "Папуа-Нова Гвинея");
    namesMap.put("PH", "Филипини");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Полша");
    namesMap.put("PM", "Сен Пиер и Микелон");
    namesMap.put("PN", "Острови Питкерн");
    namesMap.put("PR", "Пуерто Рико");
    namesMap.put("PS", "Палестински територии");
    namesMap.put("PT", "Португалия");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Отдалечени острови на Океания");
    namesMap.put("RE", "Реюнион");
    namesMap.put("RO", "Румъния");
    namesMap.put("RS", "Сърбия");
    namesMap.put("RU", "Русия");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудитска Арабия");
    namesMap.put("SB", "Соломонови острови");
    namesMap.put("SC", "Сейшели");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеция");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Света Елена");
    namesMap.put("SI", "Словения");
    namesMap.put("SJ", "Свалбард и Ян Майен");
    namesMap.put("SK", "Словакия");
    namesMap.put("SL", "Сиера Леоне");
    namesMap.put("SM", "Сан Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомалия");
    namesMap.put("SR", "Суринам");
    namesMap.put("SS", "Южен Судан");
    namesMap.put("ST", "Сао Томе и Принсипи");
    namesMap.put("SV", "Салвадор");
    namesMap.put("SX", "Синт Мартен");
    namesMap.put("SY", "Сирия");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TA", "Тристан да Куня");
    namesMap.put("TC", "острови Търкс и Кайкос");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Френски южни територии");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Таджикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Източен Тимор");
    namesMap.put("TM", "Туркменистан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Турция");
    namesMap.put("TT", "Тринидад и Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайван");
    namesMap.put("TZ", "Танзания");
    namesMap.put("UA", "Украйна");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "Отдалечени острови на САЩ");
    namesMap.put("UN", "Организация на обединените нации");
    namesMap.put("US", "Съединени щати");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сейнт Винсънт и Гренадини");
    namesMap.put("VE", "Венецуела");
    namesMap.put("VG", "Британски Вирджински острови");
    namesMap.put("VI", "Американски Вирджински острови");
    namesMap.put("VN", "Виетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уолис и Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Йемен");
    namesMap.put("YT", "Майот");
    namesMap.put("ZA", "Южна Африка");
    namesMap.put("ZM", "Замбия");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "непознат регион");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Свят",
        "002": "Африка",
        "003": "Северноамерикански континент",
        "005": "Южна Америка",
        "009": "Океания",
        "011": "Западна Афирка",
        "013": "Централна Америка",
        "014": "Източна Африка",
        "015": "Северна Африка",
        "017": "Централна Африка",
        "018": "Южноафрикански регион",
        "019": "Америка",
        "021": "Северна Америка",
        "029": "Карибски регион",
        "030": "Източна Азия",
        "034": "Южна Азия",
        "035": "Югоизточна Азия",
        "039": "Южна Европа",
        "053": "Австралазия",
        "054": "Меланезия",
        "057": "Микронезийски регион",
        "061": "Полинезия",
        "142": "Азия",
        "143": "Централна Азия",
        "145": "Западна Азия",
        "150": "Европа",
        "151": "Източна Европа",
        "154": "Северна Европа",
        "155": "Западна Европа",
        "202": "Субсахарска Африка",
        "419": "Латинска Америка",
        "AC": "остров Възнесение",
        "AD": "Андора",
        "AE": "Обединени арабски емирства",
        "AF": "Афганистан",
        "AG": "Антигуа и Барбуда",
        "AI": "Ангуила",
        "AL": "Албания",
        "AM": "Армения",
        "AO": "Ангола",
        "AQ": "Антарктика",
        "AR": "Аржентина",
        "AS": "Американска Самоа",
        "AT": "Австрия",
        "AU": "Австралия",
        "AW": "Аруба",
        "AX": "Оландски острови",
        "AZ": "Азербайджан",
        "BA": "Босна и Херцеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Белгия",
        "BF": "Буркина Фасо",
        "BG": "България",
        "BH": "Бахрейн",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Сен Бартелеми",
        "BM": "Бермудски острови",
        "BN": "Бруней Даруссалам",
        "BO": "Боливия",
        "BQ": "Карибска Нидерландия",
        "BR": "Бразилия",
        "BS": "Бахамски острови",
        "BT": "Бутан",
        "BV": "остров Буве",
        "BW": "Ботсвана",
        "BY": "Беларус",
        "BZ": "Белиз",
        "CA": "Канада",
        "CC": "Кокосови острови (острови Кийлинг)",
        "CD": "Конго (Киншаса)",
        "CF": "Централноафриканска република",
        "CG": "Конго (Бразавил)",
        "CH": "Швейцария",
        "CI": "Кот д’Ивоар",
        "CK": "острови Кук",
        "CL": "Чили",
        "CM": "Камерун",
        "CN": "Китай",
        "CO": "Колумбия",
        "CP": "остров Клипертон",
        "CR": "Коста Рика",
        "CU": "Куба",
        "CV": "Кабо Верде",
        "CW": "Кюрасао",
        "CX": "остров Рождество",
        "CY": "Кипър",
        "CZ": "Чехия",
        "DE": "Германия",
        "DG": "Диего Гарсия",
        "DJ": "Джибути",
        "DK": "Дания",
        "DM": "Доминика",
        "DO": "Доминиканска република",
        "DZ": "Алжир",
        "EA": "Сеута и Мелия",
        "EC": "Еквадор",
        "EE": "Естония",
        "EG": "Египет",
        "EH": "Западна Сахара",
        "ER": "Еритрея",
        "ES": "Испания",
        "ET": "Етиопия",
        "EU": "Европейски съюз",
        "EZ": "Еврозона",
        "FI": "Финландия",
        "FJ": "Фиджи",
        "FK": "Фолкландски острови",
        "FM": "Микронезия",
        "FO": "Фарьорски острови",
        "FR": "Франция",
        "GA": "Габон",
        "GB": "Обединеното кралство",
        "GD": "Гренада",
        "GE": "Грузия",
        "GF": "Френска Гвиана",
        "GG": "Гърнзи",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренландия",
        "GM": "Гамбия",
        "GN": "Гвинея",
        "GP": "Гваделупа",
        "GQ": "Екваториална Гвинея",
        "GR": "Гърция",
        "GS": "Южна Джорджия и Южни Сандвичеви острови",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гвинея-Бисау",
        "GY": "Гаяна",
        "HK": "Хонконг, САР на Китай",
        "HM": "острови Хърд и Макдоналд",
        "HN": "Хондурас",
        "HR": "Хърватия",
        "HT": "Хаити",
        "HU": "Унгария",
        "IC": "Канарски острови",
        "ID": "Индонезия",
        "IE": "Ирландия",
        "IL": "Израел",
        "IM": "остров Ман",
        "IN": "Индия",
        "IO": "Британска територия в Индийския океан",
        "IQ": "Ирак",
        "IR": "Иран",
        "IS": "Исландия",
        "IT": "Италия",
        "JE": "Джърси",
        "JM": "Ямайка",
        "JO": "Йордания",
        "JP": "Япония",
        "KE": "Кения",
        "KG": "Киргизстан",
        "KH": "Камбоджа",
        "KI": "Кирибати",
        "KM": "Коморски острови",
        "KN": "Сейнт Китс и Невис",
        "KP": "Северна Корея",
        "KR": "Южна Корея",
        "KW": "Кувейт",
        "KY": "Кайманови острови",
        "KZ": "Казахстан",
        "LA": "Лаос",
        "LB": "Ливан",
        "LC": "Сейнт Лусия",
        "LI": "Лихтенщайн",
        "LK": "Шри Ланка",
        "LR": "Либерия",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембург",
        "LV": "Латвия",
        "LY": "Либия",
        "MA": "Мароко",
        "MC": "Монако",
        "MD": "Молдова",
        "ME": "Черна гора",
        "MF": "Сен Мартен",
        "MG": "Мадагаскар",
        "MH": "Маршалови острови",
        "MK": "Македония",
        "ML": "Мали",
        "MM": "Мианмар (Бирма)",
        "MN": "Монголия",
        "MO": "Макао, САР на Китай",
        "MP": "Северни Мариански острови",
        "MQ": "Мартиника",
        "MR": "Мавритания",
        "MS": "Монтсерат",
        "MT": "Малта",
        "MU": "Мавриций",
        "MV": "Малдиви",
        "MW": "Малави",
        "MX": "Мексико",
        "MY": "Малайзия",
        "MZ": "Мозамбик",
        "NA": "Намибия",
        "NC": "Нова Каледония",
        "NE": "Нигер",
        "NF": "остров Норфолк",
        "NG": "Нигерия",
        "NI": "Никарагуа",
        "NL": "Нидерландия",
        "NO": "Норвегия",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ниуе",
        "NZ": "Нова Зеландия",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Френска Полинезия",
        "PG": "Папуа-Нова Гвинея",
        "PH": "Филипини",
        "PK": "Пакистан",
        "PL": "Полша",
        "PM": "Сен Пиер и Микелон",
        "PN": "Острови Питкерн",
        "PR": "Пуерто Рико",
        "PS": "Палестински територии",
        "PT": "Португалия",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Отдалечени острови на Океания",
        "RE": "Реюнион",
        "RO": "Румъния",
        "RS": "Сърбия",
        "RU": "Русия",
        "RW": "Руанда",
        "SA": "Саудитска Арабия",
        "SB": "Соломонови острови",
        "SC": "Сейшели",
        "SD": "Судан",
        "SE": "Швеция",
        "SG": "Сингапур",
        "SH": "Света Елена",
        "SI": "Словения",
        "SJ": "Свалбард и Ян Майен",
        "SK": "Словакия",
        "SL": "Сиера Леоне",
        "SM": "Сан Марино",
        "SN": "Сенегал",
        "SO": "Сомалия",
        "SR": "Суринам",
        "SS": "Южен Судан",
        "ST": "Сао Томе и Принсипи",
        "SV": "Салвадор",
        "SX": "Синт Мартен",
        "SY": "Сирия",
        "SZ": "Свазиленд",
        "TA": "Тристан да Куня",
        "TC": "острови Търкс и Кайкос",
        "TD": "Чад",
        "TF": "Френски южни територии",
        "TG": "Того",
        "TH": "Тайланд",
        "TJ": "Таджикистан",
        "TK": "Токелау",
        "TL": "Източен Тимор",
        "TM": "Туркменистан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Турция",
        "TT": "Тринидад и Тобаго",
        "TV": "Тувалу",
        "TW": "Тайван",
        "TZ": "Танзания",
        "UA": "Украйна",
        "UG": "Уганда",
        "UM": "Отдалечени острови на САЩ",
        "UN": "Организация на обединените нации",
        "US": "Съединени щати",
        "UY": "Уругвай",
        "UZ": "Узбекистан",
        "VA": "Ватикан",
        "VC": "Сейнт Винсънт и Гренадини",
        "VE": "Венецуела",
        "VG": "Британски Вирджински острови",
        "VI": "Американски Вирджински острови",
        "VN": "Виетнам",
        "VU": "Вануату",
        "WF": "Уолис и Футуна",
        "WS": "Самоа",
        "XK": "Косово",
        "YE": "Йемен",
        "YT": "Майот",
        "ZA": "Южна Африка",
        "ZM": "Замбия",
        "ZW": "Зимбабве",
        "ZZ": "непознат регион"
    };
  }-*/;
}
