/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "or" locale.
 */
public class LocalizedNamesImpl_or extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AX",
        "AT",
        "AU",
        "IM",
        "IS",
        "AI",
        "AO",
        "AZ",
        "AQ",
        "AG",
        "AD",
        "AF",
        "AS",
        "AW",
        "AR",
        "AM",
        "DZ",
        "AL",
        "AC",
        "IE",
        "GQ",
        "EC",
        "EG",
        "IT",
        "ID",
        "ET",
        "IQ",
        "IR",
        "ER",
        "IL",
        "UG",
        "UZ",
        "KP",
        "MP",
        "UY",
        "SV",
        "EE",
        "OM",
        "CD",
        "CG",
        "QA",
        "KZ",
        "CA",
        "CM",
        "KH",
        "BQ",
        "KI",
        "KG",
        "KW",
        "CK",
        "CW",
        "KE",
        "IC",
        "CV",
        "KY",
        "CC",
        "CI",
        "KM",
        "CO",
        "CR",
        "XK",
        "HR",
        "CP",
        "CU",
        "CX",
        "GA",
        "GM",
        "GP",
        "GU",
        "GY",
        "GN",
        "GW",
        "GT",
        "GG",
        "GL",
        "GR",
        "GD",
        "GH",
        "TD",
        "CN",
        "CL",
        "CZ",
        "GE",
        "DE",
        "JE",
        "UN",
        "JP",
        "JM",
        "ZM",
        "DJ",
        "GI",
        "ZW",
        "JO",
        "TK",
        "TG",
        "TO",
        "TA",
        "TN",
        "DG",
        "DK",
        "DM",
        "DO",
        "TW",
        "TJ",
        "TZ",
        "TL",
        "TV",
        "TM",
        "TC",
        "TR",
        "TT",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "NF",
        "NO",
        "NE",
        "NG",
        "NR",
        "NA",
        "NU",
        "NI",
        "NC",
        "NL",
        "NP",
        "NZ",
        "PG",
        "PT",
        "EH",
        "PK",
        "PA",
        "PY",
        "PW",
        "PS",
        "PN",
        "PR",
        "PE",
        "PL",
        "FK",
        "TF",
        "FO",
        "FJ",
        "FI",
        "PH",
        "FR",
        "GF",
        "PF",
        "BM",
        "BD",
        "BB",
        "BS",
        "BH",
        "BI",
        "BF",
        "BG",
        "BJ",
        "BE",
        "BY",
        "BZ",
        "BW",
        "BO",
        "BA",
        "BV",
        "BR",
        "VG",
        "IO",
        "BN",
        "VA",
        "VU",
        "IN",
        "VN",
        "BT",
        "VE",
        "MN",
        "ME",
        "MS",
        "CF",
        "MU",
        "FM",
        "MO",
        "MG",
        "MQ",
        "MH",
        "MV",
        "ML",
        "MY",
        "MT",
        "MW",
        "MK",
        "YT",
        "MM",
        "MX",
        "MZ",
        "MC",
        "MA",
        "MD",
        "MR",
        "GB",
        "US",
        "UM",
        "VI",
        "RW",
        "RE",
        "RU",
        "RO",
        "LU",
        "LR",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "LK",
        "AE",
        "RS",
        "CY",
        "SA",
        "ST",
        "SM",
        "WS",
        "SJ",
        "EA",
        "SL",
        "SG",
        "SX",
        "SY",
        "QO",
        "SD",
        "SR",
        "SC",
        "KN",
        "PM",
        "BL",
        "VC",
        "MF",
        "LC",
        "SH",
        "SN",
        "SO",
        "SB",
        "ES",
        "SK",
        "SI",
        "SZ",
        "CH",
        "SE",
        "HK",
        "HU",
        "HT",
        "HM",
        "HN",
        "UA",
        "EZ",
        "EU",
        "YE",
        "WF",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ବିଶ୍ୱ");
    namesMap.put("002", "ଆଫ୍ରିକା");
    namesMap.put("003", "ଉତ୍ତର ଆମେରିକା");
    namesMap.put("005", "ଦକ୍ଷିଣ ଆମେରିକା");
    namesMap.put("009", "ଓସିନିଆ");
    namesMap.put("011", "ପଶ୍ଚିମ ଆଫ୍ରିକା");
    namesMap.put("013", "ମଧ୍ୟ ଆମେରିକା");
    namesMap.put("014", "ପୂର୍ବ ଆଫ୍ରିକା");
    namesMap.put("015", "ଉତ୍ତର ଆଫ୍ରିକା");
    namesMap.put("017", "ମଧ୍ୟ ଆଫ୍ରିକା");
    namesMap.put("018", "ଦକ୍ଷିଣସ୍ଥ ଆଫ୍ରିକା");
    namesMap.put("019", "ଆମେରିକା");
    namesMap.put("021", "ଉତ୍ତରସ୍ଥ ଆମେରିକା");
    namesMap.put("029", "କାରିବିଆନ୍");
    namesMap.put("030", "ପୂର୍ବ ଏସିଆ");
    namesMap.put("034", "ଦକ୍ଷିଣ ଏସିଆ");
    namesMap.put("035", "ଦକ୍ଷିଣପୂର୍ବ ଏସିଆ");
    namesMap.put("039", "ଦକ୍ଷିଣ ୟୁରୋପ୍");
    namesMap.put("053", "ଅଷ୍ଟ୍ରେଲେସିଆ");
    namesMap.put("054", "ମେଲାନେସିଆ");
    namesMap.put("057", "ମାଇକ୍ରୋନେସିଆନ୍ ଅଞ୍ଚଳ");
    namesMap.put("061", "ପଲିନେସିଆ");
    namesMap.put("142", "ଏସିଆ");
    namesMap.put("143", "ମଧ୍ୟ ଏସିଆ");
    namesMap.put("145", "ପଶ୍ଚିମ ଏସିଆ");
    namesMap.put("150", "ୟୁରୋପ୍");
    namesMap.put("151", "ପୂର୍ବ ୟୁରୋପ୍");
    namesMap.put("154", "ଉତ୍ତର ୟୁରୋପ୍");
    namesMap.put("155", "ପଶ୍ଚିମ ୟୁରୋପ୍");
    namesMap.put("202", "ଉପ-ସାହାରା ଆଫ୍ରିକା");
    namesMap.put("419", "ଲାଟିନ୍‌ ଆମେରିକା");
    namesMap.put("AC", "ଆସେନସିଅନ୍‌ ଦ୍ୱୀପ");
    namesMap.put("AD", "ଆଣ୍ଡୋରା");
    namesMap.put("AE", "ସଂଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍");
    namesMap.put("AF", "ଆଫଗାନିସ୍ତାନ୍");
    namesMap.put("AG", "ଆଣ୍ଟିଗୁଆ ଏବଂ ବାରବୁଦା");
    namesMap.put("AI", "ଆଙ୍ଗୁଇଲ୍ଲା");
    namesMap.put("AL", "ଆଲବାନିଆ");
    namesMap.put("AM", "ଆର୍ମେନିଆ");
    namesMap.put("AO", "ଆଙ୍ଗୋଲା");
    namesMap.put("AQ", "ଆଣ୍ଟାର୍କାଟିକା");
    namesMap.put("AR", "ଆର୍ଜେଣ୍ଟିନା");
    namesMap.put("AS", "ଆମେରିକାନ୍ ସାମୋଆ");
    namesMap.put("AT", "ଅଷ୍ଟ୍ରିଆ");
    namesMap.put("AU", "ଅଷ୍ଟ୍ରେଲିଆ");
    namesMap.put("AW", "ଆରୁବା");
    namesMap.put("AX", "ଅଲାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ");
    namesMap.put("AZ", "ଆଜେରବାଇଜାନ୍");
    namesMap.put("BA", "ବୋସନିଆ ଏବଂ ହର୍ଜଗୋଭିନା");
    namesMap.put("BB", "ବାରବାଡୋସ୍");
    namesMap.put("BD", "ବାଂଲାଦେଶ");
    namesMap.put("BE", "ବେଲଜିୟମ୍");
    namesMap.put("BF", "ବୁର୍କିନା ଫାସୋ");
    namesMap.put("BG", "ବୁଲଗେରିଆ");
    namesMap.put("BH", "ବାହାରିନ୍");
    namesMap.put("BI", "ବୁରୁଣ୍ଡି");
    namesMap.put("BJ", "ବେନିନ୍");
    namesMap.put("BL", "ସେଣ୍ଟ ବାର୍ଥେଲେମି");
    namesMap.put("BM", "ବର୍ମୁଡା");
    namesMap.put("BN", "ବ୍ରୁନେଇ");
    namesMap.put("BO", "ବୋଲଭିଆ");
    namesMap.put("BQ", "କାରବିୟନ୍‌ ନେଦରଲ୍ୟାଣ୍ଡ");
    namesMap.put("BR", "ବ୍ରାଜିଲ୍");
    namesMap.put("BS", "ବାହାମାସ୍");
    namesMap.put("BT", "ଭୁଟାନ");
    namesMap.put("BV", "ବୌଭେଟ୍‌ ଦ୍ୱୀପ");
    namesMap.put("BW", "ବୋଟସ୍ୱାନା");
    namesMap.put("BY", "ବେଲାରୁଷ୍");
    namesMap.put("BZ", "ବେଲିଜ୍");
    namesMap.put("CA", "କାନାଡା");
    namesMap.put("CC", "କୋକୋସ୍ (କୀଲିଂ) ଦ୍ଵୀପପୁଞ୍ଜ");
    namesMap.put("CD", "କଙ୍ଗୋ-କିନସାସା");
    namesMap.put("CF", "ମଧ୍ୟ ଆଫ୍ରିକୀୟ ସାଧାରଣତନ୍ତ୍ର");
    namesMap.put("CG", "କଙ୍ଗୋ-ବ୍ରାଜିଭିଲ୍ଲେ");
    namesMap.put("CH", "ସ୍ୱିଜରଲ୍ୟାଣ୍ଡ");
    namesMap.put("CI", "କୋତ୍ ଡି ଭ୍ଵାର୍");
    namesMap.put("CK", "କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("CL", "ଚିଲ୍ଲୀ");
    namesMap.put("CM", "କାମେରୁନ୍");
    namesMap.put("CN", "ଚିନ୍");
    namesMap.put("CO", "କୋଲମ୍ବିଆ");
    namesMap.put("CP", "କ୍ଲିପରଟନ୍‌ ଦ୍ୱୀପ");
    namesMap.put("CR", "କୋଷ୍ଟା ରିକା");
    namesMap.put("CU", "କ୍ୱିବା");
    namesMap.put("CV", "କେପ୍ ଭର୍ଦେ");
    namesMap.put("CW", "କୁରାକାଓ");
    namesMap.put("CX", "ଖ୍ରୀଷ୍ଟମାସ ଦ୍ୱୀପ");
    namesMap.put("CY", "ସାଇପ୍ରସ୍");
    namesMap.put("CZ", "ଚେଚିଆ");
    namesMap.put("DE", "ଜର୍ମାନୀ");
    namesMap.put("DG", "ଡିଏଗୋ ଗାର୍ସିଆ");
    namesMap.put("DJ", "ଜିବୋଟି");
    namesMap.put("DK", "ଡେନମାର୍କ");
    namesMap.put("DM", "ଡୋମିନିକା");
    namesMap.put("DO", "ଡୋମିନିକାନ୍‌ ସାଧାରଣତନ୍ତ୍ର");
    namesMap.put("DZ", "ଆଲଜେରିଆ");
    namesMap.put("EA", "ସିଉଟା ଏବଂ ମେଲିଲା");
    namesMap.put("EC", "ଇକ୍ୱାଡୋର୍");
    namesMap.put("EE", "ଏସ୍ତୋନିଆ");
    namesMap.put("EG", "ଇଜିପ୍ଟ");
    namesMap.put("EH", "ପଶ୍ଚିମ ସାହାରା");
    namesMap.put("ER", "ଇରିଟ୍ରିୟା");
    namesMap.put("ES", "ସ୍ପେନ୍");
    namesMap.put("ET", "ଇଥିଓପିଆ");
    namesMap.put("EU", "ୟୁରୋପୀୟ ସଂଘ");
    namesMap.put("EZ", "ୟୁରୋକ୍ଷେତ୍ର");
    namesMap.put("FI", "ଫିନଲ୍ୟାଣ୍ଡ");
    namesMap.put("FJ", "ଫିଜି");
    namesMap.put("FK", "ଫକ୍‌ଲ୍ୟାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ");
    namesMap.put("FM", "ମାଇକ୍ରୋନେସିଆ");
    namesMap.put("FO", "ଫାରୋଇ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("FR", "ଫ୍ରାନ୍ସ");
    namesMap.put("GA", "ଗାବୋନ୍");
    namesMap.put("GB", "ଯୁକ୍ତରାଜ୍ୟ");
    namesMap.put("GD", "ଗ୍ରେନାଡା");
    namesMap.put("GE", "ଜର୍ଜିଆ");
    namesMap.put("GF", "ଫ୍ରେଞ୍ଚ ଗୁଇନା");
    namesMap.put("GG", "ଗୁଏରନେସି");
    namesMap.put("GH", "ଘାନା");
    namesMap.put("GI", "ଜିବ୍ରାଲ୍ଟର୍");
    namesMap.put("GL", "ଗ୍ରୀନଲ୍ୟାଣ୍ଡ");
    namesMap.put("GM", "ଗାମ୍ବିଆ");
    namesMap.put("GN", "ଗୁଇନିଆ");
    namesMap.put("GP", "ଗୁଆଡେଲୋପ୍");
    namesMap.put("GQ", "ଇକ୍ବାଟେରିଆଲ୍ ଗୁଇନିଆ");
    namesMap.put("GR", "ଗ୍ରୀସ୍");
    namesMap.put("GS", "ଦକ୍ଷିଣ ଜର୍ଜିଆ ଏବଂ ଦକ୍ଷିଣ ସାଣ୍ଡୱିଚ୍ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("GT", "ଗୁଏତମାଲା");
    namesMap.put("GU", "ଗୁଆମ୍");
    namesMap.put("GW", "ଗୁଇନିଆ-ବିସାଉ");
    namesMap.put("GY", "ଗୁଇନା");
    namesMap.put("HK", "ହଂ କଂ ଏସଏଆର୍‌ ଚାଇନା");
    namesMap.put("HM", "ହାର୍ଡ୍‌ ଏବଂ ମ୍ୟାକଡୋନାଲ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("HN", "ହୋଣ୍ଡୁରାସ୍‌");
    namesMap.put("HR", "କ୍ରୋଏସିଆ");
    namesMap.put("HT", "ହାଇତି");
    namesMap.put("HU", "ହଙ୍ଗେରୀ");
    namesMap.put("IC", "କେନେରୀ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("ID", "ଇଣ୍ଡୋନେସିଆ");
    namesMap.put("IE", "ଆୟରଲ୍ୟାଣ୍ଡ");
    namesMap.put("IL", "ଇସ୍ରାଏଲ୍");
    namesMap.put("IM", "ଆଇଲ୍‌ ଅଫ୍‌ ମ୍ୟାନ୍‌");
    namesMap.put("IN", "ଭାରତ");
    namesMap.put("IO", "ବ୍ରିଟିଶ୍‌ ଭାରତ ମାହାସାଗର କ୍ଷେତ୍ର");
    namesMap.put("IQ", "ଇରାକ୍");
    namesMap.put("IR", "ଇରାନ");
    namesMap.put("IS", "ଆଇସଲ୍ୟାଣ୍ଡ");
    namesMap.put("IT", "ଇଟାଲୀ");
    namesMap.put("JE", "ଜର୍ସି");
    namesMap.put("JM", "ଜାମାଇକା");
    namesMap.put("JO", "ଜୋର୍ଡାନ୍");
    namesMap.put("JP", "ଜାପାନ");
    namesMap.put("KE", "କେନିୟା");
    namesMap.put("KG", "କିର୍ଗିଜିସ୍ତାନ");
    namesMap.put("KH", "କାମ୍ବୋଡିଆ");
    namesMap.put("KI", "କିରିବାଟି");
    namesMap.put("KM", "କୋମୋରସ୍");
    namesMap.put("KN", "ସେଣ୍ଟ କିଟସ୍‌ ଏବଂ ନେଭିସ୍‌");
    namesMap.put("KP", "ଉତ୍ତର କୋରିଆ");
    namesMap.put("KR", "ଦକ୍ଷିଣ କୋରିଆ");
    namesMap.put("KW", "କୁଏତ୍");
    namesMap.put("KY", "କେମ୍ୟାନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("KZ", "କାଜାକାସ୍ତାନ");
    namesMap.put("LA", "ଲାଓସ୍");
    namesMap.put("LB", "ଲେବାନନ୍");
    namesMap.put("LC", "ସେଣ୍ଟ ଲୁସିଆ");
    namesMap.put("LI", "ଲିଚେଟନଷ୍ଟେଇନ୍");
    namesMap.put("LK", "ଶ୍ରୀଲଙ୍କା");
    namesMap.put("LR", "ଲାଇବେରିଆ");
    namesMap.put("LS", "ଲେସୋଥୋ");
    namesMap.put("LT", "ଲିଥୁଆନିଆ");
    namesMap.put("LU", "ଲକ୍ସେମବର୍ଗ");
    namesMap.put("LV", "ଲାଟଭିଆ");
    namesMap.put("LY", "ଲିବ୍ୟା");
    namesMap.put("MA", "ମୋରୋକ୍କୋ");
    namesMap.put("MC", "ମୋନାକୋ");
    namesMap.put("MD", "ମୋଲଡୋଭା");
    namesMap.put("ME", "ମଣ୍ଟେନିଗ୍ରୋ");
    namesMap.put("MF", "ସେଣ୍ଟ ମାର୍ଟିନ୍");
    namesMap.put("MG", "ମାଡାଗାସ୍କର୍");
    namesMap.put("MH", "ମାର୍ଶାଲ୍ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("MK", "ମାସେଡୋନିଆ");
    namesMap.put("ML", "ମାଲି");
    namesMap.put("MM", "ମିଆଁମାର");
    namesMap.put("MN", "ମଙ୍ଗୋଲିଆ");
    namesMap.put("MO", "ମାକାଉ ଏସଏଆର୍‌ ଚାଇନା");
    namesMap.put("MP", "ଉତ୍ତର ମାରିଆନା ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("MQ", "ମାର୍ଟିନିକ୍ୟୁ");
    namesMap.put("MR", "ମୌରିଟାନିଆ");
    namesMap.put("MS", "ମଣ୍ଟେସେରାଟ୍");
    namesMap.put("MT", "ମାଲ୍ଟା");
    namesMap.put("MU", "ମରିସସ");
    namesMap.put("MV", "ମାଲଦିଭସ୍‌");
    namesMap.put("MW", "ମାଲୱି");
    namesMap.put("MX", "ମେକ୍ସିକୋ");
    namesMap.put("MY", "ମାଲେସିଆ");
    namesMap.put("MZ", "ମୋଜାମ୍ବିକ୍‌");
    namesMap.put("NA", "ନାମିବିଆ");
    namesMap.put("NC", "ନୂତନ କାଲେଡୋନିଆ");
    namesMap.put("NE", "ନାଇଜର");
    namesMap.put("NF", "ନର୍ଫକ୍ ଦ୍ଵୀପ");
    namesMap.put("NG", "ନାଇଜେରିଆ");
    namesMap.put("NI", "ନିକାରାଗୁଆ");
    namesMap.put("NL", "ନେଦରଲ୍ୟାଣ୍ଡ");
    namesMap.put("NO", "ନରୱେ");
    namesMap.put("NP", "ନେପାଳ");
    namesMap.put("NR", "ନାଉରୁ");
    namesMap.put("NU", "ନିଉ");
    namesMap.put("NZ", "ନ୍ୟୁଜିଲାଣ୍ଡ");
    namesMap.put("OM", "ଓମାନ୍");
    namesMap.put("PA", "ପାନାମା");
    namesMap.put("PE", "ପେରୁ");
    namesMap.put("PF", "ଫ୍ରେଞ୍ଚ ପଲିନେସିଆ");
    namesMap.put("PG", "ପପୁଆ ନ୍ୟୁ ଗୁଏନିଆ");
    namesMap.put("PH", "ଫିଲିପାଇନସ୍");
    namesMap.put("PK", "ପାକିସ୍ତାନ");
    namesMap.put("PL", "ପୋଲାଣ୍ଡ");
    namesMap.put("PM", "ସେଣ୍ଟ ପିଏରେ ଏବଂ ମିକ୍ୱେଲନ୍‌");
    namesMap.put("PN", "ପିଟକାଇରିନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("PR", "ପୁଏର୍ତ୍ତୋ ରିକୋ");
    namesMap.put("PS", "ପାଲେଷ୍ଟେନିୟ ଭୂଭାଗ");
    namesMap.put("PT", "ପର୍ତ୍ତୁଗାଲ୍");
    namesMap.put("PW", "ପାଲାଉ");
    namesMap.put("PY", "ପାରାଗୁଏ");
    namesMap.put("QA", "କତାର୍");
    namesMap.put("QO", "ସୀମାନ୍ତବର୍ତ୍ତୀ ଓସିନିଆ");
    namesMap.put("RE", "ରିୟୁନିଅନ୍");
    namesMap.put("RO", "ରୋମାନିଆ");
    namesMap.put("RS", "ସର୍ବିଆ");
    namesMap.put("RU", "ରୁଷିଆ");
    namesMap.put("RW", "ରାୱାଣ୍ଡା");
    namesMap.put("SA", "ସାଉଦି ଆରବିଆ");
    namesMap.put("SB", "ସୋଲୋମନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("SC", "ସେଚେଲସ୍");
    namesMap.put("SD", "ସୁଦାନ");
    namesMap.put("SE", "ସ୍ୱେଡେନ୍");
    namesMap.put("SG", "ସିଙ୍ଗାପୁର୍");
    namesMap.put("SH", "ସେଣ୍ଟ ହେଲେନା");
    namesMap.put("SI", "ସ୍ଲୋଭେନିଆ");
    namesMap.put("SJ", "ସାଲବାର୍ଡ ଏବଂ ଜାନ୍‌ ମାୟେନ୍‌");
    namesMap.put("SK", "ସ୍ଲୋଭାକିଆ");
    namesMap.put("SL", "ସିଏରା ଲିଓନ");
    namesMap.put("SM", "ସାନ୍ ମାରିନୋ");
    namesMap.put("SN", "ସେନେଗାଲ୍");
    namesMap.put("SO", "ସୋମାଲିଆ");
    namesMap.put("SR", "ସୁରିନାମ");
    namesMap.put("SS", "ଦକ୍ଷିଣ ସୁଦାନ");
    namesMap.put("ST", "ସାଓ ଟୋମେ ଏବଂ ପ୍ରିନସିପି");
    namesMap.put("SV", "ଏଲ୍ ସାଲଭାଡୋର୍");
    namesMap.put("SX", "ସିଣ୍ଟ ମାର୍ଟୀନ୍‌");
    namesMap.put("SY", "ସିରିଆ");
    namesMap.put("SZ", "ସ୍ୱାଜିଲ୍ୟାଣ୍ଡ");
    namesMap.put("TA", "ଟ୍ରାଇଷ୍ଟନ୍‌ ଦା କୁନ୍‌ଚା");
    namesMap.put("TC", "ତୁର୍କସ୍‌ ଏବଂ କାଇକୋସ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("TD", "ଚାଦ୍");
    namesMap.put("TF", "ଫରାସୀ ଦକ୍ଷିଣ କ୍ଷେତ୍ର");
    namesMap.put("TG", "ଟୋଗୋ");
    namesMap.put("TH", "ଥାଇଲ୍ୟାଣ୍ଡ");
    namesMap.put("TJ", "ତାଜିକିସ୍ଥାନ୍");
    namesMap.put("TK", "ଟୋକେଲାଉ");
    namesMap.put("TL", "ତିମୋର୍-ଲେଷ୍ଟେ");
    namesMap.put("TM", "ତୁର୍କମେନିସ୍ତାନ");
    namesMap.put("TN", "ଟ୍ୟୁନିସିଆ");
    namesMap.put("TO", "ଟୋଙ୍ଗା");
    namesMap.put("TR", "ତୁର୍କୀ");
    namesMap.put("TT", "ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ");
    namesMap.put("TV", "ତୁଭାଲୁ");
    namesMap.put("TW", "ତାଇୱାନ");
    namesMap.put("TZ", "ତାଞ୍ଜାନିଆ");
    namesMap.put("UA", "ୟୁକ୍ରେନ୍");
    namesMap.put("UG", "ଉଗାଣ୍ଡା");
    namesMap.put("UM", "ଯୁକ୍ତରାଷ୍ଟ୍ର ଆଉଟ୍‌ଲାଇଙ୍ଗ ଦ୍ଵୀପପୁଞ୍ଜ");
    namesMap.put("UN", "ଜାତିସଂଘ");
    namesMap.put("US", "ଯୁକ୍ତ ରାଷ୍ଟ୍ର");
    namesMap.put("UY", "ଉରୁଗୁଏ");
    namesMap.put("UZ", "ଉଜବେକିସ୍ତାନ");
    namesMap.put("VA", "ଭାଟିକାନ୍ ସିଟି");
    namesMap.put("VC", "ସେଣ୍ଟ ଭିନସେଣ୍ଟ ଏବଂ ଦି ଗ୍ରେନାଡିସ୍");
    namesMap.put("VE", "ଭେନେଜୁଏଲା");
    namesMap.put("VG", "ବ୍ରିଟିଶ୍‌ ଭର୍ଜିନ୍ ଦ୍ୱୀପପୁଞ୍ଜ");
    namesMap.put("VI", "ଯୁକ୍ତରାଷ୍ଟ୍ର ଭିର୍ଜିନ୍ ଦ୍ଵୀପପୁଞ୍ଜ");
    namesMap.put("VN", "ଭିଏତନାମ୍");
    namesMap.put("VU", "ଭାନୁଆତୁ");
    namesMap.put("WF", "ୱାଲିସ୍ ଏବଂ ଫୁତୁନା");
    namesMap.put("WS", "ସାମୋଆ");
    namesMap.put("XK", "କୋସୋଭୋ");
    namesMap.put("YE", "ୟେମେନ୍");
    namesMap.put("YT", "ମାୟୋଟେ");
    namesMap.put("ZA", "ଦକ୍ଷିଣ ଆଫ୍ରିକା");
    namesMap.put("ZM", "ଜାମ୍ବିଆ");
    namesMap.put("ZW", "ଜିମ୍ବାୱେ");
    namesMap.put("ZZ", "ଅଜଣା ଅଞ୍ଚଳ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ବିଶ୍ୱ",
        "002": "ଆଫ୍ରିକା",
        "003": "ଉତ୍ତର ଆମେରିକା",
        "005": "ଦକ୍ଷିଣ ଆମେରିକା",
        "009": "ଓସିନିଆ",
        "011": "ପଶ୍ଚିମ ଆଫ୍ରିକା",
        "013": "ମଧ୍ୟ ଆମେରିକା",
        "014": "ପୂର୍ବ ଆଫ୍ରିକା",
        "015": "ଉତ୍ତର ଆଫ୍ରିକା",
        "017": "ମଧ୍ୟ ଆଫ୍ରିକା",
        "018": "ଦକ୍ଷିଣସ୍ଥ ଆଫ୍ରିକା",
        "019": "ଆମେରିକା",
        "021": "ଉତ୍ତରସ୍ଥ ଆମେରିକା",
        "029": "କାରିବିଆନ୍",
        "030": "ପୂର୍ବ ଏସିଆ",
        "034": "ଦକ୍ଷିଣ ଏସିଆ",
        "035": "ଦକ୍ଷିଣପୂର୍ବ ଏସିଆ",
        "039": "ଦକ୍ଷିଣ ୟୁରୋପ୍",
        "053": "ଅଷ୍ଟ୍ରେଲେସିଆ",
        "054": "ମେଲାନେସିଆ",
        "057": "ମାଇକ୍ରୋନେସିଆନ୍ ଅଞ୍ଚଳ",
        "061": "ପଲିନେସିଆ",
        "142": "ଏସିଆ",
        "143": "ମଧ୍ୟ ଏସିଆ",
        "145": "ପଶ୍ଚିମ ଏସିଆ",
        "150": "ୟୁରୋପ୍",
        "151": "ପୂର୍ବ ୟୁରୋପ୍",
        "154": "ଉତ୍ତର ୟୁରୋପ୍",
        "155": "ପଶ୍ଚିମ ୟୁରୋପ୍",
        "202": "ଉପ-ସାହାରା ଆଫ୍ରିକା",
        "419": "ଲାଟିନ୍‌ ଆମେରିକା",
        "AC": "ଆସେନସିଅନ୍‌ ଦ୍ୱୀପ",
        "AD": "ଆଣ୍ଡୋରା",
        "AE": "ସଂଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍",
        "AF": "ଆଫଗାନିସ୍ତାନ୍",
        "AG": "ଆଣ୍ଟିଗୁଆ ଏବଂ ବାରବୁଦା",
        "AI": "ଆଙ୍ଗୁଇଲ୍ଲା",
        "AL": "ଆଲବାନିଆ",
        "AM": "ଆର୍ମେନିଆ",
        "AO": "ଆଙ୍ଗୋଲା",
        "AQ": "ଆଣ୍ଟାର୍କାଟିକା",
        "AR": "ଆର୍ଜେଣ୍ଟିନା",
        "AS": "ଆମେରିକାନ୍ ସାମୋଆ",
        "AT": "ଅଷ୍ଟ୍ରିଆ",
        "AU": "ଅଷ୍ଟ୍ରେଲିଆ",
        "AW": "ଆରୁବା",
        "AX": "ଅଲାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ",
        "AZ": "ଆଜେରବାଇଜାନ୍",
        "BA": "ବୋସନିଆ ଏବଂ ହର୍ଜଗୋଭିନା",
        "BB": "ବାରବାଡୋସ୍",
        "BD": "ବାଂଲାଦେଶ",
        "BE": "ବେଲଜିୟମ୍",
        "BF": "ବୁର୍କିନା ଫାସୋ",
        "BG": "ବୁଲଗେରିଆ",
        "BH": "ବାହାରିନ୍",
        "BI": "ବୁରୁଣ୍ଡି",
        "BJ": "ବେନିନ୍",
        "BL": "ସେଣ୍ଟ ବାର୍ଥେଲେମି",
        "BM": "ବର୍ମୁଡା",
        "BN": "ବ୍ରୁନେଇ",
        "BO": "ବୋଲଭିଆ",
        "BQ": "କାରବିୟନ୍‌ ନେଦରଲ୍ୟାଣ୍ଡ",
        "BR": "ବ୍ରାଜିଲ୍",
        "BS": "ବାହାମାସ୍",
        "BT": "ଭୁଟାନ",
        "BV": "ବୌଭେଟ୍‌ ଦ୍ୱୀପ",
        "BW": "ବୋଟସ୍ୱାନା",
        "BY": "ବେଲାରୁଷ୍",
        "BZ": "ବେଲିଜ୍",
        "CA": "କାନାଡା",
        "CC": "କୋକୋସ୍ (କୀଲିଂ) ଦ୍ଵୀପପୁଞ୍ଜ",
        "CD": "କଙ୍ଗୋ-କିନସାସା",
        "CF": "ମଧ୍ୟ ଆଫ୍ରିକୀୟ ସାଧାରଣତନ୍ତ୍ର",
        "CG": "କଙ୍ଗୋ-ବ୍ରାଜିଭିଲ୍ଲେ",
        "CH": "ସ୍ୱିଜରଲ୍ୟାଣ୍ଡ",
        "CI": "କୋତ୍ ଡି ଭ୍ଵାର୍",
        "CK": "କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ",
        "CL": "ଚିଲ୍ଲୀ",
        "CM": "କାମେରୁନ୍",
        "CN": "ଚିନ୍",
        "CO": "କୋଲମ୍ବିଆ",
        "CP": "କ୍ଲିପରଟନ୍‌ ଦ୍ୱୀପ",
        "CR": "କୋଷ୍ଟା ରିକା",
        "CU": "କ୍ୱିବା",
        "CV": "କେପ୍ ଭର୍ଦେ",
        "CW": "କୁରାକାଓ",
        "CX": "ଖ୍ରୀଷ୍ଟମାସ ଦ୍ୱୀପ",
        "CY": "ସାଇପ୍ରସ୍",
        "CZ": "ଚେଚିଆ",
        "DE": "ଜର୍ମାନୀ",
        "DG": "ଡିଏଗୋ ଗାର୍ସିଆ",
        "DJ": "ଜିବୋଟି",
        "DK": "ଡେନମାର୍କ",
        "DM": "ଡୋମିନିକା",
        "DO": "ଡୋମିନିକାନ୍‌ ସାଧାରଣତନ୍ତ୍ର",
        "DZ": "ଆଲଜେରିଆ",
        "EA": "ସିଉଟା ଏବଂ ମେଲିଲା",
        "EC": "ଇକ୍ୱାଡୋର୍",
        "EE": "ଏସ୍ତୋନିଆ",
        "EG": "ଇଜିପ୍ଟ",
        "EH": "ପଶ୍ଚିମ ସାହାରା",
        "ER": "ଇରିଟ୍ରିୟା",
        "ES": "ସ୍ପେନ୍",
        "ET": "ଇଥିଓପିଆ",
        "EU": "ୟୁରୋପୀୟ ସଂଘ",
        "EZ": "ୟୁରୋକ୍ଷେତ୍ର",
        "FI": "ଫିନଲ୍ୟାଣ୍ଡ",
        "FJ": "ଫିଜି",
        "FK": "ଫକ୍‌ଲ୍ୟାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ",
        "FM": "ମାଇକ୍ରୋନେସିଆ",
        "FO": "ଫାରୋଇ ଦ୍ୱୀପପୁଞ୍ଜ",
        "FR": "ଫ୍ରାନ୍ସ",
        "GA": "ଗାବୋନ୍",
        "GB": "ଯୁକ୍ତରାଜ୍ୟ",
        "GD": "ଗ୍ରେନାଡା",
        "GE": "ଜର୍ଜିଆ",
        "GF": "ଫ୍ରେଞ୍ଚ ଗୁଇନା",
        "GG": "ଗୁଏରନେସି",
        "GH": "ଘାନା",
        "GI": "ଜିବ୍ରାଲ୍ଟର୍",
        "GL": "ଗ୍ରୀନଲ୍ୟାଣ୍ଡ",
        "GM": "ଗାମ୍ବିଆ",
        "GN": "ଗୁଇନିଆ",
        "GP": "ଗୁଆଡେଲୋପ୍",
        "GQ": "ଇକ୍ବାଟେରିଆଲ୍ ଗୁଇନିଆ",
        "GR": "ଗ୍ରୀସ୍",
        "GS": "ଦକ୍ଷିଣ ଜର୍ଜିଆ ଏବଂ ଦକ୍ଷିଣ ସାଣ୍ଡୱିଚ୍ ଦ୍ୱୀପପୁଞ୍ଜ",
        "GT": "ଗୁଏତମାଲା",
        "GU": "ଗୁଆମ୍",
        "GW": "ଗୁଇନିଆ-ବିସାଉ",
        "GY": "ଗୁଇନା",
        "HK": "ହଂ କଂ ଏସଏଆର୍‌ ଚାଇନା",
        "HM": "ହାର୍ଡ୍‌ ଏବଂ ମ୍ୟାକଡୋନାଲ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ",
        "HN": "ହୋଣ୍ଡୁରାସ୍‌",
        "HR": "କ୍ରୋଏସିଆ",
        "HT": "ହାଇତି",
        "HU": "ହଙ୍ଗେରୀ",
        "IC": "କେନେରୀ ଦ୍ୱୀପପୁଞ୍ଜ",
        "ID": "ଇଣ୍ଡୋନେସିଆ",
        "IE": "ଆୟରଲ୍ୟାଣ୍ଡ",
        "IL": "ଇସ୍ରାଏଲ୍",
        "IM": "ଆଇଲ୍‌ ଅଫ୍‌ ମ୍ୟାନ୍‌",
        "IN": "ଭାରତ",
        "IO": "ବ୍ରିଟିଶ୍‌ ଭାରତ ମାହାସାଗର କ୍ଷେତ୍ର",
        "IQ": "ଇରାକ୍",
        "IR": "ଇରାନ",
        "IS": "ଆଇସଲ୍ୟାଣ୍ଡ",
        "IT": "ଇଟାଲୀ",
        "JE": "ଜର୍ସି",
        "JM": "ଜାମାଇକା",
        "JO": "ଜୋର୍ଡାନ୍",
        "JP": "ଜାପାନ",
        "KE": "କେନିୟା",
        "KG": "କିର୍ଗିଜିସ୍ତାନ",
        "KH": "କାମ୍ବୋଡିଆ",
        "KI": "କିରିବାଟି",
        "KM": "କୋମୋରସ୍",
        "KN": "ସେଣ୍ଟ କିଟସ୍‌ ଏବଂ ନେଭିସ୍‌",
        "KP": "ଉତ୍ତର କୋରିଆ",
        "KR": "ଦକ୍ଷିଣ କୋରିଆ",
        "KW": "କୁଏତ୍",
        "KY": "କେମ୍ୟାନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ",
        "KZ": "କାଜାକାସ୍ତାନ",
        "LA": "ଲାଓସ୍",
        "LB": "ଲେବାନନ୍",
        "LC": "ସେଣ୍ଟ ଲୁସିଆ",
        "LI": "ଲିଚେଟନଷ୍ଟେଇନ୍",
        "LK": "ଶ୍ରୀଲଙ୍କା",
        "LR": "ଲାଇବେରିଆ",
        "LS": "ଲେସୋଥୋ",
        "LT": "ଲିଥୁଆନିଆ",
        "LU": "ଲକ୍ସେମବର୍ଗ",
        "LV": "ଲାଟଭିଆ",
        "LY": "ଲିବ୍ୟା",
        "MA": "ମୋରୋକ୍କୋ",
        "MC": "ମୋନାକୋ",
        "MD": "ମୋଲଡୋଭା",
        "ME": "ମଣ୍ଟେନିଗ୍ରୋ",
        "MF": "ସେଣ୍ଟ ମାର୍ଟିନ୍",
        "MG": "ମାଡାଗାସ୍କର୍",
        "MH": "ମାର୍ଶାଲ୍ ଦ୍ୱୀପପୁଞ୍ଜ",
        "MK": "ମାସେଡୋନିଆ",
        "ML": "ମାଲି",
        "MM": "ମିଆଁମାର",
        "MN": "ମଙ୍ଗୋଲିଆ",
        "MO": "ମାକାଉ ଏସଏଆର୍‌ ଚାଇନା",
        "MP": "ଉତ୍ତର ମାରିଆନା ଦ୍ୱୀପପୁଞ୍ଜ",
        "MQ": "ମାର୍ଟିନିକ୍ୟୁ",
        "MR": "ମୌରିଟାନିଆ",
        "MS": "ମଣ୍ଟେସେରାଟ୍",
        "MT": "ମାଲ୍ଟା",
        "MU": "ମରିସସ",
        "MV": "ମାଲଦିଭସ୍‌",
        "MW": "ମାଲୱି",
        "MX": "ମେକ୍ସିକୋ",
        "MY": "ମାଲେସିଆ",
        "MZ": "ମୋଜାମ୍ବିକ୍‌",
        "NA": "ନାମିବିଆ",
        "NC": "ନୂତନ କାଲେଡୋନିଆ",
        "NE": "ନାଇଜର",
        "NF": "ନର୍ଫକ୍ ଦ୍ଵୀପ",
        "NG": "ନାଇଜେରିଆ",
        "NI": "ନିକାରାଗୁଆ",
        "NL": "ନେଦରଲ୍ୟାଣ୍ଡ",
        "NO": "ନରୱେ",
        "NP": "ନେପାଳ",
        "NR": "ନାଉରୁ",
        "NU": "ନିଉ",
        "NZ": "ନ୍ୟୁଜିଲାଣ୍ଡ",
        "OM": "ଓମାନ୍",
        "PA": "ପାନାମା",
        "PE": "ପେରୁ",
        "PF": "ଫ୍ରେଞ୍ଚ ପଲିନେସିଆ",
        "PG": "ପପୁଆ ନ୍ୟୁ ଗୁଏନିଆ",
        "PH": "ଫିଲିପାଇନସ୍",
        "PK": "ପାକିସ୍ତାନ",
        "PL": "ପୋଲାଣ୍ଡ",
        "PM": "ସେଣ୍ଟ ପିଏରେ ଏବଂ ମିକ୍ୱେଲନ୍‌",
        "PN": "ପିଟକାଇରିନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ",
        "PR": "ପୁଏର୍ତ୍ତୋ ରିକୋ",
        "PS": "ପାଲେଷ୍ଟେନିୟ ଭୂଭାଗ",
        "PT": "ପର୍ତ୍ତୁଗାଲ୍",
        "PW": "ପାଲାଉ",
        "PY": "ପାରାଗୁଏ",
        "QA": "କତାର୍",
        "QO": "ସୀମାନ୍ତବର୍ତ୍ତୀ ଓସିନିଆ",
        "RE": "ରିୟୁନିଅନ୍",
        "RO": "ରୋମାନିଆ",
        "RS": "ସର୍ବିଆ",
        "RU": "ରୁଷିଆ",
        "RW": "ରାୱାଣ୍ଡା",
        "SA": "ସାଉଦି ଆରବିଆ",
        "SB": "ସୋଲୋମନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ",
        "SC": "ସେଚେଲସ୍",
        "SD": "ସୁଦାନ",
        "SE": "ସ୍ୱେଡେନ୍",
        "SG": "ସିଙ୍ଗାପୁର୍",
        "SH": "ସେଣ୍ଟ ହେଲେନା",
        "SI": "ସ୍ଲୋଭେନିଆ",
        "SJ": "ସାଲବାର୍ଡ ଏବଂ ଜାନ୍‌ ମାୟେନ୍‌",
        "SK": "ସ୍ଲୋଭାକିଆ",
        "SL": "ସିଏରା ଲିଓନ",
        "SM": "ସାନ୍ ମାରିନୋ",
        "SN": "ସେନେଗାଲ୍",
        "SO": "ସୋମାଲିଆ",
        "SR": "ସୁରିନାମ",
        "SS": "ଦକ୍ଷିଣ ସୁଦାନ",
        "ST": "ସାଓ ଟୋମେ ଏବଂ ପ୍ରିନସିପି",
        "SV": "ଏଲ୍ ସାଲଭାଡୋର୍",
        "SX": "ସିଣ୍ଟ ମାର୍ଟୀନ୍‌",
        "SY": "ସିରିଆ",
        "SZ": "ସ୍ୱାଜିଲ୍ୟାଣ୍ଡ",
        "TA": "ଟ୍ରାଇଷ୍ଟନ୍‌ ଦା କୁନ୍‌ଚା",
        "TC": "ତୁର୍କସ୍‌ ଏବଂ କାଇକୋସ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ",
        "TD": "ଚାଦ୍",
        "TF": "ଫରାସୀ ଦକ୍ଷିଣ କ୍ଷେତ୍ର",
        "TG": "ଟୋଗୋ",
        "TH": "ଥାଇଲ୍ୟାଣ୍ଡ",
        "TJ": "ତାଜିକିସ୍ଥାନ୍",
        "TK": "ଟୋକେଲାଉ",
        "TL": "ତିମୋର୍-ଲେଷ୍ଟେ",
        "TM": "ତୁର୍କମେନିସ୍ତାନ",
        "TN": "ଟ୍ୟୁନିସିଆ",
        "TO": "ଟୋଙ୍ଗା",
        "TR": "ତୁର୍କୀ",
        "TT": "ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ",
        "TV": "ତୁଭାଲୁ",
        "TW": "ତାଇୱାନ",
        "TZ": "ତାଞ୍ଜାନିଆ",
        "UA": "ୟୁକ୍ରେନ୍",
        "UG": "ଉଗାଣ୍ଡା",
        "UM": "ଯୁକ୍ତରାଷ୍ଟ୍ର ଆଉଟ୍‌ଲାଇଙ୍ଗ ଦ୍ଵୀପପୁଞ୍ଜ",
        "UN": "ଜାତିସଂଘ",
        "US": "ଯୁକ୍ତ ରାଷ୍ଟ୍ର",
        "UY": "ଉରୁଗୁଏ",
        "UZ": "ଉଜବେକିସ୍ତାନ",
        "VA": "ଭାଟିକାନ୍ ସିଟି",
        "VC": "ସେଣ୍ଟ ଭିନସେଣ୍ଟ ଏବଂ ଦି ଗ୍ରେନାଡିସ୍",
        "VE": "ଭେନେଜୁଏଲା",
        "VG": "ବ୍ରିଟିଶ୍‌ ଭର୍ଜିନ୍ ଦ୍ୱୀପପୁଞ୍ଜ",
        "VI": "ଯୁକ୍ତରାଷ୍ଟ୍ର ଭିର୍ଜିନ୍ ଦ୍ଵୀପପୁଞ୍ଜ",
        "VN": "ଭିଏତନାମ୍",
        "VU": "ଭାନୁଆତୁ",
        "WF": "ୱାଲିସ୍ ଏବଂ ଫୁତୁନା",
        "WS": "ସାମୋଆ",
        "XK": "କୋସୋଭୋ",
        "YE": "ୟେମେନ୍",
        "YT": "ମାୟୋଟେ",
        "ZA": "ଦକ୍ଷିଣ ଆଫ୍ରିକା",
        "ZM": "ଜାମ୍ବିଆ",
        "ZW": "ଜିମ୍ବାୱେ",
        "ZZ": "ଅଜଣା ଅଞ୍ଚଳ"
    };
  }-*/;
}
