/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamFactory;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.rpc.impl.ClientSerializationStreamReader;
import com.google.gwt.user.client.rpc.impl.ClientSerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.RequestCallbackAdapter;
import com.google.gwt.user.client.rpc.impl.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteServiceProxy
implements SerializationStreamFactory,
ServiceDefTarget {
    private static int requestId;
    private final String moduleBaseURL;
    private String remoteServiceURL;
    private final String serializationPolicyName;
    private final Serializer serializer;

    public static native JavaScriptObject bytesStat(String var0, int var1, int var2);

    public static boolean isStatsAvailable() {
        return GWT.isScript() && RemoteServiceProxy.isStatsAvailable0();
    }

    public static native boolean stats(String var0, JavaScriptObject var1);

    public static native JavaScriptObject timeStat(String var0, int var1);

    protected static int getNextRequestId() {
        return requestId++;
    }

    protected static int getRequestId() {
        return requestId;
    }

    static boolean isReturnValue(String encodedResponse) {
        return encodedResponse.startsWith("//OK");
    }

    static boolean isThrownException(String encodedResponse) {
        return encodedResponse.startsWith("//EX");
    }

    private static String getEncodedInstance(String encodedResponse) {
        if (RemoteServiceProxy.isReturnValue(encodedResponse) || RemoteServiceProxy.isThrownException(encodedResponse)) {
            return encodedResponse.substring(4);
        }
        return encodedResponse;
    }

    private static native boolean isStatsAvailable0();

    protected RemoteServiceProxy(String moduleBaseURL, String remoteServiceRelativePath, String serializationPolicyName, Serializer serializer) {
        this.moduleBaseURL = moduleBaseURL;
        if (remoteServiceRelativePath != null) {
            this.remoteServiceURL = moduleBaseURL + remoteServiceRelativePath;
        }
        this.serializer = serializer;
        this.serializationPolicyName = serializationPolicyName;
    }

    @Override
    public ClientSerializationStreamReader createStreamReader(String encoded) throws SerializationException {
        ClientSerializationStreamReader clientSerializationStreamReader = new ClientSerializationStreamReader(this.serializer);
        clientSerializationStreamReader.prepareToRead(RemoteServiceProxy.getEncodedInstance(encoded));
        return clientSerializationStreamReader;
    }

    @Override
    public ClientSerializationStreamWriter createStreamWriter() {
        ClientSerializationStreamWriter clientSerializationStreamWriter = new ClientSerializationStreamWriter(this.serializer, this.moduleBaseURL, this.serializationPolicyName);
        clientSerializationStreamWriter.prepareToWrite();
        return clientSerializationStreamWriter;
    }

    @Override
    public String getServiceEntryPoint() {
        return this.remoteServiceURL;
    }

    @Override
    public void setServiceEntryPoint(String url) {
        this.remoteServiceURL = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Request doInvoke(RequestCallbackAdapter.ResponseReader responseReader, String methodName, int invocationCount, String requestData, AsyncCallback<T> callback) {
        RequestBuilder rb = this.doPrepareRequestBuilderImpl(responseReader, methodName, invocationCount, requestData, callback);
        try {
            Request request = rb.send();
            return request;
        }
        catch (RequestException ex) {
            InvocationException iex = new InvocationException("Unable to initiate the asynchronous service invocation -- check the network connection", ex);
            callback.onFailure(iex);
        }
        finally {
            if (!RemoteServiceProxy.isStatsAvailable() || RemoteServiceProxy.stats(methodName + ":" + invocationCount + ":requestSent", RemoteServiceProxy.bytesStat(methodName, invocationCount, requestData.length()))) {
                // empty if block
            }
        }
        return null;
    }

    protected <T> RequestBuilder doPrepareRequestBuilder(RequestCallbackAdapter.ResponseReader responseReader, String methodName, int invocationCount, String requestData, AsyncCallback<T> callback) {
        RequestBuilder rb = this.doPrepareRequestBuilderImpl(responseReader, methodName, invocationCount, requestData, callback);
        if (!RemoteServiceProxy.isStatsAvailable() || RemoteServiceProxy.stats(methodName + ":" + invocationCount + ":requestPrepared", RemoteServiceProxy.bytesStat(methodName, invocationCount, requestData.length()))) {
            // empty if block
        }
        return rb;
    }

    private <T> RequestBuilder doPrepareRequestBuilderImpl(RequestCallbackAdapter.ResponseReader responseReader, String methodName, int invocationCount, String requestData, AsyncCallback<T> callback) {
        if (this.getServiceEntryPoint() == null) {
            throw new ServiceDefTarget.NoServiceEntryPointSpecifiedException();
        }
        RequestCallbackAdapter<T> responseHandler = new RequestCallbackAdapter<T>(this, methodName, invocationCount, callback, responseReader);
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, this.getServiceEntryPoint());
        rb.setHeader("Content-Type", "text/x-gwt-rpc; charset=utf-8");
        rb.setCallback(responseHandler);
        rb.setRequestData(requestData);
        return rb;
    }
}

