/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.Node;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;

@GwtIncompatible(value="java.net.URI")
public class Es6RelativizeImportPaths
implements CompilerPass {
    private final AbstractCompiler compiler;

    public Es6RelativizeImportPaths(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node script : root.children()) {
            if (!Es6RewriteModules.isEs6ModuleRoot(script)) continue;
            NodeTraversal.traverse(this.compiler, script, new Rewriter());
            script.putBooleanProp((byte)93, true);
        }
    }

    private static class Rewriter
    extends NodeTraversal.AbstractPreOrderCallback {
        private Rewriter() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            switch (n.getToken()) {
                case ROOT: 
                case MODULE_BODY: 
                case SCRIPT: {
                    return true;
                }
                case IMPORT: {
                    this.visitImport(nodeTraversal, n);
                    return false;
                }
                case EXPORT: {
                    this.visitExport(nodeTraversal, n);
                    return false;
                }
            }
            return false;
        }

        private void visitImport(NodeTraversal t, Node importDecl) {
            Node specifierNode = importDecl.getLastChild();
            String specifier = specifierNode.getString();
            if (ModuleLoader.isRelativeIdentifier(specifier)) {
                return;
            }
            try {
                URI specifierURI = new URI(specifier);
                if (specifierURI.isAbsolute()) {
                    return;
                }
            }
            catch (URISyntaxException e) {
                return;
            }
            String scriptPath = t.getInput().getPath().toString();
            try {
                scriptPath = new URI(scriptPath).getPath();
            }
            catch (URISyntaxException e) {
                return;
            }
            String newSpecifier = t.getInput().getPath().resolveModuleAsPath(specifier).toString();
            if (!newSpecifier.startsWith("/")) {
                newSpecifier = "/" + newSpecifier;
            }
            if (ModuleLoader.isAmbiguousIdentifier(newSpecifier = Paths.get(scriptPath, new String[0]).getParent().relativize(Paths.get(newSpecifier, new String[0])).toString())) {
                newSpecifier = "./" + newSpecifier;
            }
            if (!newSpecifier.equals(specifier)) {
                specifierNode.setString(newSpecifier);
                t.reportCodeChange(specifierNode);
            }
        }

        private void visitExport(NodeTraversal t, Node export) {
            if (export.hasTwoChildren()) {
                this.visitImport(t, export);
            }
        }
    }
}

