/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NameBasedDefinitionProvider;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class MarkNoSideEffectCalls
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<Node> noSideEffectFunctionNames;

    MarkNoSideEffectCalls(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.noSideEffectFunctionNames = new HashSet<Node>();
    }

    @Override
    public void process(Node externs, Node root) {
        NameBasedDefinitionProvider defFinder = new NameBasedDefinitionProvider(this.compiler, false);
        defFinder.process(externs, root);
        NodeTraversal.traverse(this.compiler, externs, new GatherNoSideEffectFunctions());
        NodeTraversal.traverse(this.compiler, root, new GatherNoSideEffectFunctions());
        NodeTraversal.traverse(this.compiler, root, new SetNoSideEffectCallProperty(defFinder));
    }

    private static boolean definitionTypeContainsFunctionType(DefinitionsRemover.Definition def) {
        Node rhs = def.getRValue();
        if (rhs == null) {
            return true;
        }
        switch (rhs.getToken()) {
            case ASSIGN: 
            case AND: 
            case CALL: 
            case GETPROP: 
            case GETELEM: 
            case FUNCTION: 
            case HOOK: 
            case NAME: 
            case NEW: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasNoSideEffectsAnnotation(Node node) {
        JSDocInfo docInfo = node.getJSDocInfo();
        return docInfo != null && docInfo.isNoSideEffects();
    }

    private class SetNoSideEffectCallProperty
    extends NodeTraversal.AbstractPostOrderCallback {
        private final NameBasedDefinitionProvider defFinder;

        SetNoSideEffectCallProperty(NameBasedDefinitionProvider defFinder) {
            this.defFinder = defFinder;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (!NodeUtil.isCallOrNew(node)) {
                return;
            }
            Node nameNode = node.getFirstChild();
            if (!nameNode.isName() && !nameNode.isGetProp()) {
                return;
            }
            Collection<DefinitionsRemover.Definition> definitions = this.defFinder.getDefinitionsReferencedAt(nameNode);
            if (definitions == null) {
                return;
            }
            boolean maybeFunction = false;
            for (DefinitionsRemover.Definition def : definitions) {
                Node lValue = def.getLValue();
                Preconditions.checkNotNull((Object)lValue);
                if (!MarkNoSideEffectCalls.definitionTypeContainsFunctionType(def)) continue;
                maybeFunction = true;
                if (MarkNoSideEffectCalls.this.noSideEffectFunctionNames.contains(lValue)) continue;
                return;
            }
            if (maybeFunction && node.getSideEffectFlags() != 15) {
                node.setSideEffectFlags(15);
                MarkNoSideEffectCalls.this.compiler.reportChangeToEnclosingScope(node);
            }
        }
    }

    private class GatherNoSideEffectFunctions
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherNoSideEffectFunctions() {
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (node.isGetProp()) {
                if (parent.isExprResult() && MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node)) {
                    MarkNoSideEffectCalls.this.noSideEffectFunctionNames.add(node);
                }
            } else if (node.isFunction()) {
                boolean hasAnnotation = MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node);
                ArrayList<Node> nameNodes = new ArrayList<Node>();
                nameNodes.add(node.getFirstChild());
                if (parent.isName()) {
                    Node gramp = parent.getParent();
                    if (gramp.isVar() && gramp.hasOneChild() && MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(gramp)) {
                        hasAnnotation = true;
                    }
                    nameNodes.add(parent);
                } else if (parent.isAssign()) {
                    if (MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(parent)) {
                        hasAnnotation = true;
                    }
                    nameNodes.add(parent.getFirstChild());
                }
                if (hasAnnotation) {
                    MarkNoSideEffectCalls.this.noSideEffectFunctionNames.addAll(nameNodes);
                }
            }
        }
    }
}

