/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class MustBeReachingVariableDef
extends DataFlowAnalysis<Node, MustDef> {
    private final AbstractCompiler compiler;
    private final Set<Var> escaped;
    private final Map<String, Var> allVarsInFn;
    private final List<Var> orderedVars;

    MustBeReachingVariableDef(ControlFlowGraph<Node> cfg, Scope jsScope, AbstractCompiler compiler, Es6SyntacticScopeCreator scopeCreator) {
        super(cfg, new MustDefJoin());
        this.compiler = compiler;
        this.escaped = new HashSet<Var>();
        this.allVarsInFn = new HashMap<String, Var>();
        this.orderedVars = new ArrayList<Var>();
        MustBeReachingVariableDef.computeEscaped((Scope)jsScope.getParent(), this.escaped, compiler, scopeCreator);
        NodeUtil.getAllVarsDeclaredInFunction(this.allVarsInFn, this.orderedVars, compiler, scopeCreator, (Scope)jsScope.getParent());
    }

    @Override
    boolean isForward() {
        return true;
    }

    @Override
    MustDef createEntryLattice() {
        return new MustDef(this.allVarsInFn.values());
    }

    @Override
    MustDef createInitialEstimateLattice() {
        return new MustDef();
    }

    @Override
    MustDef flowThrough(Node n, MustDef input) {
        MustDef output = new MustDef(input);
        this.computeMustDef(n, n, output, false);
        return output;
    }

    private void computeMustDef(Node n, Node cfgNode, MustDef output, boolean conditional) {
        switch (n.getToken()) {
            case BLOCK: 
            case ROOT: 
            case FUNCTION: {
                return;
            }
            case WHILE: 
            case DO: 
            case IF: {
                this.computeMustDef(NodeUtil.getConditionExpression(n), cfgNode, output, conditional);
                return;
            }
            case FOR: {
                this.computeMustDef(NodeUtil.getConditionExpression(n), cfgNode, output, conditional);
                return;
            }
            case FOR_IN: 
            case FOR_OF: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                if (NodeUtil.isNameDeclaration(lhs)) {
                    lhs = lhs.getLastChild();
                }
                if (lhs.isName()) {
                    this.addToDefIfLocal(lhs.getString(), cfgNode, rhs, output);
                } else if (lhs.isDestructuringLhs()) {
                    lhs = lhs.getFirstChild();
                }
                if (lhs.isDestructuringPattern()) {
                    this.computeMustDef(lhs, cfgNode, output, true);
                }
                return;
            }
            case AND: 
            case OR: {
                this.computeMustDef(n.getFirstChild(), cfgNode, output, conditional);
                this.computeMustDef(n.getLastChild(), cfgNode, output, true);
                return;
            }
            case HOOK: {
                this.computeMustDef(n.getFirstChild(), cfgNode, output, conditional);
                this.computeMustDef(n.getSecondChild(), cfgNode, output, true);
                this.computeMustDef(n.getLastChild(), cfgNode, output, true);
                return;
            }
            case LET: 
            case CONST: 
            case VAR: {
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (!c.hasChildren()) continue;
                    if (c.isName()) {
                        this.computeMustDef(c.getFirstChild(), cfgNode, output, conditional);
                        this.addToDefIfLocal(c.getString(), conditional ? null : cfgNode, c.getFirstChild(), output);
                        continue;
                    }
                    Preconditions.checkState((boolean)c.isDestructuringLhs(), (Object)c);
                    this.computeMustDef(c.getSecondChild(), cfgNode, output, conditional);
                    this.computeMustDef(c.getFirstChild(), cfgNode, output, conditional);
                }
                return;
            }
            case DEFAULT_VALUE: {
                if (n.getFirstChild().isDestructuringPattern()) {
                    this.computeMustDef(n.getSecondChild(), cfgNode, output, true);
                    this.computeMustDef(n.getFirstChild(), cfgNode, output, conditional);
                    break;
                }
                if (n.getFirstChild().isName()) {
                    this.computeMustDef(n.getSecondChild(), cfgNode, output, true);
                    this.addToDefIfLocal(n.getFirstChild().getString(), conditional ? null : cfgNode, null, output);
                    break;
                }
                this.computeMustDef(n.getFirstChild(), cfgNode, output, conditional);
                this.computeMustDef(n.getSecondChild(), cfgNode, output, true);
                break;
            }
            case NAME: {
                if (NodeUtil.isLhsByDestructuring(n)) {
                    this.addToDefIfLocal(n.getString(), conditional ? null : cfgNode, null, output);
                } else if ("arguments".equals(n.getString())) {
                    this.escapeParameters(output);
                }
                return;
            }
            default: {
                Node target;
                if (NodeUtil.isAssignmentOp(n)) {
                    if (n.getFirstChild().isName()) {
                        Node name = n.getFirstChild();
                        this.computeMustDef(name.getNext(), cfgNode, output, conditional);
                        this.addToDefIfLocal(name.getString(), conditional ? null : cfgNode, n.getLastChild(), output);
                        return;
                    }
                    if (NodeUtil.isGet(n.getFirstChild())) {
                        Node obj = n.getFirstFirstChild();
                        if (obj.isName() && "arguments".equals(obj.getString())) {
                            this.escapeParameters(output);
                        }
                    } else if (n.getFirstChild().isDestructuringPattern()) {
                        this.computeMustDef(n.getSecondChild(), cfgNode, output, conditional);
                        this.computeMustDef(n.getFirstChild(), cfgNode, output, conditional);
                        return;
                    }
                }
                if ((n.isDec() || n.isInc()) && (target = n.getFirstChild()).isName()) {
                    this.addToDefIfLocal(target.getString(), conditional ? null : cfgNode, null, output);
                    return;
                }
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    this.computeMustDef(c, cfgNode, output, conditional);
                }
            }
        }
    }

    private void addToDefIfLocal(String name, @Nullable Node node, @Nullable Node rValue, MustDef def) {
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        for (Var other : def.reachingDef.keySet()) {
            Definition otherDef = def.reachingDef.get(other);
            if (otherDef == null || !otherDef.depends.contains(var)) continue;
            def.reachingDef.put(other, null);
        }
        if (!this.escaped.contains(var)) {
            if (node == null) {
                def.reachingDef.put(var, null);
            } else {
                Definition definition = new Definition(node);
                if (rValue != null) {
                    this.computeDependence(definition, rValue);
                }
                def.reachingDef.put(var, definition);
            }
        }
    }

    private void escapeParameters(MustDef output) {
        for (Var var : this.allVarsInFn.values()) {
            if (!MustBeReachingVariableDef.isParameter(var)) continue;
            output.reachingDef.put(var, null);
        }
        for (Map.Entry entry : output.reachingDef.entrySet()) {
            Definition value = (Definition)entry.getValue();
            if (value == null) continue;
            for (Var dep : value.depends) {
                if (!MustBeReachingVariableDef.isParameter(dep)) continue;
                output.reachingDef.put((Var)entry.getKey(), (Definition)null);
            }
        }
    }

    private static boolean isParameter(Var v) {
        return v.isParam();
    }

    private void computeDependence(final Definition def, Node rValue) {
        NodeTraversal.traverse(this.compiler, rValue, new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isName()) {
                    Var dep = (Var)MustBeReachingVariableDef.this.allVarsInFn.get(n.getString());
                    if (dep == null) {
                        def.unknownDependencies = true;
                    } else {
                        def.depends.add(dep);
                    }
                }
            }
        });
    }

    Definition getDef(String name, Node useNode) {
        Preconditions.checkArgument((boolean)this.getCfg().hasNode(useNode));
        GraphNode n = this.getCfg().getNode(useNode);
        DataFlowAnalysis.FlowState state = (DataFlowAnalysis.FlowState)n.getAnnotation();
        return ((MustDef)state.getIn()).reachingDef.get(this.allVarsInFn.get(name));
    }

    Node getDefNode(String name, Node useNode) {
        Definition def = this.getDef(name, useNode);
        return def == null ? null : def.node;
    }

    boolean dependsOnOuterScopeVars(Definition def) {
        if (def.unknownDependencies) {
            return true;
        }
        for (Var s : def.depends) {
            if (!((Scope)s.scope).isCatchScope()) continue;
            return true;
        }
        return false;
    }

    private static class MustDefJoin
    extends JoinOp.BinaryJoinOp<MustDef> {
        private MustDefJoin() {
        }

        @Override
        public MustDef apply(MustDef a, MustDef b) {
            Var var;
            MustDef result = new MustDef();
            Map<Var, Definition> resultMap = result.reachingDef;
            for (Map.Entry<Var, Definition> varEntry : a.reachingDef.entrySet()) {
                var = varEntry.getKey();
                Definition aDef = varEntry.getValue();
                if (aDef == null) {
                    resultMap.put(var, null);
                    continue;
                }
                if (b.reachingDef.containsKey(var)) {
                    Definition bDef = b.reachingDef.get(var);
                    if (aDef.equals(bDef)) {
                        resultMap.put(var, aDef);
                        continue;
                    }
                    resultMap.put(var, null);
                    continue;
                }
                resultMap.put(var, aDef);
            }
            for (Map.Entry<Var, Definition> entry : b.reachingDef.entrySet()) {
                var = entry.getKey();
                if (a.reachingDef.containsKey(var)) continue;
                resultMap.put(var, entry.getValue());
            }
            return result;
        }
    }

    static final class MustDef
    implements LatticeElement {
        final Map<Var, Definition> reachingDef;

        public MustDef() {
            this.reachingDef = new HashMap<Var, Definition>();
        }

        public MustDef(Collection<Var> vars) {
            this();
            for (Var var : vars) {
                this.reachingDef.put(var, new Definition(((Scope)var.scope).getRootNode()));
            }
        }

        public MustDef(MustDef other) {
            this.reachingDef = new HashMap<Var, Definition>(other.reachingDef);
        }

        public boolean equals(Object other) {
            return other instanceof MustDef && ((MustDef)other).reachingDef.equals(this.reachingDef);
        }

        public int hashCode() {
            return this.reachingDef.hashCode();
        }
    }

    static class Definition {
        final Node node;
        final Set<Var> depends = new HashSet<Var>();
        private boolean unknownDependencies = false;

        Definition(Node node) {
            this.node = node;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Definition)) {
                return false;
            }
            Definition otherDef = (Definition)other;
            return otherDef.node == this.node;
        }

        public String toString() {
            return "Definition@" + this.node;
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }
}

