/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;

public class CheckTypeSummaryWarningsGuard
extends WarningsGuard {
    private final CheckLevel level;

    public CheckTypeSummaryWarningsGuard(CheckLevel level) {
        this.level = level;
    }

    @Override
    public CheckLevel level(JSError error) {
        Preconditions.checkNotNull((Object)error);
        if (this.inTypeSummary(error)) {
            return this.level;
        }
        return null;
    }

    @Override
    protected int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_BY_WHITELIST.getValue();
    }

    private boolean inTypeSummary(JSError error) {
        return error.sourceName != null && error.sourceName.endsWith(".i.js");
    }
}

