/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;

public class ModificationVisitor
implements Visitor<JSType> {
    private final JSTypeRegistry registry;

    public ModificationVisitor(JSTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public JSType caseNoType() {
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public JSType caseEnumElementType(EnumElementType type) {
        return type;
    }

    @Override
    public JSType caseAllType() {
        return this.getNativeType(JSTypeNative.ALL_TYPE);
    }

    @Override
    public JSType caseBooleanType() {
        return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
    }

    @Override
    public JSType caseNoObjectType() {
        return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
    }

    @Override
    public JSType caseFunctionType(FunctionType type) {
        JSType afterReturn;
        JSType beforeReturn;
        JSType afterThis;
        if (this.isNativeFunctionType(type)) {
            return type;
        }
        if (!type.isOrdinaryFunction()) {
            return type;
        }
        boolean changed = false;
        JSType beforeThis = type.getTypeOfThis();
        if (beforeThis != (afterThis = this.coerseToThisType(beforeThis.visit(this)))) {
            changed = true;
        }
        if ((beforeReturn = type.getReturnType()) != (afterReturn = beforeReturn.visit(this))) {
            changed = true;
        }
        FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this.registry);
        for (Node paramNode : type.getParameters()) {
            JSType afterParamType;
            JSType beforeParamType = paramNode.getJSType();
            if (beforeParamType != (afterParamType = beforeParamType.visit(this))) {
                changed = true;
            }
            if (paramNode.isOptionalArg()) {
                paramBuilder.addOptionalParams(afterParamType);
                continue;
            }
            if (paramNode.isVarArgs()) {
                paramBuilder.addVarArgs(afterParamType);
                continue;
            }
            paramBuilder.addRequiredParams(afterParamType);
        }
        if (changed) {
            FunctionBuilder builder = new FunctionBuilder(this.registry);
            builder.withParams(paramBuilder);
            builder.withReturnType(afterReturn);
            builder.withTypeOfThis(afterThis);
            builder.withTemplateKeys(type.getTemplateTypeMap().getUnfilledTemplateKeys());
            return builder.build();
        }
        return type;
    }

    private JSType coerseToThisType(JSType type) {
        return type != null ? type : this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public JSType caseObjectType(ObjectType objType) {
        return objType;
    }

    @Override
    public JSType caseTemplatizedType(TemplatizedType type) {
        ObjectType afterBaseType;
        boolean changed = false;
        ObjectType beforeBaseType = type.getReferencedType();
        if (beforeBaseType != (afterBaseType = ObjectType.cast(beforeBaseType.visit(this)))) {
            changed = true;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSType beforeTemplateType : type.getTemplateTypes()) {
            JSType afterTemplateType;
            if (beforeTemplateType != (afterTemplateType = beforeTemplateType.visit(this))) {
                changed = true;
            }
            builder.add((Object)afterTemplateType);
        }
        if (changed) {
            type = this.registry.createTemplatizedType(afterBaseType, (ImmutableList<JSType>)builder.build());
        }
        return type;
    }

    @Override
    public JSType caseUnknownType() {
        return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public JSType caseNullType() {
        return this.getNativeType(JSTypeNative.NULL_TYPE);
    }

    @Override
    public JSType caseNumberType() {
        return this.getNativeType(JSTypeNative.NUMBER_TYPE);
    }

    @Override
    public JSType caseStringType() {
        return this.getNativeType(JSTypeNative.STRING_TYPE);
    }

    @Override
    public JSType caseVoidType() {
        return this.getNativeType(JSTypeNative.VOID_TYPE);
    }

    @Override
    public JSType caseUnionType(UnionType type) {
        boolean changed = false;
        ArrayList results = Lists.newArrayList();
        for (JSType alternative : type.getAlternates()) {
            JSType replacement = alternative.visit(this);
            if (replacement != alternative) {
                changed = true;
            }
            results.add(replacement);
        }
        if (changed) {
            UnionTypeBuilder builder = new UnionTypeBuilder(this.registry);
            for (JSType alternate : results) {
                builder.addAlternate(alternate);
            }
            return builder.build();
        }
        return type;
    }

    @Override
    public JSType caseTemplateType(TemplateType type) {
        return type;
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        return this.registry.getNativeType(nativeType);
    }

    private boolean isNativeFunctionType(FunctionType type) {
        return type.isNativeObjectType();
    }
}

