/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public class GrayscaleLuminanceSource
extends LuminanceSource {
    private final byte[] luminances;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public GrayscaleLuminanceSource(int width, int height, byte[] pixels) {
        super(width, height);
        this.luminances = pixels;
        this.dataWidth = width;
        this.dataHeight = height;
        this.left = 0;
        this.top = 0;
    }

    private GrayscaleLuminanceSource(byte[] pixels, int dataWidth, int dataHeight, int left, int top, int width, int height) {
        super(width, height);
        if (left + width > dataWidth || top + height > dataHeight) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.luminances = pixels;
        this.dataWidth = dataWidth;
        this.dataHeight = dataHeight;
        this.left = left;
        this.top = top;
    }

    @Override
    public byte[] getRow(int y, byte[] row) {
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + y);
        }
        int width = this.getWidth();
        if (row == null || row.length < width) {
            row = new byte[width];
        }
        int offset = (y + this.top) * this.dataWidth + this.left;
        System.arraycopy(this.luminances, offset, row, 0, width);
        return row;
    }

    @Override
    public byte[] getMatrix() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == this.dataWidth && height == this.dataHeight) {
            return this.luminances;
        }
        int area = width * height;
        byte[] matrix = new byte[area];
        int inputOffset = this.top * this.dataWidth + this.left;
        if (width == this.dataWidth) {
            System.arraycopy(this.luminances, inputOffset, matrix, 0, area);
            return matrix;
        }
        for (int y = 0; y < height; ++y) {
            int outputOffset = y * width;
            System.arraycopy(this.luminances, inputOffset, matrix, outputOffset, width);
            inputOffset += this.dataWidth;
        }
        return matrix;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int left, int top, int width, int height) {
        return new GrayscaleLuminanceSource(this.luminances, this.dataWidth, this.dataHeight, this.left + left, this.top + top, width, height);
    }

    @Override
    public boolean isRotateSupported() {
        return true;
    }

    @Override
    public LuminanceSource rotateCounterClockwise() {
        byte[] rotated = new byte[this.luminances.length];
        for (int y = 0; y < this.dataHeight; ++y) {
            for (int x = 0; x < this.dataWidth; ++x) {
                int i = y * this.dataWidth + x;
                int x2 = y;
                int y2 = this.dataWidth - 1 - x;
                int j = y2 * this.dataHeight + x2;
                rotated[j] = this.luminances[i];
            }
        }
        int newWidth = this.getHeight();
        int newHeight = this.getWidth();
        int newLeft = this.top;
        int newTop = this.dataWidth - (this.left + this.getWidth());
        return new GrayscaleLuminanceSource(rotated, this.dataHeight, this.dataWidth, newLeft, newTop, newWidth, newHeight);
    }
}

