/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.jdbc.DriverDataSource;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogCreator;
import com.googlecode.flyway.core.util.logging.LogFactory;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.core.validation.ValidationMode;
import com.googlecode.flyway.maven.MavenLogCreator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFlywayMojo
extends AbstractMojo {
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    protected Log log;
    boolean skip;
    String driver;
    String url;
    String user;
    private String password;
    private String[] schemas;
    private String table;
    @Deprecated
    private String initialVersion;
    @Deprecated
    private String initialDescription;
    private String initVersion;
    private String initDescription;
    private String[] locations;
    private String encoding;
    private String sqlMigrationPrefix;
    private String sqlMigrationSuffix;
    @Deprecated
    private String validationErrorMode;
    private boolean cleanOnValidationError;
    private String target;
    private boolean outOfOrder;
    private boolean ignoreFailedFutureMigration;
    private Map<String, String> placeholders;
    private String placeholderPrefix;
    private String placeholderSuffix;
    @Deprecated
    private boolean disableInitCheck;
    private boolean initOnMigrate;
    @Deprecated
    private String validationMode;
    private boolean validateOnMigrate;
    private String serverId = "flyway-db";
    private Settings settings;
    protected MavenProject mavenProject;

    AbstractFlywayMojo() {
    }

    private void loadCredentialsFromSettings() throws FlywayException {
        Server server;
        if (this.user == null && (server = this.settings.getServer(this.serverId)) != null) {
            this.user = server.getUsername();
            try {
                DefaultSecDispatcher secDispatcher = new DefaultSecDispatcher(){
                    {
                        this._cipher = new DefaultPlexusCipher();
                    }
                };
                this.password = secDispatcher.decrypt(server.getPassword());
            }
            catch (SecDispatcherException e) {
                throw new FlywayException("Unable to decrypt password", (Throwable)e);
            }
            catch (PlexusCipherException e) {
                throw new FlywayException("Unable to initialized password decryption", (Throwable)e);
            }
        }
    }

    DataSource createDataSource() throws Exception {
        return new DriverDataSource(System.getProperty("flyway.driver", this.driver), System.getProperty("flyway.url", this.url), System.getProperty("flyway.user", this.user), System.getProperty("flyway.password", this.password), new String[0]);
    }

    private boolean getBooleanProperty(String systemPropertyName, boolean mavenPropertyValue) {
        String systemPropertyValue = System.getProperty(systemPropertyName);
        if (systemPropertyValue != null) {
            return Boolean.getBoolean(systemPropertyValue);
        }
        return mavenPropertyValue;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        LogFactory.setLogCreator((LogCreator)new MavenLogCreator(this));
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        if (this.getBooleanProperty("flyway.skip", this.skip)) {
            this.log.info("Skipping Flyway execution");
            return;
        }
        try {
            String placeholderSuffixProperty;
            String validationErrorModeProperty;
            String sqlMigrationPrefixProperty;
            String encodingProperty;
            String locationsProperty;
            String initDescriptionProperty;
            String initVersionProperty;
            String initialDescriptionProperty;
            String initialVersionProperty;
            this.loadCredentialsFromSettings();
            Flyway flyway = new Flyway();
            flyway.setDataSource(this.createDataSource());
            String schemasProperty = System.getProperty("flyway.schemas", this.mavenProject.getProperties().getProperty("flyway.schemas"));
            if (schemasProperty != null) {
                flyway.setSchemas(StringUtils.tokenizeToStringArray((String)schemasProperty, (String)","));
            } else if (this.schemas != null) {
                flyway.setSchemas(this.schemas);
            }
            String tableProperty = System.getProperty("flyway.table", this.table);
            if (tableProperty != null) {
                flyway.setTable(tableProperty);
            }
            if ((initialVersionProperty = System.getProperty("flyway.initialVersion", this.initialVersion)) != null) {
                flyway.setInitialVersion(initialVersionProperty);
            }
            if ((initialDescriptionProperty = System.getProperty("flyway.initialDescription", this.initialDescription)) != null) {
                flyway.setInitialDescription(initialDescriptionProperty);
            }
            if ((initVersionProperty = System.getProperty("flyway.initVersion", this.initVersion)) != null) {
                flyway.setInitVersion(initVersionProperty);
            }
            if ((initDescriptionProperty = System.getProperty("flyway.initDescription", this.initDescription)) != null) {
                flyway.setInitDescription(initDescriptionProperty);
            }
            if ((locationsProperty = this.getProperty("flyway.locations")) != null) {
                this.locations = StringUtils.tokenizeToStringArray((String)locationsProperty, (String)",");
            }
            if (this.locations != null) {
                for (int i = 0; i < this.locations.length; ++i) {
                    if (!this.locations[i].startsWith("filesystem:")) continue;
                    String newLocation = this.locations[i].substring("filesystem:".length());
                    File file = new File(newLocation);
                    if (!file.isAbsolute()) {
                        file = new File(this.mavenProject.getBasedir(), newLocation);
                    }
                    this.locations[i] = "filesystem:" + file.getAbsolutePath();
                }
                flyway.setLocations(this.locations);
            }
            if ((encodingProperty = System.getProperty("flyway.encoding", this.encoding)) != null) {
                flyway.setEncoding(encodingProperty);
            }
            if ((sqlMigrationPrefixProperty = System.getProperty("flyway.sqlMigrationPrefix", this.sqlMigrationPrefix)) != null) {
                flyway.setSqlMigrationPrefix(sqlMigrationPrefixProperty);
            }
            String sqlMigrationSuffixProperty = System.getProperty("flyway.sqlMigrationSuffix", this.sqlMigrationSuffix);
            if (this.sqlMigrationSuffix != null) {
                flyway.setSqlMigrationSuffix(this.sqlMigrationSuffix);
            }
            if ((validationErrorModeProperty = System.getProperty("flyway.validationErrorMode", this.validationErrorMode)) != null) {
                flyway.setValidationErrorMode(ValidationErrorMode.valueOf((String)validationErrorModeProperty.toUpperCase()));
            }
            flyway.setCleanOnValidationError(this.getBooleanProperty("flyway.cleanOnValidationError", this.cleanOnValidationError));
            flyway.setOutOfOrder(this.getBooleanProperty("flyway.outOfOrder", this.outOfOrder));
            String targetProperty = System.getProperty("flyway.target", this.target);
            if (targetProperty != null) {
                flyway.setTarget(new MigrationVersion(targetProperty));
            }
            flyway.setIgnoreFailedFutureMigration(this.getBooleanProperty("flyway.ignoreFailedFutureMigration", this.ignoreFailedFutureMigration));
            HashMap<String, String> mergedPlaceholders = new HashMap<String, String>();
            AbstractFlywayMojo.addPlaceholdersFromProperties(mergedPlaceholders, this.mavenProject.getProperties());
            AbstractFlywayMojo.addPlaceholdersFromProperties(mergedPlaceholders, System.getProperties());
            if (this.placeholders != null) {
                mergedPlaceholders.putAll(this.placeholders);
            }
            flyway.setPlaceholders(mergedPlaceholders);
            String placeholderPrefixProperty = System.getProperty("flyway.placeholderPrefix", this.placeholderPrefix);
            if (placeholderPrefixProperty != null) {
                flyway.setPlaceholderPrefix(placeholderPrefixProperty);
            }
            if ((placeholderSuffixProperty = System.getProperty("flyway.placeholderSuffix", this.placeholderSuffix)) != null) {
                flyway.setPlaceholderSuffix(placeholderSuffixProperty);
            }
            flyway.setDisableInitCheck(this.getBooleanProperty("flyway.disableInitCheck", this.disableInitCheck));
            flyway.setInitOnMigrate(this.getBooleanProperty("flyway.initOnMigrate", this.initOnMigrate));
            String validationModeProperty = System.getProperty("flyway.validationMode", this.validationMode);
            if (validationModeProperty != null) {
                flyway.setValidationMode(ValidationMode.valueOf((String)validationModeProperty.toUpperCase()));
            }
            flyway.setValidateOnMigrate(this.getBooleanProperty("flyway.validateOnMigrate", this.validateOnMigrate));
            this.doExecute(flyway);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), ExceptionUtils.getRootCause((Throwable)e));
        }
    }

    protected String getProperty(String name) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        return this.mavenProject.getProperties().getProperty(name);
    }

    protected abstract void doExecute(Flyway var1) throws Exception;

    private static void addPlaceholdersFromProperties(Map<String, String> placeholders, Properties properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholders.put(placeholderName, placeholderValue);
        }
    }
}

