/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode;

import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class ConsoleDownloadMonitor
extends AbstractLogEnabled
implements TransferListener {
    private long complete;

    public void transferInitiated(TransferEvent transferEvent) {
        String message = transferEvent.getRequestType() == 6 ? "Uploading" : "Downloading";
        String url = transferEvent.getWagon().getRepository().getUrl();
        System.out.println(message + ": " + url + "/" + transferEvent.getResource().getName());
        this.complete = 0L;
    }

    public void transferStarted(TransferEvent transferEvent) {
    }

    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        long total = transferEvent.getResource().getContentLength();
        this.complete += (long)length;
        if (total >= 1024L) {
            System.out.print(this.complete / 1024L + "/" + (total == -1L ? "?" : total / 1024L + "K") + "\r");
        } else {
            System.out.print(this.complete + "/" + (total == -1L ? "?" : total + "b") + "\r");
        }
    }

    public void transferCompleted(TransferEvent transferEvent) {
        long contentLength = transferEvent.getResource().getContentLength();
        if (contentLength != -1L) {
            String type = transferEvent.getRequestType() == 6 ? "uploaded" : "downloaded";
            String l = contentLength >= 1024L ? contentLength / 1024L + "K" : contentLength + "b";
            System.out.println(l + " " + type);
        }
    }

    public void transferError(TransferEvent transferEvent) {
        transferEvent.getException().printStackTrace();
    }

    public void debug(String message) {
    }
}

