/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.aop;

import com.gradecak.alfresco.mvc.annotation.AlfrescoAuthentication;
import com.gradecak.alfresco.mvc.annotation.AuthenticationType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AuthenticationAdvice
implements MethodInterceptor {
    private final ServiceRegistry serviceRegistry;

    public AuthenticationAdvice(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        AuthenticationType authenticationType;
        Class<?> targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null;
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)invocation.getMethod(), targetClass);
        AlfrescoAuthentication alfrescoAuthentication = this.parseAnnotation(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod));
        if (alfrescoAuthentication != null && (authenticationType = alfrescoAuthentication.value()) != null && !AuthenticationType.NONE.equals((Object)authenticationType)) {
            MutableAuthenticationService authenticationService = this.serviceRegistry.getAuthenticationService();
            AuthorityService authorityService = this.serviceRegistry.getAuthorityService();
            String ticket = authenticationService.getCurrentTicket();
            if (StringUtils.hasText((String)ticket)) {
                if (AuthenticationType.USER.equals((Object)authenticationType) && authorityService.hasGuestAuthority()) {
                    throw new AuthenticationException("User has guest authority where at least a user authentication is required.");
                }
                if (AuthenticationType.ADMIN.equals((Object)authenticationType) && !authorityService.hasAdminAuthority()) {
                    throw new AuthenticationException("User does not have admin authority where at least named admin authentication is required .");
                }
            } else if (AuthenticationType.GUEST.equals((Object)authenticationType) && authenticationService.guestUserAuthenticationAllowed()) {
                authenticationService.authenticateAsGuest();
            } else {
                throw new AuthenticationException("\nUnable to authenticate due to one of the following reasons:\nCredentials are not provided in HTTP request where at least named user or admin authentication is required.\nGuest user authentication is not allowed where at least guest authentication is required.\n");
            }
        }
        return invocation.proceed();
    }

    private AlfrescoAuthentication parseAnnotation(AnnotatedElement ae) {
        AlfrescoAuthentication ann = ae.getAnnotation(AlfrescoAuthentication.class);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] annotationArray = ae.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (ann = (metaAnn = annotationArray[i]).annotationType().getAnnotation(AlfrescoAuthentication.class)) == null; ++i) {
            }
        }
        if (ann != null) {
            return this.parseAnnotation(ann);
        }
        return null;
    }

    private AlfrescoAuthentication parseAnnotation(AlfrescoAuthentication ann) {
        return ann;
    }
}

