/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.aop;

import java.util.ArrayList;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ObjectUtils;

public class PackageAutoProxyCreator
extends AbstractAutoProxyCreator
implements InitializingBean {
    private static final long serialVersionUID = -1219238254256448615L;
    public static final String[] DEFAULT_INTERCEPTORS = new String[]{"mvc.aop.alfrescoAuthenticationAdvisor", "mvc.aop.alfrescoRunAsAdvisor", "mvc.aop.alfrescoTransactionAdvisor"};
    private String basePackage;
    private boolean skipDefaultInterceptos = false;
    private boolean defaultInterceptorsSet = false;

    public void afterPropertiesSet() throws Exception {
        if (!this.defaultInterceptorsSet) {
            super.setInterceptorNames(this.withDefaultInterceptorNames(null));
        }
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, TargetSource targetSource) {
        if (this.basePackage != null && beanClass != null && beanClass.getPackage() != null && beanClass.getPackage().getName().equals(this.basePackage)) {
            return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        return DO_NOT_PROXY;
    }

    public void setInterceptorNames(String ... interceptorNames) {
        super.setInterceptorNames(this.withDefaultInterceptorNames(interceptorNames));
    }

    private String[] withDefaultInterceptorNames(String[] interceptorNames) {
        ArrayList<String> interceptors = new ArrayList<String>();
        if (!this.skipDefaultInterceptos) {
            for (String interceptorName : DEFAULT_INTERCEPTORS) {
                interceptors.add(interceptorName);
            }
            this.defaultInterceptorsSet = true;
        }
        if (!ObjectUtils.isEmpty((Object[])interceptorNames)) {
            for (String interceptorName : interceptorNames) {
                interceptors.add(interceptorName);
            }
        }
        return interceptors.toArray(new String[interceptors.size()]);
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setSkipDefaultInterceptos(boolean skipDefaultInterceptos) {
        this.skipDefaultInterceptos = skipDefaultInterceptos;
    }
}

