/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.rest.config;

import com.gradecak.alfresco.mvc.rest.annotation.AlfrescoDispatcherWebscript;
import com.gradecak.alfresco.mvc.rest.annotation.EnableAlfrescoMvcRest;
import com.gradecak.alfresco.mvc.webscript.DispatcherWebscript;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;

public class AlfrescoRestRegistrar
implements ImportBeanDefinitionRegistrar {
    private AnnotationAttributes attributes;

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes[] dispatcherWebscripts;
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        Map annotationAttributes = annotationMetadata.getAnnotationAttributes(EnableAlfrescoMvcRest.class.getName());
        if (annotationAttributes == null) {
            Map annotationAttributes2 = annotationMetadata.getAnnotationAttributes(AlfrescoDispatcherWebscript.class.getName());
            if (annotationAttributes2 != null) {
                annotationAttributes = new AnnotationAttributes();
                annotationAttributes.put("value", Collections.singleton(new AnnotationAttributes(annotationAttributes2)).toArray(new AnnotationAttributes[0]));
            }
            this.attributes = new AnnotationAttributes(annotationAttributes);
        } else {
            this.attributes = new AnnotationAttributes(annotationAttributes);
        }
        for (AnnotationAttributes dispatcherWebscript : dispatcherWebscripts = (AnnotationAttributes[])this.attributes.get((Object)"value")) {
            this.processDispatcherWebscript(dispatcherWebscript, registry);
        }
    }

    private void processDispatcherWebscript(AnnotationAttributes webscriptAttributes, BeanDefinitionRegistry registry) {
        String webscript = webscriptAttributes.getString("name");
        Assert.hasText((String)webscript, (String)"Webscript name cannot be empty!");
        Class servletContext = webscriptAttributes.getClass("servletContext");
        DispatcherWebscript.ServletConfigOptions[] servletConfigOptions = (DispatcherWebscript.ServletConfigOptions[])webscriptAttributes.get((Object)"servletConfigOptions");
        Class servletContextClass = webscriptAttributes.getClass("servletContextClass");
        RequestMethod[] httpRequestMethods = (RequestMethod[])webscriptAttributes.get((Object)"httpMethods");
        boolean inheritGlobalProperties = (Boolean)webscriptAttributes.get((Object)"inheritGlobalProperties");
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DispatcherWebscript.class);
        DispatcherWebscript ws = new DispatcherWebscript(webscript, inheritGlobalProperties);
        ws.setContextClass(servletContextClass);
        ws.setContextConfigLocation(servletContext.getName());
        ws.addServletConfigOptions(servletConfigOptions);
        beanDefinition.setInstanceSupplier(() -> ws);
        beanDefinition.setRole(0);
        registry.registerBeanDefinition(webscript, (BeanDefinition)beanDefinition);
        for (RequestMethod httpRequestMethod : httpRequestMethods) {
            registry.registerAlias(webscript, this.getWebscriptName(webscript, httpRequestMethod.asHttpMethod()));
        }
    }

    private String getWebscriptName(String webscript, HttpMethod httpMethod) {
        String beanName = "webscript." + webscript + "." + httpMethod.name();
        return beanName.toLowerCase();
    }
}

