/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.rest.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gradecak.alfresco.mvc.rest.AlfrescoApiResponseInterceptor;
import com.gradecak.alfresco.mvc.rest.config.ParamsHandlerMethodArgumentResolver;
import com.gradecak.alfresco.mvc.rest.jackson.Jackson2NodeRefDeserializer;
import com.gradecak.alfresco.mvc.rest.jackson.Jackson2NodeRefSerializer;
import com.gradecak.alfresco.mvc.rest.jackson.Jackson2QnameDeserializer;
import com.gradecak.alfresco.mvc.rest.jackson.Jackson2QnameSerializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.alfresco.rest.framework.jacksonextensions.RestJsonModule;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptHelper;
import org.alfresco.service.namespace.NamespaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class DefaultAlfrescoMvcServletContextConfiguration
implements WebMvcConfigurer {
    private final RestJsonModule alfrescoRestJsonModule;
    private final NamespaceService namespaceService;

    @Autowired
    public DefaultAlfrescoMvcServletContextConfiguration(@Nullable RestJsonModule alfrescoRestJsonModule, NamespaceService namespaceService) {
        this.alfrescoRestJsonModule = alfrescoRestJsonModule;
        this.namespaceService = namespaceService;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new ParamsHandlerMethodArgumentResolver());
    }

    @Bean
    public AlfrescoApiResponseInterceptor alfrescoResponseInterceptor(ResourceWebScriptHelper webscriptHelper) {
        return new AlfrescoApiResponseInterceptor(webscriptHelper);
    }

    @Bean
    public MultipartResolver multipartResolver() {
        MultipartResolver resolver = this.createMultipartResolver();
        this.configureMultipartResolver(resolver);
        return resolver;
    }

    protected MultipartResolver createMultipartResolver() {
        StandardServletMultipartResolver resolver = new StandardServletMultipartResolver();
        return resolver;
    }

    protected void configureMultipartResolver(MultipartResolver resolver) {
    }

    @Bean
    @Primary
    public ObjectMapper objectMapper() {
        return this.jackson2ObjectMapperBuilder().build();
    }

    @Bean
    @Primary
    public Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder() {
        ArrayList customJsonDeserializers = new ArrayList(this.customJsonDeserializers());
        customJsonDeserializers.add(this.jackson2NodeRefDeserializer());
        customJsonDeserializers.add(this.jackson2QnameDeserializer());
        ArrayList customJsonSerilizers = new ArrayList(this.customJsonSerilizers());
        customJsonSerilizers.add((JsonSerializer<?>)this.jackson2NodeRefSerializer());
        customJsonSerilizers.add((JsonSerializer<?>)this.jackson2QnameSerializer());
        Jackson2ObjectMapperBuilder builder = Jackson2ObjectMapperBuilder.json().failOnEmptyBeans(false).failOnUnknownProperties(false).dateFormat(this.dateFormat()).serializers(customJsonSerilizers.toArray(new JsonSerializer[0])).deserializers(customJsonDeserializers.toArray(new JsonDeserializer[0])).featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).findModulesViaServiceLoader(true);
        if (this.alfrescoRestJsonModule != null) {
            builder.modulesToInstall(new Module[]{this.alfrescoRestJsonModule});
        }
        this.customizeJackson2ObjectMapperBuilder(builder);
        return builder;
    }

    protected DateFormat dateFormat() {
        SimpleDateFormat dateFormatIso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        dateFormatIso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormatIso8601;
    }

    protected void customizeJackson2ObjectMapperBuilder(Jackson2ObjectMapperBuilder builder) {
    }

    protected List<JsonDeserializer<?>> customJsonDeserializers() {
        return Collections.emptyList();
    }

    protected List<JsonSerializer<?>> customJsonSerilizers() {
        return Collections.emptyList();
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)this.jackson2NodeRefDeserializer());
        registry.addConverter((Converter)this.jackson2QnameDeserializer());
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper()));
    }

    protected Jackson2NodeRefDeserializer jackson2NodeRefDeserializer() {
        return new Jackson2NodeRefDeserializer();
    }

    protected Jackson2QnameDeserializer jackson2QnameDeserializer() {
        return new Jackson2QnameDeserializer(this.namespaceService);
    }

    protected Jackson2NodeRefSerializer jackson2NodeRefSerializer() {
        return new Jackson2NodeRefSerializer();
    }

    protected Jackson2QnameSerializer jackson2QnameSerializer() {
        return new Jackson2QnameSerializer(this.namespaceService);
    }
}

