/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.exc.StreamConstraintsException;
import java.io.Serializable;

public class StreamReadConstraints
implements Serializable {
    protected final int _maxNestingDepth;
    protected final long _maxDocLen;
    protected final int _maxNumLen;
    protected final int _maxStringLen;
    protected final int _maxNameLen;
    private static StreamReadConstraints DEFAULT = new StreamReadConstraints(1000, -1L, 1000, 20000000, 50000);

    protected StreamReadConstraints(int n2, long l2, int n3, int n4, int n5) {
        this._maxNestingDepth = n2;
        this._maxDocLen = l2;
        this._maxNumLen = n3;
        this._maxStringLen = n4;
        this._maxNameLen = n5;
    }

    public static StreamReadConstraints defaults() {
        return DEFAULT;
    }

    public void validateNestingDepth(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNestingDepth) {
            throw this._constructException("Document nesting depth (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNestingDepth, this._constrainRef("getMaxNestingDepth"));
        }
    }

    public void validateDocumentLength(long l2) throws StreamConstraintsException {
        if (l2 > this._maxDocLen && this._maxDocLen > 0L) {
            throw this._constructException("Document length (%d) exceeds the maximum allowed (%d, from %s)", l2, this._maxDocLen, this._constrainRef("getMaxDocumentLength"));
        }
    }

    public void validateFPLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNumLen) {
            throw this._constructException("Number value length (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNumLen, this._constrainRef("getMaxNumberLength"));
        }
    }

    public void validateIntegerLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNumLen) {
            throw this._constructException("Number value length (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNumLen, this._constrainRef("getMaxNumberLength"));
        }
    }

    public void validateStringLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxStringLen) {
            throw this._constructException("String value length (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxStringLen, this._constrainRef("getMaxStringLength"));
        }
    }

    public void validateNameLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNameLen) {
            throw this._constructException("Name length (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNameLen, this._constrainRef("getMaxNameLength"));
        }
    }

    public void validateBigIntegerScale(int n2) throws StreamConstraintsException {
        int n3 = Math.abs(n2);
        int n4 = 100000;
        if (n3 > 100000) {
            throw this._constructException("BigDecimal scale (%d) magnitude exceeds the maximum allowed (%d)", n2, 100000);
        }
    }

    protected StreamConstraintsException _constructException(String string, Object ... objectArray) throws StreamConstraintsException {
        throw new StreamConstraintsException(String.format(string, objectArray));
    }

    protected String _constrainRef(String string) {
        return "`StreamReadConstraints." + string + "()`";
    }
}

