/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.math;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.math.MathPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.Ints;
import java.math.RoundingMode;

public final class IntMath {
    static final byte[] maxLog10ForLeadingZeros = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    static final int[] powersOf10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    static final int[] halfPowersOf10 = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    private static final int[] factorials = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    static int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};

    public static boolean isPowerOfTwo(int n2) {
        return n2 > 0 & (n2 & n2 - 1) == 0;
    }

    static int lessThanBranchFree(int n2, int n3) {
        return ~(~(n2 - n3)) >>> 31;
    }

    public static int log2(int n2, RoundingMode roundingMode) {
        MathPreconditions.checkPositive("x", n2);
        switch (roundingMode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(IntMath.isPowerOfTwo(n2));
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(n2);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(n2 - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n3 = Integer.numberOfLeadingZeros(n2);
                int n4 = -1257966797 >>> n3;
                int n5 = 31 - n3;
                return n5 + IntMath.lessThanBranchFree(n4, n2);
            }
        }
        throw new AssertionError();
    }

    public static int sqrt(int n2, RoundingMode roundingMode) {
        MathPreconditions.checkNonNegative("x", n2);
        int n3 = IntMath.sqrtFloor(n2);
        switch (roundingMode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(n3 * n3 == n2);
            }
            case DOWN: 
            case FLOOR: {
                return n3;
            }
            case UP: 
            case CEILING: {
                return n3 + IntMath.lessThanBranchFree(n3 * n3, n2);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n4 = n3 * n3 + n3;
                return n3 + IntMath.lessThanBranchFree(n4, n2);
            }
        }
        throw new AssertionError();
    }

    private static int sqrtFloor(int n2) {
        return (int)Math.sqrt(n2);
    }

    public static int divide(int n2, int n3, RoundingMode roundingMode) {
        boolean bl2;
        Preconditions.checkNotNull(roundingMode);
        if (n3 == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int n4 = n2 / n3;
        int n5 = n2 - n3 * n4;
        if (n5 == 0) {
            return n4;
        }
        int n6 = 1 | (n2 ^ n3) >> 31;
        switch (roundingMode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(n5 == 0);
            }
            case DOWN: {
                bl2 = false;
                break;
            }
            case UP: {
                bl2 = true;
                break;
            }
            case CEILING: {
                bl2 = n6 > 0;
                break;
            }
            case FLOOR: {
                bl2 = n6 < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n7 = Math.abs(n5);
                int n8 = n7 - (Math.abs(n3) - n7);
                if (n8 == 0) {
                    bl2 = roundingMode == RoundingMode.HALF_UP || roundingMode == RoundingMode.HALF_EVEN & (n4 & 1) != 0;
                    break;
                }
                bl2 = n8 > 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return bl2 ? n4 + n6 : n4;
    }

    public static int saturatedAdd(int n2, int n3) {
        return Ints.saturatedCast((long)n2 + (long)n3);
    }

    public static int saturatedMultiply(int n2, int n3) {
        return Ints.saturatedCast((long)n2 * (long)n3);
    }

    public static int binomial(int n2, int n3) {
        MathPreconditions.checkNonNegative("n", n2);
        MathPreconditions.checkNonNegative("k", n3);
        Preconditions.checkArgument(n3 <= n2, "k (%s) > n (%s)", n3, n2);
        if (n3 > n2 >> 1) {
            n3 = n2 - n3;
        }
        if (n3 >= biggestBinomials.length || n2 > biggestBinomials[n3]) {
            return Integer.MAX_VALUE;
        }
        switch (n3) {
            case 0: {
                return 1;
            }
            case 1: {
                return n2;
            }
        }
        long l2 = 1L;
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 *= (long)(n2 - i2);
            l2 /= (long)(i2 + 1);
        }
        return (int)l2;
    }
}

