/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeadersFactory;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.LastHttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import java.util.Map;

public class DefaultLastHttpContent
extends DefaultHttpContent
implements LastHttpContent {
    private final HttpHeaders trailingHeaders;

    public DefaultLastHttpContent() {
        this(Unpooled.buffer(0));
    }

    public DefaultLastHttpContent(ByteBuf byteBuf) {
        this(byteBuf, DefaultHttpHeadersFactory.trailersFactory());
    }

    public DefaultLastHttpContent(ByteBuf byteBuf, HttpHeadersFactory httpHeadersFactory) {
        super(byteBuf);
        this.trailingHeaders = httpHeadersFactory.newHeaders();
    }

    @Override
    public LastHttpContent retain() {
        super.retain();
        return this;
    }

    @Override
    public LastHttpContent touch(Object object) {
        super.touch(object);
        return this;
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(StringUtil.NEWLINE);
        this.appendHeaders(stringBuilder);
        stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
        return stringBuilder.toString();
    }

    private void appendHeaders(StringBuilder stringBuilder) {
        for (Map.Entry<String, String> entry : this.trailingHeaders()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(StringUtil.NEWLINE);
        }
    }
}

