/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.driver.textui.Debug;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataOrValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.IDContextProvider;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.IDContextProvider2;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NamespaceNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NotNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SimpleNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.NoneType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util.ExpressionPrinter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util.IDContextProviderWrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.DatatypeRef;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StringRef;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.Acceptor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.AnyElementToken;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.AttributeRecoveryToken;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.AttributeToken;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.CombinedChildContentExpCreator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.OptimizationTag;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.REDocumentDeclaration;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.StringCareLevelCalculator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.StringRecoveryToken;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.StringToken;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.Token;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class ExpressionAcceptor
implements Acceptor {
    private Expression expression;
    protected final REDocumentDeclaration docDecl;
    protected final boolean ignoreUndeclaredAttributes;

    public Expression getExpression() {
        return this.expression;
    }

    public ExpressionAcceptor(REDocumentDeclaration rEDocumentDeclaration, Expression expression, boolean bl2) {
        this.docDecl = rEDocumentDeclaration;
        this.expression = expression;
        this.ignoreUndeclaredAttributes = bl2;
    }

    public Acceptor createChildAcceptor(StartTagInfo startTagInfo, StringRef stringRef) {
        CombinedChildContentExpCreator combinedChildContentExpCreator = this.docDecl.cccec;
        CombinedChildContentExpCreator.ExpressionPair expressionPair = combinedChildContentExpCreator.get(this.expression, startTagInfo);
        if (expressionPair.content != Expression.nullSet) {
            if (Debug.debug) {
                System.out.println("accept start tag <" + startTagInfo.qName + ">. combined content pattern is");
                System.out.println(ExpressionPrinter.printContentModel(expressionPair.content));
                if (expressionPair.continuation != null) {
                    System.out.println("continuation is:\n" + ExpressionPrinter.printContentModel(expressionPair.continuation));
                } else {
                    System.out.println("no continuation");
                }
            }
            return this.createAcceptor(expressionPair.content, expressionPair.continuation, combinedChildContentExpCreator.getMatchedElements(), combinedChildContentExpCreator.numMatchedElements());
        }
        if (stringRef == null) {
            return null;
        }
        stringRef.str = this.diagnoseBadTagName(startTagInfo);
        if (stringRef.str == null) {
            stringRef.str = this.docDecl.localizeMessage("Diagnosis.BadTagName.Generic", startTagInfo.qName);
        }
        return this.createRecoveryAcceptors();
    }

    protected abstract Acceptor createAcceptor(Expression var1, Expression var2, ElementExp[] var3, int var4);

    public final boolean onAttribute(String string, String string2, String string3, String string4, IDContextProvider iDContextProvider, StringRef stringRef, DatatypeRef datatypeRef) {
        return this.onAttribute2(string, string2, string3, string4, IDContextProviderWrapper.create(iDContextProvider), stringRef, datatypeRef);
    }

    public final boolean onAttribute2(String string, String string2, String string3, String string4, IDContextProvider2 iDContextProvider2, StringRef stringRef, DatatypeRef datatypeRef) {
        this.docDecl.attToken.reinit(string, string2, string3, new StringToken(this.docDecl, string4, iDContextProvider2, datatypeRef));
        return this.onAttribute(this.docDecl.attToken, stringRef);
    }

    protected boolean onAttribute(AttributeToken attributeToken, StringRef stringRef) {
        Expression expression = this.docDecl.attFeeder.feed(this.expression, attributeToken, this.ignoreUndeclaredAttributes);
        if (expression != Expression.nullSet) {
            this.expression = expression;
            if (Debug.debug) {
                System.out.println("-- residual after :" + ExpressionPrinter.printContentModel(expression));
            }
            return true;
        }
        if (stringRef == null) {
            return false;
        }
        AttributeRecoveryToken attributeRecoveryToken = attributeToken.createRecoveryAttToken();
        expression = this.docDecl.attFeeder.feed(this.expression, attributeRecoveryToken, this.ignoreUndeclaredAttributes);
        if (expression == Expression.nullSet) {
            stringRef.str = this.expression == Expression.nullSet ? this.docDecl.localizeMessage("Diagnosis.ContentModelIsNullset", null) : this.docDecl.localizeMessage("Diagnosis.UndeclaredAttribute", attributeToken.qName);
            return true;
        }
        stringRef.str = this.diagnoseBadAttributeValue(attributeRecoveryToken);
        if (stringRef.str == null) {
            stringRef.str = this.docDecl.localizeMessage("Diagnosis.BadAttributeValue.Generic", attributeToken.qName);
        }
        this.expression = expression;
        return true;
    }

    public boolean onEndAttributes(StartTagInfo startTagInfo, StringRef stringRef) {
        Expression expression = this.docDecl.attPruner.prune(this.expression);
        if (expression != Expression.nullSet) {
            this.expression = expression;
            return true;
        }
        if (stringRef == null) {
            return false;
        }
        if (this.expression == Expression.nullSet) {
            stringRef.str = this.docDecl.localizeMessage("Diagnosis.ContentModelIsNullset", null);
        } else {
            stringRef.str = this.diagnoseMissingAttribute(startTagInfo);
            if (stringRef.str == null) {
                stringRef.str = this.docDecl.localizeMessage("Diagnosis.MissingAttribute.Generic", startTagInfo.qName);
            }
        }
        this.expression = this.expression.visit(this.docDecl.attRemover);
        return true;
    }

    protected boolean stepForward(Token token, StringRef stringRef) {
        Expression expression = this.docDecl.resCalc.calcResidual(this.expression, token);
        if (Debug.debug) {
            System.out.println("residual of stepForward(" + token + ")");
            System.out.print(ExpressionPrinter.printContentModel(this.expression));
            System.out.print("   ->   ");
            System.out.println(ExpressionPrinter.printContentModel(expression));
        }
        if (expression == Expression.nullSet) {
            if (stringRef != null && token instanceof StringToken) {
                stringRef.str = this.diagnoseUnexpectedLiteral((StringToken)token);
            }
            return false;
        }
        this.expression = expression;
        return true;
    }

    public final boolean onText(String string, IDContextProvider iDContextProvider, StringRef stringRef, DatatypeRef datatypeRef) {
        return this.onText2(string, IDContextProviderWrapper.create(iDContextProvider), stringRef, datatypeRef);
    }

    public boolean onText2(String string, IDContextProvider2 iDContextProvider2, StringRef stringRef, DatatypeRef datatypeRef) {
        return this.stepForward(new StringToken(this.docDecl, string, iDContextProvider2, datatypeRef), stringRef);
    }

    public final boolean stepForwardByContinuation(Expression expression, StringRef stringRef) {
        if (expression != Expression.nullSet) {
            if (Debug.debug) {
                System.out.println("stepForwardByCont. :  " + ExpressionPrinter.printContentModel(expression));
            }
            this.expression = expression;
            return true;
        }
        if (stringRef == null) {
            return false;
        }
        return false;
    }

    public boolean isAcceptState(StringRef stringRef) {
        if (stringRef == null) {
            return this.expression.isEpsilonReducible();
        }
        if (this.expression.isEpsilonReducible()) {
            return true;
        }
        stringRef.str = this.diagnoseUncompletedContent();
        return false;
    }

    public int getStringCareLevel() {
        OptimizationTag optimizationTag = (OptimizationTag)this.expression.verifierTag;
        if (optimizationTag == null) {
            optimizationTag = new OptimizationTag();
            this.expression.verifierTag = optimizationTag;
        }
        if (optimizationTag.stringCareLevel == -1) {
            optimizationTag.stringCareLevel = StringCareLevelCalculator.calc(this.expression);
        }
        return optimizationTag.stringCareLevel;
    }

    private final Expression mergeContinuation(Expression expression, Expression expression2) {
        if (expression == null && expression2 == null) {
            return null;
        }
        if (expression == null || expression == Expression.nullSet) {
            return expression2;
        }
        if (expression2 == null || expression2 == Expression.nullSet) {
            return expression;
        }
        return this.docDecl.pool.createChoice(expression, expression2);
    }

    private final Acceptor createRecoveryAcceptors() {
        CombinedChildContentExpCreator combinedChildContentExpCreator = this.docDecl.cccec;
        CombinedChildContentExpCreator.ExpressionPair expressionPair = combinedChildContentExpCreator.get(this.expression, null, false);
        Expression expression = this.docDecl.resCalc.calcResidual(this.expression, AnyElementToken.theInstance);
        Expression expression2 = this.docDecl.pool.createChoice(this.expression, expression);
        Expression expression3 = expressionPair.content;
        if (Debug.debug) {
            System.out.println("content model of recovery acceptor:" + ExpressionPrinter.printContentModel(expression3));
            System.out.println("continuation of recovery acceptor:" + ExpressionPrinter.printSmallest(expression2));
        }
        return this.createAcceptor(expression3, expression2, null, 0);
    }

    private String concatenateMessages(List list, boolean bl2, String string, String string2) {
        String string3 = "";
        String string4 = this.docDecl.localizeMessage(string, null);
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        });
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (string3.length() != 0) {
                string3 = string3 + string4;
            }
            string3 = string3 + list.get(i2);
        }
        if (bl2) {
            string3 = string3 + this.docDecl.localizeMessage(string2, null);
        }
        return string3;
    }

    private String concatenateMessages(Set set, boolean bl2, String string, String string2) {
        return this.concatenateMessages(new Vector(set), bl2, string, string2);
    }

    private String getDiagnosisFromTypedString(DataOrValueExp dataOrValueExp, StringToken stringToken) {
        try {
            dataOrValueExp.getType().checkValid(stringToken.literal, stringToken.context);
            return null;
        }
        catch (DatatypeException datatypeException) {
            return datatypeException.getMessage();
        }
    }

    private String diagnoseBadTagName(StartTagInfo startTagInfo) {
        CombinedChildContentExpCreator combinedChildContentExpCreator = this.docDecl.cccec;
        Expression expression = combinedChildContentExpCreator.get((Expression)this.expression, (StartTagInfo)startTagInfo, (boolean)false).content;
        if (expression == Expression.nullSet) {
            return this.docDecl.localizeMessage("Diagnosis.ElementNotAllowed", startTagInfo.qName);
        }
        if (combinedChildContentExpCreator.isComplex()) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = false;
        String string = null;
        ElementExp[] elementExpArray = combinedChildContentExpCreator.getMatchedElements();
        int n2 = combinedChildContentExpCreator.numMatchedElements();
        for (int i2 = 0; i2 < n2; ++i2) {
            NameClass nameClass;
            if (elementExpArray[i2].contentModel.getExpandedExp(this.docDecl.pool) == Expression.nullSet) continue;
            NameClass nameClass2 = elementExpArray[i2].getNameClass();
            if (nameClass2 instanceof SimpleNameClass) {
                nameClass = (SimpleNameClass)nameClass2;
                if (nameClass.localName.equals(startTagInfo.localName)) {
                    string = nameClass.namespaceURI;
                }
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.SimpleNameClass", nameClass2.toString()));
                continue;
            }
            if (nameClass2 instanceof NamespaceNameClass) {
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.NamespaceNameClass", ((NamespaceNameClass)nameClass2).namespaceURI));
                continue;
            }
            if (nameClass2 instanceof NotNameClass && (nameClass = ((NotNameClass)nameClass2).child) instanceof NamespaceNameClass) {
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.NotNamespaceNameClass", ((NamespaceNameClass)nameClass).namespaceURI));
                continue;
            }
            bl2 = true;
        }
        if (hashSet.size() == 0) {
            return null;
        }
        if (string != null) {
            if (hashSet.size() == 1) {
                return this.docDecl.localizeMessage("Diagnosis.BadTagName.WrongNamespace", startTagInfo.localName, string);
            }
            return this.docDecl.localizeMessage("Diagnosis.BadTagName.ProbablyWrongNamespace", startTagInfo.localName, string);
        }
        return this.docDecl.localizeMessage("Diagnosis.BadTagName.WrapUp", startTagInfo.qName, this.concatenateMessages(hashSet, bl2, "Diagnosis.BadTagName.Separator", "Diagnosis.BadTagName.More"));
    }

    private String diagnoseBadAttributeValue(AttributeRecoveryToken attributeRecoveryToken) {
        Expression expression = attributeRecoveryToken.getFailedExp();
        if (expression instanceof DataOrValueExp) {
            DataOrValueExp dataOrValueExp = (DataOrValueExp)((Object)expression);
            if (dataOrValueExp.getType() == NoneType.theInstance) {
                return this.docDecl.localizeMessage("Diagnosis.UndeclaredAttribute", attributeRecoveryToken.qName);
            }
            String string = this.getDiagnosisFromTypedString(dataOrValueExp, attributeRecoveryToken.value);
            if (string == null) {
                return null;
            }
            return this.docDecl.localizeMessage("Diagnosis.BadAttributeValue.DataType", attributeRecoveryToken.qName, string);
        }
        if (expression instanceof ChoiceExp) {
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl2 = false;
            ChoiceExp choiceExp = (ChoiceExp)expression;
            Expression[] expressionArray = choiceExp.getChildren();
            for (int i2 = 0; i2 < expressionArray.length; ++i2) {
                if (expressionArray[i2] instanceof ValueExp) {
                    hashSet.add(((ValueExp)expressionArray[i2]).value.toString());
                    continue;
                }
                bl2 = true;
            }
            if (hashSet.size() == 0) {
                return null;
            }
            return this.docDecl.localizeMessage("Diagnosis.BadAttributeValue.WrapUp", attributeRecoveryToken.qName, this.concatenateMessages(hashSet, bl2, "Diagnosis.BadAttributeValue.Separator", "Diagnosis.BadAttributeValue.More"));
        }
        return null;
    }

    private String diagnoseMissingAttribute(StartTagInfo startTagInfo) {
        Serializable serializable;
        Expression expression = this.expression.visit(this.docDecl.attPicker);
        if (expression.isEpsilonReducible()) {
            throw new Error();
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = false;
        while (expression instanceof ChoiceExp) {
            serializable = (ChoiceExp)expression;
            NameClass nameClass = ((AttributeExp)((ChoiceExp)serializable).exp2).nameClass;
            if (nameClass instanceof SimpleNameClass) {
                hashSet.add(nameClass.toString());
            } else {
                bl2 = true;
            }
            expression = ((ChoiceExp)serializable).exp1;
        }
        if (expression == Expression.nullSet) {
            return null;
        }
        if (!(expression instanceof AttributeExp)) {
            throw new Error(expression.toString());
        }
        serializable = ((AttributeExp)expression).nameClass;
        if (serializable instanceof SimpleNameClass) {
            hashSet.add(serializable.toString());
        } else {
            bl2 = true;
        }
        if (hashSet.size() == 0) {
            return null;
        }
        if (hashSet.size() == 1 && !bl2) {
            return this.docDecl.localizeMessage("Diagnosis.MissingAttribute.Simple", startTagInfo.qName, hashSet.iterator().next());
        }
        return this.docDecl.localizeMessage("Diagnosis.MissingAttribute.WrapUp", startTagInfo.qName, this.concatenateMessages(hashSet, bl2, "Diagnosis.MissingAttribute.Separator", "Diagnosis.MissingAttribute.More"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String diagnoseUnexpectedLiteral(StringToken stringToken) {
        StringRecoveryToken stringRecoveryToken = new StringRecoveryToken(stringToken);
        Expression expression = this.docDecl.resCalc.calcResidual(this.expression, stringRecoveryToken);
        if (expression == Expression.nullSet) {
            return this.docDecl.localizeMessage("Diagnosis.StringNotAllowed", stringToken.literal.trim());
        }
        this.expression = this.docDecl.pool.createChoice(this.expression, expression);
        if (stringRecoveryToken.failedExps.size() == 1) {
            DataOrValueExp dataOrValueExp = (DataOrValueExp)stringRecoveryToken.failedExps.iterator().next();
            try {
                dataOrValueExp.getType().checkValid(stringRecoveryToken.literal, stringRecoveryToken.context);
                if (!(dataOrValueExp instanceof ValueExp)) return null;
                ValueExp valueExp = (ValueExp)dataOrValueExp;
                if (valueExp.dt.sameValue(valueExp.value, valueExp.dt.createValue(stringRecoveryToken.literal, stringRecoveryToken.context))) return null;
                return this.docDecl.localizeMessage("Diagnosis.BadLiteral.IncorrectValue", valueExp.value.toString(), stringToken.literal.trim());
            }
            catch (DatatypeException datatypeException) {
                if (datatypeException.getMessage() == null) return this.docDecl.localizeMessage("Diagnosis.BadLiteral.Generic", stringToken.literal.trim());
                return datatypeException.getMessage();
            }
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl2 = false;
            for (DataOrValueExp dataOrValueExp : stringRecoveryToken.failedExps) {
                if (dataOrValueExp instanceof ValueExp) {
                    hashSet.add(((ValueExp)dataOrValueExp).value.toString());
                    continue;
                }
                bl2 = true;
            }
            if (hashSet.size() != 0) return this.docDecl.localizeMessage("Diagnosis.BadLiteral.WrapUp", this.concatenateMessages(hashSet, bl2, "Diagnosis.BadLiteral.Separator", "Diagnosis.BadLiteral.More"), stringToken.literal.trim());
            return null;
        }
    }

    protected String diagnoseUncompletedContent() {
        CombinedChildContentExpCreator combinedChildContentExpCreator = this.docDecl.cccec;
        combinedChildContentExpCreator.get(this.expression, null, false);
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = false;
        ElementExp[] elementExpArray = combinedChildContentExpCreator.getMatchedElements();
        int n2 = combinedChildContentExpCreator.numMatchedElements();
        for (int i2 = 0; i2 < n2; ++i2) {
            NameClass nameClass;
            NameClass nameClass2 = elementExpArray[i2].getNameClass();
            if (nameClass2 instanceof SimpleNameClass) {
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.SimpleNameClass", nameClass2.toString()));
                continue;
            }
            if (nameClass2 instanceof NamespaceNameClass) {
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.NamespaceNameClass", ((NamespaceNameClass)nameClass2).namespaceURI));
                continue;
            }
            if (nameClass2 instanceof NotNameClass && (nameClass = ((NotNameClass)nameClass2).child) instanceof NamespaceNameClass) {
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.NotNamespaceNameClass", ((NamespaceNameClass)nameClass).namespaceURI));
                continue;
            }
            bl2 = true;
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return this.docDecl.localizeMessage("Diagnosis.UncompletedContent.WrapUp", null, this.concatenateMessages(hashSet, bl2, "Diagnosis.UncompletedContent.Separator", "Diagnosis.UncompletedContent.More"));
    }
}

